/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceLevelObjectivesResponse extends ApplicationSignalsResponse implements
        ToCopyableBuilder<ListServiceLevelObjectivesResponse.Builder, ListServiceLevelObjectivesResponse> {
    private static final SdkField<List<ServiceLevelObjectiveSummary>> SLO_SUMMARIES_FIELD = SdkField
            .<List<ServiceLevelObjectiveSummary>> builder(MarshallingType.LIST)
            .memberName("SloSummaries")
            .getter(getter(ListServiceLevelObjectivesResponse::sloSummaries))
            .setter(setter(Builder::sloSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SloSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceLevelObjectiveSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceLevelObjectiveSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListServiceLevelObjectivesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLO_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ServiceLevelObjectiveSummary> sloSummaries;

    private final String nextToken;

    private ListServiceLevelObjectivesResponse(BuilderImpl builder) {
        super(builder);
        this.sloSummaries = builder.sloSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SloSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSloSummaries() {
        return sloSummaries != null && !(sloSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures, where each structure contains information about one SLO.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSloSummaries} method.
     * </p>
     * 
     * @return An array of structures, where each structure contains information about one SLO.
     */
    public final List<ServiceLevelObjectiveSummary> sloSummaries() {
        return sloSummaries;
    }

    /**
     * <p>
     * Include this value in your next use of this API to get next set of service level objectives.
     * </p>
     * 
     * @return Include this value in your next use of this API to get next set of service level objectives.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSloSummaries() ? sloSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceLevelObjectivesResponse)) {
            return false;
        }
        ListServiceLevelObjectivesResponse other = (ListServiceLevelObjectivesResponse) obj;
        return hasSloSummaries() == other.hasSloSummaries() && Objects.equals(sloSummaries(), other.sloSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServiceLevelObjectivesResponse")
                .add("SloSummaries", hasSloSummaries() ? sloSummaries() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SloSummaries":
            return Optional.ofNullable(clazz.cast(sloSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SloSummaries", SLO_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServiceLevelObjectivesResponse, T> g) {
        return obj -> g.apply((ListServiceLevelObjectivesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationSignalsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListServiceLevelObjectivesResponse> {
        /**
         * <p>
         * An array of structures, where each structure contains information about one SLO.
         * </p>
         * 
         * @param sloSummaries
         *        An array of structures, where each structure contains information about one SLO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sloSummaries(Collection<ServiceLevelObjectiveSummary> sloSummaries);

        /**
         * <p>
         * An array of structures, where each structure contains information about one SLO.
         * </p>
         * 
         * @param sloSummaries
         *        An array of structures, where each structure contains information about one SLO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sloSummaries(ServiceLevelObjectiveSummary... sloSummaries);

        /**
         * <p>
         * An array of structures, where each structure contains information about one SLO.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveSummary.Builder#build()}
         * is called immediately and its result is passed to {@link #sloSummaries(List<ServiceLevelObjectiveSummary>)}.
         * 
         * @param sloSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sloSummaries(java.util.Collection<ServiceLevelObjectiveSummary>)
         */
        Builder sloSummaries(Consumer<ServiceLevelObjectiveSummary.Builder>... sloSummaries);

        /**
         * <p>
         * Include this value in your next use of this API to get next set of service level objectives.
         * </p>
         * 
         * @param nextToken
         *        Include this value in your next use of this API to get next set of service level objectives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationSignalsResponse.BuilderImpl implements Builder {
        private List<ServiceLevelObjectiveSummary> sloSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceLevelObjectivesResponse model) {
            super(model);
            sloSummaries(model.sloSummaries);
            nextToken(model.nextToken);
        }

        public final List<ServiceLevelObjectiveSummary.Builder> getSloSummaries() {
            List<ServiceLevelObjectiveSummary.Builder> result = ServiceLevelObjectiveSummariesCopier
                    .copyToBuilder(this.sloSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSloSummaries(Collection<ServiceLevelObjectiveSummary.BuilderImpl> sloSummaries) {
            this.sloSummaries = ServiceLevelObjectiveSummariesCopier.copyFromBuilder(sloSummaries);
        }

        @Override
        public final Builder sloSummaries(Collection<ServiceLevelObjectiveSummary> sloSummaries) {
            this.sloSummaries = ServiceLevelObjectiveSummariesCopier.copy(sloSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sloSummaries(ServiceLevelObjectiveSummary... sloSummaries) {
            sloSummaries(Arrays.asList(sloSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sloSummaries(Consumer<ServiceLevelObjectiveSummary.Builder>... sloSummaries) {
            sloSummaries(Stream.of(sloSummaries).map(c -> ServiceLevelObjectiveSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListServiceLevelObjectivesResponse build() {
            return new ListServiceLevelObjectivesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
