/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains information about one of your services that was discovered by Application Signals.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Service implements SdkPojo, Serializable, ToCopyableBuilder<Service.Builder, Service> {
    private static final SdkField<Map<String, String>> KEY_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("KeyAttributes")
            .getter(getter(Service::keyAttributes))
            .setter(setter(Builder::keyAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Map<String, String>>> ATTRIBUTE_MAPS_FIELD = SdkField
            .<List<Map<String, String>>> builder(MarshallingType.LIST)
            .memberName("AttributeMaps")
            .getter(getter(Service::attributeMaps))
            .setter(setter(Builder::attributeMaps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeMaps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<MetricReference>> METRIC_REFERENCES_FIELD = SdkField
            .<List<MetricReference>> builder(MarshallingType.LIST)
            .memberName("MetricReferences")
            .getter(getter(Service::metricReferences))
            .setter(setter(Builder::metricReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricReferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Map<String, String>>> LOG_GROUP_REFERENCES_FIELD = SdkField
            .<List<Map<String, String>>> builder(MarshallingType.LIST)
            .memberName("LogGroupReferences")
            .getter(getter(Service::logGroupReferences))
            .setter(setter(Builder::logGroupReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupReferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ATTRIBUTES_FIELD,
            ATTRIBUTE_MAPS_FIELD, METRIC_REFERENCES_FIELD, LOG_GROUP_REFERENCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, String> keyAttributes;

    private final List<Map<String, String>> attributeMaps;

    private final List<MetricReference> metricReferences;

    private final List<Map<String, String>> logGroupReferences;

    private Service(BuilderImpl builder) {
        this.keyAttributes = builder.keyAttributes;
        this.attributeMaps = builder.attributeMaps;
        this.metricReferences = builder.metricReferences;
        this.logGroupReferences = builder.logGroupReferences;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeyAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKeyAttributes() {
        return keyAttributes != null && !(keyAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * This is a string-to-string map. It can include the following fields.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Type</code> designates the type of object this is.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the
     * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field
     * is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the
     * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeyAttributes} method.
     * </p>
     * 
     * @return This is a string-to-string map. It can include the following fields.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Type</code> designates the type of object this is.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of
     *         the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Name</code> specifies the name of the object. This is used only if the value of the
     *         <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value
     *         of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
     *         </p>
     *         </li>
     */
    public final Map<String, String> keyAttributes() {
        return keyAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeMaps property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeMaps() {
        return attributeMaps != null && !(attributeMaps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This structure contains one or more string-to-string maps that help identify this service. It can include
     * <i>platform attributes</i>, <i>application attributes</i>, and <i>telemetry attributes</i>.
     * </p>
     * <p>
     * Platform attributes contain information the service's platform.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PlatformType</code> defines the hosted-in platform.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EKS.Cluster</code> is the name of the Amazon EKS cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>K8s.Cluster</code> is the name of the self-hosted Kubernetes cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>K8s.Namespace</code> is the name of the Kubernetes namespace in either Amazon EKS or Kubernetes clusters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>K8s.Workload</code> is the name of the Kubernetes workload in either Amazon EKS or Kubernetes clusters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>K8s.Node</code> is the name of the Kubernetes node in either Amazon EKS or Kubernetes clusters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>K8s.Pod</code> is the name of the Kubernetes pod in either Amazon EKS or Kubernetes clusters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EC2.AutoScalingGroup</code> is the name of the Amazon EC2 Auto Scaling group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EC2.InstanceId</code> is the ID of the Amazon EC2 instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Host</code> is the name of the host, for all platform types.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Application attributes contain information about the application.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS.Application</code> is the application's name in Amazon Web Services Service Catalog AppRegistry.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS.Application.ARN</code> is the application's ARN in Amazon Web Services Service Catalog AppRegistry.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Telemetry attributes contain telemetry information.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Telemetry.SDK</code> is the fingerprint of the OpenTelemetry SDK version for instrumented services.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Telemetry.Agent</code> is the fingerprint of the agent used to collect and send telemetry data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Telemetry.Source</code> Specifies the point of application where the telemetry was collected or specifies
     * what was used for the source of telemetry data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeMaps} method.
     * </p>
     * 
     * @return This structure contains one or more string-to-string maps that help identify this service. It can include
     *         <i>platform attributes</i>, <i>application attributes</i>, and <i>telemetry attributes</i>.</p>
     *         <p>
     *         Platform attributes contain information the service's platform.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PlatformType</code> defines the hosted-in platform.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EKS.Cluster</code> is the name of the Amazon EKS cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>K8s.Cluster</code> is the name of the self-hosted Kubernetes cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>K8s.Namespace</code> is the name of the Kubernetes namespace in either Amazon EKS or Kubernetes
     *         clusters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>K8s.Workload</code> is the name of the Kubernetes workload in either Amazon EKS or Kubernetes
     *         clusters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>K8s.Node</code> is the name of the Kubernetes node in either Amazon EKS or Kubernetes clusters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>K8s.Pod</code> is the name of the Kubernetes pod in either Amazon EKS or Kubernetes clusters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EC2.AutoScalingGroup</code> is the name of the Amazon EC2 Auto Scaling group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EC2.InstanceId</code> is the ID of the Amazon EC2 instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Host</code> is the name of the host, for all platform types.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Application attributes contain information about the application.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS.Application</code> is the application's name in Amazon Web Services Service Catalog
     *         AppRegistry.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS.Application.ARN</code> is the application's ARN in Amazon Web Services Service Catalog
     *         AppRegistry.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Telemetry attributes contain telemetry information.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Telemetry.SDK</code> is the fingerprint of the OpenTelemetry SDK version for instrumented services.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Telemetry.Agent</code> is the fingerprint of the agent used to collect and send telemetry data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Telemetry.Source</code> Specifies the point of application where the telemetry was collected or
     *         specifies what was used for the source of telemetry data.
     *         </p>
     *         </li>
     */
    public final List<Map<String, String>> attributeMaps() {
        return attributeMaps;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricReferences property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricReferences() {
        return metricReferences != null && !(metricReferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures that each contain information about one metric associated with this service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricReferences} method.
     * </p>
     * 
     * @return An array of structures that each contain information about one metric associated with this service.
     */
    public final List<MetricReference> metricReferences() {
        return metricReferences;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogGroupReferences property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogGroupReferences() {
        return logGroupReferences != null && !(logGroupReferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of string-to-string maps that each contain information about one log group associated with this service.
     * Each string-to-string map includes the following fields:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"Type": "AWS::Resource"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"ResourceType": "AWS::Logs::LogGroup"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"Identifier": "<i>name-of-log-group</i>"</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogGroupReferences} method.
     * </p>
     * 
     * @return An array of string-to-string maps that each contain information about one log group associated with this
     *         service. Each string-to-string map includes the following fields:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>"Type": "AWS::Resource"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"ResourceType": "AWS::Logs::LogGroup"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"Identifier": "<i>name-of-log-group</i>"</code>
     *         </p>
     *         </li>
     */
    public final List<Map<String, String>> logGroupReferences() {
        return logGroupReferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasKeyAttributes() ? keyAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeMaps() ? attributeMaps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricReferences() ? metricReferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLogGroupReferences() ? logGroupReferences() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service) obj;
        return hasKeyAttributes() == other.hasKeyAttributes() && Objects.equals(keyAttributes(), other.keyAttributes())
                && hasAttributeMaps() == other.hasAttributeMaps() && Objects.equals(attributeMaps(), other.attributeMaps())
                && hasMetricReferences() == other.hasMetricReferences()
                && Objects.equals(metricReferences(), other.metricReferences())
                && hasLogGroupReferences() == other.hasLogGroupReferences()
                && Objects.equals(logGroupReferences(), other.logGroupReferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Service").add("KeyAttributes", hasKeyAttributes() ? keyAttributes() : null)
                .add("AttributeMaps", hasAttributeMaps() ? attributeMaps() : null)
                .add("MetricReferences", hasMetricReferences() ? metricReferences() : null)
                .add("LogGroupReferences", hasLogGroupReferences() ? logGroupReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyAttributes":
            return Optional.ofNullable(clazz.cast(keyAttributes()));
        case "AttributeMaps":
            return Optional.ofNullable(clazz.cast(attributeMaps()));
        case "MetricReferences":
            return Optional.ofNullable(clazz.cast(metricReferences()));
        case "LogGroupReferences":
            return Optional.ofNullable(clazz.cast(logGroupReferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyAttributes", KEY_ATTRIBUTES_FIELD);
        map.put("AttributeMaps", ATTRIBUTE_MAPS_FIELD);
        map.put("MetricReferences", METRIC_REFERENCES_FIELD);
        map.put("LogGroupReferences", LOG_GROUP_REFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Service, T> g) {
        return obj -> g.apply((Service) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Service> {
        /**
         * <p>
         * This is a string-to-string map. It can include the following fields.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Type</code> designates the type of object this is.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the
         * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code>
         * field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of
         * the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
         * </p>
         * </li>
         * </ul>
         * 
         * @param keyAttributes
         *        This is a string-to-string map. It can include the following fields.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Type</code> designates the type of object this is.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ResourceType</code> specifies the type of the resource. This field is used only when the value
         *        of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Name</code> specifies the name of the object. This is used only if the value of the
         *        <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or
         *        <code>AWS::Service</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Identifier</code> identifies the resource objects of this resource. This is used only if the
         *        value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyAttributes(Map<String, String> keyAttributes);

        /**
         * <p>
         * This structure contains one or more string-to-string maps that help identify this service. It can include
         * <i>platform attributes</i>, <i>application attributes</i>, and <i>telemetry attributes</i>.
         * </p>
         * <p>
         * Platform attributes contain information the service's platform.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PlatformType</code> defines the hosted-in platform.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EKS.Cluster</code> is the name of the Amazon EKS cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>K8s.Cluster</code> is the name of the self-hosted Kubernetes cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>K8s.Namespace</code> is the name of the Kubernetes namespace in either Amazon EKS or Kubernetes
         * clusters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>K8s.Workload</code> is the name of the Kubernetes workload in either Amazon EKS or Kubernetes clusters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>K8s.Node</code> is the name of the Kubernetes node in either Amazon EKS or Kubernetes clusters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>K8s.Pod</code> is the name of the Kubernetes pod in either Amazon EKS or Kubernetes clusters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EC2.AutoScalingGroup</code> is the name of the Amazon EC2 Auto Scaling group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EC2.InstanceId</code> is the ID of the Amazon EC2 instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Host</code> is the name of the host, for all platform types.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Application attributes contain information about the application.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS.Application</code> is the application's name in Amazon Web Services Service Catalog AppRegistry.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS.Application.ARN</code> is the application's ARN in Amazon Web Services Service Catalog AppRegistry.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Telemetry attributes contain telemetry information.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Telemetry.SDK</code> is the fingerprint of the OpenTelemetry SDK version for instrumented services.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Telemetry.Agent</code> is the fingerprint of the agent used to collect and send telemetry data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Telemetry.Source</code> Specifies the point of application where the telemetry was collected or
         * specifies what was used for the source of telemetry data.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributeMaps
         *        This structure contains one or more string-to-string maps that help identify this service. It can
         *        include <i>platform attributes</i>, <i>application attributes</i>, and <i>telemetry
         *        attributes</i>.</p>
         *        <p>
         *        Platform attributes contain information the service's platform.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PlatformType</code> defines the hosted-in platform.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EKS.Cluster</code> is the name of the Amazon EKS cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>K8s.Cluster</code> is the name of the self-hosted Kubernetes cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>K8s.Namespace</code> is the name of the Kubernetes namespace in either Amazon EKS or Kubernetes
         *        clusters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>K8s.Workload</code> is the name of the Kubernetes workload in either Amazon EKS or Kubernetes
         *        clusters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>K8s.Node</code> is the name of the Kubernetes node in either Amazon EKS or Kubernetes clusters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>K8s.Pod</code> is the name of the Kubernetes pod in either Amazon EKS or Kubernetes clusters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EC2.AutoScalingGroup</code> is the name of the Amazon EC2 Auto Scaling group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EC2.InstanceId</code> is the ID of the Amazon EC2 instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Host</code> is the name of the host, for all platform types.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Application attributes contain information about the application.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS.Application</code> is the application's name in Amazon Web Services Service Catalog
         *        AppRegistry.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS.Application.ARN</code> is the application's ARN in Amazon Web Services Service Catalog
         *        AppRegistry.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Telemetry attributes contain telemetry information.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Telemetry.SDK</code> is the fingerprint of the OpenTelemetry SDK version for instrumented
         *        services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Telemetry.Agent</code> is the fingerprint of the agent used to collect and send telemetry data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Telemetry.Source</code> Specifies the point of application where the telemetry was collected or
         *        specifies what was used for the source of telemetry data.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeMaps(Collection<? extends Map<String, String>> attributeMaps);

        /**
         * <p>
         * This structure contains one or more string-to-string maps that help identify this service. It can include
         * <i>platform attributes</i>, <i>application attributes</i>, and <i>telemetry attributes</i>.
         * </p>
         * <p>
         * Platform attributes contain information the service's platform.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PlatformType</code> defines the hosted-in platform.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EKS.Cluster</code> is the name of the Amazon EKS cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>K8s.Cluster</code> is the name of the self-hosted Kubernetes cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>K8s.Namespace</code> is the name of the Kubernetes namespace in either Amazon EKS or Kubernetes
         * clusters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>K8s.Workload</code> is the name of the Kubernetes workload in either Amazon EKS or Kubernetes clusters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>K8s.Node</code> is the name of the Kubernetes node in either Amazon EKS or Kubernetes clusters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>K8s.Pod</code> is the name of the Kubernetes pod in either Amazon EKS or Kubernetes clusters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EC2.AutoScalingGroup</code> is the name of the Amazon EC2 Auto Scaling group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EC2.InstanceId</code> is the ID of the Amazon EC2 instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Host</code> is the name of the host, for all platform types.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Application attributes contain information about the application.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS.Application</code> is the application's name in Amazon Web Services Service Catalog AppRegistry.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS.Application.ARN</code> is the application's ARN in Amazon Web Services Service Catalog AppRegistry.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Telemetry attributes contain telemetry information.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Telemetry.SDK</code> is the fingerprint of the OpenTelemetry SDK version for instrumented services.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Telemetry.Agent</code> is the fingerprint of the agent used to collect and send telemetry data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Telemetry.Source</code> Specifies the point of application where the telemetry was collected or
         * specifies what was used for the source of telemetry data.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributeMaps
         *        This structure contains one or more string-to-string maps that help identify this service. It can
         *        include <i>platform attributes</i>, <i>application attributes</i>, and <i>telemetry
         *        attributes</i>.</p>
         *        <p>
         *        Platform attributes contain information the service's platform.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PlatformType</code> defines the hosted-in platform.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EKS.Cluster</code> is the name of the Amazon EKS cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>K8s.Cluster</code> is the name of the self-hosted Kubernetes cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>K8s.Namespace</code> is the name of the Kubernetes namespace in either Amazon EKS or Kubernetes
         *        clusters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>K8s.Workload</code> is the name of the Kubernetes workload in either Amazon EKS or Kubernetes
         *        clusters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>K8s.Node</code> is the name of the Kubernetes node in either Amazon EKS or Kubernetes clusters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>K8s.Pod</code> is the name of the Kubernetes pod in either Amazon EKS or Kubernetes clusters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EC2.AutoScalingGroup</code> is the name of the Amazon EC2 Auto Scaling group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EC2.InstanceId</code> is the ID of the Amazon EC2 instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Host</code> is the name of the host, for all platform types.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Application attributes contain information about the application.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS.Application</code> is the application's name in Amazon Web Services Service Catalog
         *        AppRegistry.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS.Application.ARN</code> is the application's ARN in Amazon Web Services Service Catalog
         *        AppRegistry.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Telemetry attributes contain telemetry information.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Telemetry.SDK</code> is the fingerprint of the OpenTelemetry SDK version for instrumented
         *        services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Telemetry.Agent</code> is the fingerprint of the agent used to collect and send telemetry data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Telemetry.Source</code> Specifies the point of application where the telemetry was collected or
         *        specifies what was used for the source of telemetry data.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeMaps(Map<String, String>... attributeMaps);

        /**
         * <p>
         * An array of structures that each contain information about one metric associated with this service.
         * </p>
         * 
         * @param metricReferences
         *        An array of structures that each contain information about one metric associated with this service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricReferences(Collection<MetricReference> metricReferences);

        /**
         * <p>
         * An array of structures that each contain information about one metric associated with this service.
         * </p>
         * 
         * @param metricReferences
         *        An array of structures that each contain information about one metric associated with this service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricReferences(MetricReference... metricReferences);

        /**
         * <p>
         * An array of structures that each contain information about one metric associated with this service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricReference.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricReference.Builder#build()} is called
         * immediately and its result is passed to {@link #metricReferences(List<MetricReference>)}.
         * 
         * @param metricReferences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.MetricReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricReferences(java.util.Collection<MetricReference>)
         */
        Builder metricReferences(Consumer<MetricReference.Builder>... metricReferences);

        /**
         * <p>
         * An array of string-to-string maps that each contain information about one log group associated with this
         * service. Each string-to-string map includes the following fields:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>"Type": "AWS::Resource"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"ResourceType": "AWS::Logs::LogGroup"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"Identifier": "<i>name-of-log-group</i>"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param logGroupReferences
         *        An array of string-to-string maps that each contain information about one log group associated with
         *        this service. Each string-to-string map includes the following fields:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>"Type": "AWS::Resource"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"ResourceType": "AWS::Logs::LogGroup"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"Identifier": "<i>name-of-log-group</i>"</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupReferences(Collection<? extends Map<String, String>> logGroupReferences);

        /**
         * <p>
         * An array of string-to-string maps that each contain information about one log group associated with this
         * service. Each string-to-string map includes the following fields:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>"Type": "AWS::Resource"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"ResourceType": "AWS::Logs::LogGroup"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"Identifier": "<i>name-of-log-group</i>"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param logGroupReferences
         *        An array of string-to-string maps that each contain information about one log group associated with
         *        this service. Each string-to-string map includes the following fields:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>"Type": "AWS::Resource"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"ResourceType": "AWS::Logs::LogGroup"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"Identifier": "<i>name-of-log-group</i>"</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupReferences(Map<String, String>... logGroupReferences);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> keyAttributes = DefaultSdkAutoConstructMap.getInstance();

        private List<Map<String, String>> attributeMaps = DefaultSdkAutoConstructList.getInstance();

        private List<MetricReference> metricReferences = DefaultSdkAutoConstructList.getInstance();

        private List<Map<String, String>> logGroupReferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            keyAttributes(model.keyAttributes);
            attributeMaps(model.attributeMaps);
            metricReferences(model.metricReferences);
            logGroupReferences(model.logGroupReferences);
        }

        public final Map<String, String> getKeyAttributes() {
            if (keyAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return keyAttributes;
        }

        public final void setKeyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
        }

        @Override
        public final Builder keyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
            return this;
        }

        public final Collection<? extends Map<String, String>> getAttributeMaps() {
            if (attributeMaps instanceof SdkAutoConstructList) {
                return null;
            }
            return attributeMaps;
        }

        public final void setAttributeMaps(Collection<? extends Map<String, String>> attributeMaps) {
            this.attributeMaps = AttributeMapsCopier.copy(attributeMaps);
        }

        @Override
        public final Builder attributeMaps(Collection<? extends Map<String, String>> attributeMaps) {
            this.attributeMaps = AttributeMapsCopier.copy(attributeMaps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeMaps(Map<String, String>... attributeMaps) {
            attributeMaps(Arrays.asList(attributeMaps));
            return this;
        }

        public final List<MetricReference.Builder> getMetricReferences() {
            List<MetricReference.Builder> result = MetricReferencesCopier.copyToBuilder(this.metricReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricReferences(Collection<MetricReference.BuilderImpl> metricReferences) {
            this.metricReferences = MetricReferencesCopier.copyFromBuilder(metricReferences);
        }

        @Override
        public final Builder metricReferences(Collection<MetricReference> metricReferences) {
            this.metricReferences = MetricReferencesCopier.copy(metricReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricReferences(MetricReference... metricReferences) {
            metricReferences(Arrays.asList(metricReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricReferences(Consumer<MetricReference.Builder>... metricReferences) {
            metricReferences(Stream.of(metricReferences).map(c -> MetricReference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<? extends Map<String, String>> getLogGroupReferences() {
            if (logGroupReferences instanceof SdkAutoConstructList) {
                return null;
            }
            return logGroupReferences;
        }

        public final void setLogGroupReferences(Collection<? extends Map<String, String>> logGroupReferences) {
            this.logGroupReferences = LogGroupReferencesCopier.copy(logGroupReferences);
        }

        @Override
        public final Builder logGroupReferences(Collection<? extends Map<String, String>> logGroupReferences) {
            this.logGroupReferences = LogGroupReferencesCopier.copy(logGroupReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupReferences(Map<String, String>... logGroupReferences) {
            logGroupReferences(Arrays.asList(logGroupReferences));
            return this;
        }

        @Override
        public Service build() {
            return new Service(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
