/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains the information about the metric that is used for a period-based SLO.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceLevelIndicatorMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceLevelIndicatorMetric.Builder, ServiceLevelIndicatorMetric> {
    private static final SdkField<Map<String, String>> KEY_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("KeyAttributes")
            .getter(getter(ServiceLevelIndicatorMetric::keyAttributes))
            .setter(setter(Builder::keyAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationName").getter(getter(ServiceLevelIndicatorMetric::operationName))
            .setter(setter(Builder::operationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationName").build()).build();

    private static final SdkField<String> METRIC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricType").getter(getter(ServiceLevelIndicatorMetric::metricTypeAsString))
            .setter(setter(Builder::metricType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricType").build()).build();

    private static final SdkField<List<MetricDataQuery>> METRIC_DATA_QUERIES_FIELD = SdkField
            .<List<MetricDataQuery>> builder(MarshallingType.LIST)
            .memberName("MetricDataQueries")
            .getter(getter(ServiceLevelIndicatorMetric::metricDataQueries))
            .setter(setter(Builder::metricDataQueries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDataQueries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricDataQuery> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDataQuery::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ATTRIBUTES_FIELD,
            OPERATION_NAME_FIELD, METRIC_TYPE_FIELD, METRIC_DATA_QUERIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, String> keyAttributes;

    private final String operationName;

    private final String metricType;

    private final List<MetricDataQuery> metricDataQueries;

    private ServiceLevelIndicatorMetric(BuilderImpl builder) {
        this.keyAttributes = builder.keyAttributes;
        this.operationName = builder.operationName;
        this.metricType = builder.metricType;
        this.metricDataQueries = builder.metricDataQueries;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeyAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKeyAttributes() {
        return keyAttributes != null && !(keyAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * This is a string-to-string map that contains information about the type of object that this SLO is related to. It
     * can include the following fields.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Type</code> designates the type of object that this SLO is related to.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the
     * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field
     * is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the
     * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeyAttributes} method.
     * </p>
     * 
     * @return This is a string-to-string map that contains information about the type of object that this SLO is
     *         related to. It can include the following fields.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Type</code> designates the type of object that this SLO is related to.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of
     *         the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Name</code> specifies the name of the object. This is used only if the value of the
     *         <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value
     *         of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
     *         </p>
     *         </li>
     */
    public final Map<String, String> keyAttributes() {
        return keyAttributes;
    }

    /**
     * <p>
     * If the SLO monitors a specific operation of the service, this field displays that operation name.
     * </p>
     * 
     * @return If the SLO monitors a specific operation of the service, this field displays that operation name.
     */
    public final String operationName() {
        return operationName;
    }

    /**
     * <p>
     * If the SLO monitors either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that Application Signals
     * collects, this field displays which of those metrics is used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricType} will
     * return {@link ServiceLevelIndicatorMetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #metricTypeAsString}.
     * </p>
     * 
     * @return If the SLO monitors either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that Application
     *         Signals collects, this field displays which of those metrics is used.
     * @see ServiceLevelIndicatorMetricType
     */
    public final ServiceLevelIndicatorMetricType metricType() {
        return ServiceLevelIndicatorMetricType.fromValue(metricType);
    }

    /**
     * <p>
     * If the SLO monitors either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that Application Signals
     * collects, this field displays which of those metrics is used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricType} will
     * return {@link ServiceLevelIndicatorMetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #metricTypeAsString}.
     * </p>
     * 
     * @return If the SLO monitors either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that Application
     *         Signals collects, this field displays which of those metrics is used.
     * @see ServiceLevelIndicatorMetricType
     */
    public final String metricTypeAsString() {
        return metricType;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricDataQueries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricDataQueries() {
        return metricDataQueries != null && !(metricDataQueries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, this structure
     * includes the information about that metric or expression.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricDataQueries} method.
     * </p>
     * 
     * @return If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, this
     *         structure includes the information about that metric or expression.
     */
    public final List<MetricDataQuery> metricDataQueries() {
        return metricDataQueries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasKeyAttributes() ? keyAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(operationName());
        hashCode = 31 * hashCode + Objects.hashCode(metricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricDataQueries() ? metricDataQueries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceLevelIndicatorMetric)) {
            return false;
        }
        ServiceLevelIndicatorMetric other = (ServiceLevelIndicatorMetric) obj;
        return hasKeyAttributes() == other.hasKeyAttributes() && Objects.equals(keyAttributes(), other.keyAttributes())
                && Objects.equals(operationName(), other.operationName())
                && Objects.equals(metricTypeAsString(), other.metricTypeAsString())
                && hasMetricDataQueries() == other.hasMetricDataQueries()
                && Objects.equals(metricDataQueries(), other.metricDataQueries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceLevelIndicatorMetric").add("KeyAttributes", hasKeyAttributes() ? keyAttributes() : null)
                .add("OperationName", operationName()).add("MetricType", metricTypeAsString())
                .add("MetricDataQueries", hasMetricDataQueries() ? metricDataQueries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyAttributes":
            return Optional.ofNullable(clazz.cast(keyAttributes()));
        case "OperationName":
            return Optional.ofNullable(clazz.cast(operationName()));
        case "MetricType":
            return Optional.ofNullable(clazz.cast(metricTypeAsString()));
        case "MetricDataQueries":
            return Optional.ofNullable(clazz.cast(metricDataQueries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyAttributes", KEY_ATTRIBUTES_FIELD);
        map.put("OperationName", OPERATION_NAME_FIELD);
        map.put("MetricType", METRIC_TYPE_FIELD);
        map.put("MetricDataQueries", METRIC_DATA_QUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceLevelIndicatorMetric, T> g) {
        return obj -> g.apply((ServiceLevelIndicatorMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceLevelIndicatorMetric> {
        /**
         * <p>
         * This is a string-to-string map that contains information about the type of object that this SLO is related
         * to. It can include the following fields.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Type</code> designates the type of object that this SLO is related to.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the
         * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code>
         * field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of
         * the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
         * </p>
         * </li>
         * </ul>
         * 
         * @param keyAttributes
         *        This is a string-to-string map that contains information about the type of object that this SLO is
         *        related to. It can include the following fields.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Type</code> designates the type of object that this SLO is related to.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ResourceType</code> specifies the type of the resource. This field is used only when the value
         *        of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Name</code> specifies the name of the object. This is used only if the value of the
         *        <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or
         *        <code>AWS::Service</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Identifier</code> identifies the resource objects of this resource. This is used only if the
         *        value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyAttributes(Map<String, String> keyAttributes);

        /**
         * <p>
         * If the SLO monitors a specific operation of the service, this field displays that operation name.
         * </p>
         * 
         * @param operationName
         *        If the SLO monitors a specific operation of the service, this field displays that operation name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationName(String operationName);

        /**
         * <p>
         * If the SLO monitors either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that Application
         * Signals collects, this field displays which of those metrics is used.
         * </p>
         * 
         * @param metricType
         *        If the SLO monitors either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that
         *        Application Signals collects, this field displays which of those metrics is used.
         * @see ServiceLevelIndicatorMetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceLevelIndicatorMetricType
         */
        Builder metricType(String metricType);

        /**
         * <p>
         * If the SLO monitors either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that Application
         * Signals collects, this field displays which of those metrics is used.
         * </p>
         * 
         * @param metricType
         *        If the SLO monitors either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that
         *        Application Signals collects, this field displays which of those metrics is used.
         * @see ServiceLevelIndicatorMetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceLevelIndicatorMetricType
         */
        Builder metricType(ServiceLevelIndicatorMetricType metricType);

        /**
         * <p>
         * If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, this structure
         * includes the information about that metric or expression.
         * </p>
         * 
         * @param metricDataQueries
         *        If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, this
         *        structure includes the information about that metric or expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDataQueries(Collection<MetricDataQuery> metricDataQueries);

        /**
         * <p>
         * If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, this structure
         * includes the information about that metric or expression.
         * </p>
         * 
         * @param metricDataQueries
         *        If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, this
         *        structure includes the information about that metric or expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDataQueries(MetricDataQuery... metricDataQueries);

        /**
         * <p>
         * If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, this structure
         * includes the information about that metric or expression.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery.Builder#build()} is called
         * immediately and its result is passed to {@link #metricDataQueries(List<MetricDataQuery>)}.
         * 
         * @param metricDataQueries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricDataQueries(java.util.Collection<MetricDataQuery>)
         */
        Builder metricDataQueries(Consumer<MetricDataQuery.Builder>... metricDataQueries);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> keyAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String operationName;

        private String metricType;

        private List<MetricDataQuery> metricDataQueries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLevelIndicatorMetric model) {
            keyAttributes(model.keyAttributes);
            operationName(model.operationName);
            metricType(model.metricType);
            metricDataQueries(model.metricDataQueries);
        }

        public final Map<String, String> getKeyAttributes() {
            if (keyAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return keyAttributes;
        }

        public final void setKeyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
        }

        @Override
        public final Builder keyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
            return this;
        }

        public final String getOperationName() {
            return operationName;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final String getMetricType() {
            return metricType;
        }

        public final void setMetricType(String metricType) {
            this.metricType = metricType;
        }

        @Override
        public final Builder metricType(String metricType) {
            this.metricType = metricType;
            return this;
        }

        @Override
        public final Builder metricType(ServiceLevelIndicatorMetricType metricType) {
            this.metricType(metricType == null ? null : metricType.toString());
            return this;
        }

        public final List<MetricDataQuery.Builder> getMetricDataQueries() {
            List<MetricDataQuery.Builder> result = MetricDataQueriesCopier.copyToBuilder(this.metricDataQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDataQueries(Collection<MetricDataQuery.BuilderImpl> metricDataQueries) {
            this.metricDataQueries = MetricDataQueriesCopier.copyFromBuilder(metricDataQueries);
        }

        @Override
        public final Builder metricDataQueries(Collection<MetricDataQuery> metricDataQueries) {
            this.metricDataQueries = MetricDataQueriesCopier.copy(metricDataQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataQueries(MetricDataQuery... metricDataQueries) {
            metricDataQueries(Arrays.asList(metricDataQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataQueries(Consumer<MetricDataQuery.Builder>... metricDataQueries) {
            metricDataQueries(Stream.of(metricDataQueries).map(c -> MetricDataQuery.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ServiceLevelIndicatorMetric build() {
            return new ServiceLevelIndicatorMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
