/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing an SLO budget report that you have requested.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceLevelObjectiveBudgetReport implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceLevelObjectiveBudgetReport.Builder, ServiceLevelObjectiveBudgetReport> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ServiceLevelObjectiveBudgetReport::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ServiceLevelObjectiveBudgetReport::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> EVALUATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationType").getter(getter(ServiceLevelObjectiveBudgetReport::evaluationTypeAsString))
            .setter(setter(Builder::evaluationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationType").build()).build();

    private static final SdkField<String> BUDGET_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BudgetStatus").getter(getter(ServiceLevelObjectiveBudgetReport::budgetStatusAsString))
            .setter(setter(Builder::budgetStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetStatus").build()).build();

    private static final SdkField<Double> ATTAINMENT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Attainment").getter(getter(ServiceLevelObjectiveBudgetReport::attainment))
            .setter(setter(Builder::attainment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attainment").build()).build();

    private static final SdkField<Integer> TOTAL_BUDGET_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalBudgetSeconds").getter(getter(ServiceLevelObjectiveBudgetReport::totalBudgetSeconds))
            .setter(setter(Builder::totalBudgetSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalBudgetSeconds").build())
            .build();

    private static final SdkField<Integer> BUDGET_SECONDS_REMAINING_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BudgetSecondsRemaining").getter(getter(ServiceLevelObjectiveBudgetReport::budgetSecondsRemaining))
            .setter(setter(Builder::budgetSecondsRemaining))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetSecondsRemaining").build())
            .build();

    private static final SdkField<Integer> TOTAL_BUDGET_REQUESTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalBudgetRequests").getter(getter(ServiceLevelObjectiveBudgetReport::totalBudgetRequests))
            .setter(setter(Builder::totalBudgetRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalBudgetRequests").build())
            .build();

    private static final SdkField<Integer> BUDGET_REQUESTS_REMAINING_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BudgetRequestsRemaining").getter(getter(ServiceLevelObjectiveBudgetReport::budgetRequestsRemaining))
            .setter(setter(Builder::budgetRequestsRemaining))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetRequestsRemaining").build())
            .build();

    private static final SdkField<ServiceLevelIndicator> SLI_FIELD = SdkField
            .<ServiceLevelIndicator> builder(MarshallingType.SDK_POJO).memberName("Sli")
            .getter(getter(ServiceLevelObjectiveBudgetReport::sli)).setter(setter(Builder::sli))
            .constructor(ServiceLevelIndicator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sli").build()).build();

    private static final SdkField<RequestBasedServiceLevelIndicator> REQUEST_BASED_SLI_FIELD = SdkField
            .<RequestBasedServiceLevelIndicator> builder(MarshallingType.SDK_POJO).memberName("RequestBasedSli")
            .getter(getter(ServiceLevelObjectiveBudgetReport::requestBasedSli)).setter(setter(Builder::requestBasedSli))
            .constructor(RequestBasedServiceLevelIndicator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestBasedSli").build()).build();

    private static final SdkField<Goal> GOAL_FIELD = SdkField.<Goal> builder(MarshallingType.SDK_POJO).memberName("Goal")
            .getter(getter(ServiceLevelObjectiveBudgetReport::goal)).setter(setter(Builder::goal)).constructor(Goal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Goal").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            EVALUATION_TYPE_FIELD, BUDGET_STATUS_FIELD, ATTAINMENT_FIELD, TOTAL_BUDGET_SECONDS_FIELD,
            BUDGET_SECONDS_REMAINING_FIELD, TOTAL_BUDGET_REQUESTS_FIELD, BUDGET_REQUESTS_REMAINING_FIELD, SLI_FIELD,
            REQUEST_BASED_SLI_FIELD, GOAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String evaluationType;

    private final String budgetStatus;

    private final Double attainment;

    private final Integer totalBudgetSeconds;

    private final Integer budgetSecondsRemaining;

    private final Integer totalBudgetRequests;

    private final Integer budgetRequestsRemaining;

    private final ServiceLevelIndicator sli;

    private final RequestBasedServiceLevelIndicator requestBasedSli;

    private final Goal goal;

    private ServiceLevelObjectiveBudgetReport(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.evaluationType = builder.evaluationType;
        this.budgetStatus = builder.budgetStatus;
        this.attainment = builder.attainment;
        this.totalBudgetSeconds = builder.totalBudgetSeconds;
        this.budgetSecondsRemaining = builder.budgetSecondsRemaining;
        this.totalBudgetRequests = builder.totalBudgetRequests;
        this.budgetRequestsRemaining = builder.budgetRequestsRemaining;
        this.sli = builder.sli;
        this.requestBasedSli = builder.requestBasedSli;
        this.goal = builder.goal;
    }

    /**
     * <p>
     * The ARN of the SLO that this report is for.
     * </p>
     * 
     * @return The ARN of the SLO that this report is for.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the SLO that this report is for.
     * </p>
     * 
     * @return The name of the SLO that this report is for.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Displays whether this budget report is for a period-based SLO or a request-based SLO.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationType}
     * will return {@link EvaluationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationTypeAsString}.
     * </p>
     * 
     * @return Displays whether this budget report is for a period-based SLO or a request-based SLO.
     * @see EvaluationType
     */
    public final EvaluationType evaluationType() {
        return EvaluationType.fromValue(evaluationType);
    }

    /**
     * <p>
     * Displays whether this budget report is for a period-based SLO or a request-based SLO.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationType}
     * will return {@link EvaluationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationTypeAsString}.
     * </p>
     * 
     * @return Displays whether this budget report is for a period-based SLO or a request-based SLO.
     * @see EvaluationType
     */
    public final String evaluationTypeAsString() {
        return evaluationType;
    }

    /**
     * <p>
     * The status of this SLO, as it relates to the error budget for the entire time interval.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>OK</code> means that the SLO had remaining budget above the warning threshold, as of the time that you
     * specified in <code>TimeStamp</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WARNING</code> means that the SLO's remaining budget was below the warning threshold, as of the time that
     * you specified in <code>TimeStamp</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BREACHED</code> means that the SLO's budget was exhausted, as of the time that you specified in
     * <code>TimeStamp</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSUFFICIENT_DATA</code> means that the specified start and end times were before the SLO was created, or
     * that attainment data is missing.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #budgetStatus} will
     * return {@link ServiceLevelObjectiveBudgetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #budgetStatusAsString}.
     * </p>
     * 
     * @return The status of this SLO, as it relates to the error budget for the entire time interval.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>OK</code> means that the SLO had remaining budget above the warning threshold, as of the time that
     *         you specified in <code>TimeStamp</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARNING</code> means that the SLO's remaining budget was below the warning threshold, as of the
     *         time that you specified in <code>TimeStamp</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BREACHED</code> means that the SLO's budget was exhausted, as of the time that you specified in
     *         <code>TimeStamp</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSUFFICIENT_DATA</code> means that the specified start and end times were before the SLO was
     *         created, or that attainment data is missing.
     *         </p>
     *         </li>
     * @see ServiceLevelObjectiveBudgetStatus
     */
    public final ServiceLevelObjectiveBudgetStatus budgetStatus() {
        return ServiceLevelObjectiveBudgetStatus.fromValue(budgetStatus);
    }

    /**
     * <p>
     * The status of this SLO, as it relates to the error budget for the entire time interval.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>OK</code> means that the SLO had remaining budget above the warning threshold, as of the time that you
     * specified in <code>TimeStamp</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WARNING</code> means that the SLO's remaining budget was below the warning threshold, as of the time that
     * you specified in <code>TimeStamp</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BREACHED</code> means that the SLO's budget was exhausted, as of the time that you specified in
     * <code>TimeStamp</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSUFFICIENT_DATA</code> means that the specified start and end times were before the SLO was created, or
     * that attainment data is missing.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #budgetStatus} will
     * return {@link ServiceLevelObjectiveBudgetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #budgetStatusAsString}.
     * </p>
     * 
     * @return The status of this SLO, as it relates to the error budget for the entire time interval.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>OK</code> means that the SLO had remaining budget above the warning threshold, as of the time that
     *         you specified in <code>TimeStamp</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARNING</code> means that the SLO's remaining budget was below the warning threshold, as of the
     *         time that you specified in <code>TimeStamp</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BREACHED</code> means that the SLO's budget was exhausted, as of the time that you specified in
     *         <code>TimeStamp</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSUFFICIENT_DATA</code> means that the specified start and end times were before the SLO was
     *         created, or that attainment data is missing.
     *         </p>
     *         </li>
     * @see ServiceLevelObjectiveBudgetStatus
     */
    public final String budgetStatusAsString() {
        return budgetStatus;
    }

    /**
     * <p>
     * A number between 0 and 100 that represents the success percentage of your application compared to the goal set by
     * the SLO.
     * </p>
     * <p>
     * If this is a period-based SLO, the number is the percentage of time periods that the service has attained the
     * SLO's attainment goal, as of the time of the request.
     * </p>
     * <p>
     * If this is a request-based SLO, the number is the number of successful requests divided by the number of total
     * requests, multiplied by 100, during the time range that you specified in your request.
     * </p>
     * 
     * @return A number between 0 and 100 that represents the success percentage of your application compared to the
     *         goal set by the SLO.</p>
     *         <p>
     *         If this is a period-based SLO, the number is the percentage of time periods that the service has attained
     *         the SLO's attainment goal, as of the time of the request.
     *         </p>
     *         <p>
     *         If this is a request-based SLO, the number is the number of successful requests divided by the number of
     *         total requests, multiplied by 100, during the time range that you specified in your request.
     */
    public final Double attainment() {
        return attainment;
    }

    /**
     * <p>
     * The total number of seconds in the error budget for the interval. This field is included only if the SLO is a
     * period-based SLO.
     * </p>
     * 
     * @return The total number of seconds in the error budget for the interval. This field is included only if the SLO
     *         is a period-based SLO.
     */
    public final Integer totalBudgetSeconds() {
        return totalBudgetSeconds;
    }

    /**
     * <p>
     * The budget amount remaining before the SLO status becomes <code>BREACHING</code>, at the time specified in the
     * <code>Timestemp</code> parameter of the request. If this value is negative, then the SLO is already in
     * <code>BREACHING</code> status.
     * </p>
     * <p>
     * This field is included only if the SLO is a period-based SLO.
     * </p>
     * 
     * @return The budget amount remaining before the SLO status becomes <code>BREACHING</code>, at the time specified
     *         in the <code>Timestemp</code> parameter of the request. If this value is negative, then the SLO is
     *         already in <code>BREACHING</code> status.</p>
     *         <p>
     *         This field is included only if the SLO is a period-based SLO.
     */
    public final Integer budgetSecondsRemaining() {
        return budgetSecondsRemaining;
    }

    /**
     * <p>
     * This field is displayed only for request-based SLOs. It displays the total number of failed requests that can be
     * tolerated during the time range between the start of the interval and the time stamp supplied in the budget
     * report request. It is based on the total number of requests that occurred, and the percentage specified in the
     * attainment goal. If the number of failed requests matches this number or is higher, then this SLO is currently
     * breaching.
     * </p>
     * <p>
     * This number can go up and down between reports with different time stamps, based on both how many total requests
     * occur.
     * </p>
     * 
     * @return This field is displayed only for request-based SLOs. It displays the total number of failed requests that
     *         can be tolerated during the time range between the start of the interval and the time stamp supplied in
     *         the budget report request. It is based on the total number of requests that occurred, and the percentage
     *         specified in the attainment goal. If the number of failed requests matches this number or is higher, then
     *         this SLO is currently breaching.</p>
     *         <p>
     *         This number can go up and down between reports with different time stamps, based on both how many total
     *         requests occur.
     */
    public final Integer totalBudgetRequests() {
        return totalBudgetRequests;
    }

    /**
     * <p>
     * This field is displayed only for request-based SLOs. It displays the number of failed requests that can be
     * tolerated before any more successful requests occur, and still have the application meet its SLO goal.
     * </p>
     * <p>
     * This number can go up and down between different reports, based on both how many successful requests and how many
     * failed requests occur in that time.
     * </p>
     * 
     * @return This field is displayed only for request-based SLOs. It displays the number of failed requests that can
     *         be tolerated before any more successful requests occur, and still have the application meet its SLO
     *         goal.</p>
     *         <p>
     *         This number can go up and down between different reports, based on both how many successful requests and
     *         how many failed requests occur in that time.
     */
    public final Integer budgetRequestsRemaining() {
        return budgetRequestsRemaining;
    }

    /**
     * <p>
     * A structure that contains information about the performance metric that this SLO monitors.
     * </p>
     * 
     * @return A structure that contains information about the performance metric that this SLO monitors.
     */
    public final ServiceLevelIndicator sli() {
        return sli;
    }

    /**
     * Returns the value of the RequestBasedSli property for this object.
     * 
     * @return The value of the RequestBasedSli property for this object.
     */
    public final RequestBasedServiceLevelIndicator requestBasedSli() {
        return requestBasedSli;
    }

    /**
     * Returns the value of the Goal property for this object.
     * 
     * @return The value of the Goal property for this object.
     */
    public final Goal goal() {
        return goal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(budgetStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(attainment());
        hashCode = 31 * hashCode + Objects.hashCode(totalBudgetSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(budgetSecondsRemaining());
        hashCode = 31 * hashCode + Objects.hashCode(totalBudgetRequests());
        hashCode = 31 * hashCode + Objects.hashCode(budgetRequestsRemaining());
        hashCode = 31 * hashCode + Objects.hashCode(sli());
        hashCode = 31 * hashCode + Objects.hashCode(requestBasedSli());
        hashCode = 31 * hashCode + Objects.hashCode(goal());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceLevelObjectiveBudgetReport)) {
            return false;
        }
        ServiceLevelObjectiveBudgetReport other = (ServiceLevelObjectiveBudgetReport) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(evaluationTypeAsString(), other.evaluationTypeAsString())
                && Objects.equals(budgetStatusAsString(), other.budgetStatusAsString())
                && Objects.equals(attainment(), other.attainment())
                && Objects.equals(totalBudgetSeconds(), other.totalBudgetSeconds())
                && Objects.equals(budgetSecondsRemaining(), other.budgetSecondsRemaining())
                && Objects.equals(totalBudgetRequests(), other.totalBudgetRequests())
                && Objects.equals(budgetRequestsRemaining(), other.budgetRequestsRemaining())
                && Objects.equals(sli(), other.sli()) && Objects.equals(requestBasedSli(), other.requestBasedSli())
                && Objects.equals(goal(), other.goal());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceLevelObjectiveBudgetReport").add("Arn", arn()).add("Name", name())
                .add("EvaluationType", evaluationTypeAsString()).add("BudgetStatus", budgetStatusAsString())
                .add("Attainment", attainment()).add("TotalBudgetSeconds", totalBudgetSeconds())
                .add("BudgetSecondsRemaining", budgetSecondsRemaining()).add("TotalBudgetRequests", totalBudgetRequests())
                .add("BudgetRequestsRemaining", budgetRequestsRemaining()).add("Sli", sli())
                .add("RequestBasedSli", requestBasedSli()).add("Goal", goal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "EvaluationType":
            return Optional.ofNullable(clazz.cast(evaluationTypeAsString()));
        case "BudgetStatus":
            return Optional.ofNullable(clazz.cast(budgetStatusAsString()));
        case "Attainment":
            return Optional.ofNullable(clazz.cast(attainment()));
        case "TotalBudgetSeconds":
            return Optional.ofNullable(clazz.cast(totalBudgetSeconds()));
        case "BudgetSecondsRemaining":
            return Optional.ofNullable(clazz.cast(budgetSecondsRemaining()));
        case "TotalBudgetRequests":
            return Optional.ofNullable(clazz.cast(totalBudgetRequests()));
        case "BudgetRequestsRemaining":
            return Optional.ofNullable(clazz.cast(budgetRequestsRemaining()));
        case "Sli":
            return Optional.ofNullable(clazz.cast(sli()));
        case "RequestBasedSli":
            return Optional.ofNullable(clazz.cast(requestBasedSli()));
        case "Goal":
            return Optional.ofNullable(clazz.cast(goal()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("EvaluationType", EVALUATION_TYPE_FIELD);
        map.put("BudgetStatus", BUDGET_STATUS_FIELD);
        map.put("Attainment", ATTAINMENT_FIELD);
        map.put("TotalBudgetSeconds", TOTAL_BUDGET_SECONDS_FIELD);
        map.put("BudgetSecondsRemaining", BUDGET_SECONDS_REMAINING_FIELD);
        map.put("TotalBudgetRequests", TOTAL_BUDGET_REQUESTS_FIELD);
        map.put("BudgetRequestsRemaining", BUDGET_REQUESTS_REMAINING_FIELD);
        map.put("Sli", SLI_FIELD);
        map.put("RequestBasedSli", REQUEST_BASED_SLI_FIELD);
        map.put("Goal", GOAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceLevelObjectiveBudgetReport, T> g) {
        return obj -> g.apply((ServiceLevelObjectiveBudgetReport) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceLevelObjectiveBudgetReport> {
        /**
         * <p>
         * The ARN of the SLO that this report is for.
         * </p>
         * 
         * @param arn
         *        The ARN of the SLO that this report is for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the SLO that this report is for.
         * </p>
         * 
         * @param name
         *        The name of the SLO that this report is for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Displays whether this budget report is for a period-based SLO or a request-based SLO.
         * </p>
         * 
         * @param evaluationType
         *        Displays whether this budget report is for a period-based SLO or a request-based SLO.
         * @see EvaluationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationType
         */
        Builder evaluationType(String evaluationType);

        /**
         * <p>
         * Displays whether this budget report is for a period-based SLO or a request-based SLO.
         * </p>
         * 
         * @param evaluationType
         *        Displays whether this budget report is for a period-based SLO or a request-based SLO.
         * @see EvaluationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationType
         */
        Builder evaluationType(EvaluationType evaluationType);

        /**
         * <p>
         * The status of this SLO, as it relates to the error budget for the entire time interval.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>OK</code> means that the SLO had remaining budget above the warning threshold, as of the time that you
         * specified in <code>TimeStamp</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WARNING</code> means that the SLO's remaining budget was below the warning threshold, as of the time
         * that you specified in <code>TimeStamp</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BREACHED</code> means that the SLO's budget was exhausted, as of the time that you specified in
         * <code>TimeStamp</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSUFFICIENT_DATA</code> means that the specified start and end times were before the SLO was created,
         * or that attainment data is missing.
         * </p>
         * </li>
         * </ul>
         * 
         * @param budgetStatus
         *        The status of this SLO, as it relates to the error budget for the entire time interval.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>OK</code> means that the SLO had remaining budget above the warning threshold, as of the time
         *        that you specified in <code>TimeStamp</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARNING</code> means that the SLO's remaining budget was below the warning threshold, as of the
         *        time that you specified in <code>TimeStamp</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BREACHED</code> means that the SLO's budget was exhausted, as of the time that you specified in
         *        <code>TimeStamp</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSUFFICIENT_DATA</code> means that the specified start and end times were before the SLO was
         *        created, or that attainment data is missing.
         *        </p>
         *        </li>
         * @see ServiceLevelObjectiveBudgetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceLevelObjectiveBudgetStatus
         */
        Builder budgetStatus(String budgetStatus);

        /**
         * <p>
         * The status of this SLO, as it relates to the error budget for the entire time interval.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>OK</code> means that the SLO had remaining budget above the warning threshold, as of the time that you
         * specified in <code>TimeStamp</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WARNING</code> means that the SLO's remaining budget was below the warning threshold, as of the time
         * that you specified in <code>TimeStamp</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BREACHED</code> means that the SLO's budget was exhausted, as of the time that you specified in
         * <code>TimeStamp</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSUFFICIENT_DATA</code> means that the specified start and end times were before the SLO was created,
         * or that attainment data is missing.
         * </p>
         * </li>
         * </ul>
         * 
         * @param budgetStatus
         *        The status of this SLO, as it relates to the error budget for the entire time interval.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>OK</code> means that the SLO had remaining budget above the warning threshold, as of the time
         *        that you specified in <code>TimeStamp</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARNING</code> means that the SLO's remaining budget was below the warning threshold, as of the
         *        time that you specified in <code>TimeStamp</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BREACHED</code> means that the SLO's budget was exhausted, as of the time that you specified in
         *        <code>TimeStamp</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSUFFICIENT_DATA</code> means that the specified start and end times were before the SLO was
         *        created, or that attainment data is missing.
         *        </p>
         *        </li>
         * @see ServiceLevelObjectiveBudgetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceLevelObjectiveBudgetStatus
         */
        Builder budgetStatus(ServiceLevelObjectiveBudgetStatus budgetStatus);

        /**
         * <p>
         * A number between 0 and 100 that represents the success percentage of your application compared to the goal
         * set by the SLO.
         * </p>
         * <p>
         * If this is a period-based SLO, the number is the percentage of time periods that the service has attained the
         * SLO's attainment goal, as of the time of the request.
         * </p>
         * <p>
         * If this is a request-based SLO, the number is the number of successful requests divided by the number of
         * total requests, multiplied by 100, during the time range that you specified in your request.
         * </p>
         * 
         * @param attainment
         *        A number between 0 and 100 that represents the success percentage of your application compared to the
         *        goal set by the SLO.</p>
         *        <p>
         *        If this is a period-based SLO, the number is the percentage of time periods that the service has
         *        attained the SLO's attainment goal, as of the time of the request.
         *        </p>
         *        <p>
         *        If this is a request-based SLO, the number is the number of successful requests divided by the number
         *        of total requests, multiplied by 100, during the time range that you specified in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attainment(Double attainment);

        /**
         * <p>
         * The total number of seconds in the error budget for the interval. This field is included only if the SLO is a
         * period-based SLO.
         * </p>
         * 
         * @param totalBudgetSeconds
         *        The total number of seconds in the error budget for the interval. This field is included only if the
         *        SLO is a period-based SLO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalBudgetSeconds(Integer totalBudgetSeconds);

        /**
         * <p>
         * The budget amount remaining before the SLO status becomes <code>BREACHING</code>, at the time specified in
         * the <code>Timestemp</code> parameter of the request. If this value is negative, then the SLO is already in
         * <code>BREACHING</code> status.
         * </p>
         * <p>
         * This field is included only if the SLO is a period-based SLO.
         * </p>
         * 
         * @param budgetSecondsRemaining
         *        The budget amount remaining before the SLO status becomes <code>BREACHING</code>, at the time
         *        specified in the <code>Timestemp</code> parameter of the request. If this value is negative, then the
         *        SLO is already in <code>BREACHING</code> status.</p>
         *        <p>
         *        This field is included only if the SLO is a period-based SLO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetSecondsRemaining(Integer budgetSecondsRemaining);

        /**
         * <p>
         * This field is displayed only for request-based SLOs. It displays the total number of failed requests that can
         * be tolerated during the time range between the start of the interval and the time stamp supplied in the
         * budget report request. It is based on the total number of requests that occurred, and the percentage
         * specified in the attainment goal. If the number of failed requests matches this number or is higher, then
         * this SLO is currently breaching.
         * </p>
         * <p>
         * This number can go up and down between reports with different time stamps, based on both how many total
         * requests occur.
         * </p>
         * 
         * @param totalBudgetRequests
         *        This field is displayed only for request-based SLOs. It displays the total number of failed requests
         *        that can be tolerated during the time range between the start of the interval and the time stamp
         *        supplied in the budget report request. It is based on the total number of requests that occurred, and
         *        the percentage specified in the attainment goal. If the number of failed requests matches this number
         *        or is higher, then this SLO is currently breaching.</p>
         *        <p>
         *        This number can go up and down between reports with different time stamps, based on both how many
         *        total requests occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalBudgetRequests(Integer totalBudgetRequests);

        /**
         * <p>
         * This field is displayed only for request-based SLOs. It displays the number of failed requests that can be
         * tolerated before any more successful requests occur, and still have the application meet its SLO goal.
         * </p>
         * <p>
         * This number can go up and down between different reports, based on both how many successful requests and how
         * many failed requests occur in that time.
         * </p>
         * 
         * @param budgetRequestsRemaining
         *        This field is displayed only for request-based SLOs. It displays the number of failed requests that
         *        can be tolerated before any more successful requests occur, and still have the application meet its
         *        SLO goal.</p>
         *        <p>
         *        This number can go up and down between different reports, based on both how many successful requests
         *        and how many failed requests occur in that time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetRequestsRemaining(Integer budgetRequestsRemaining);

        /**
         * <p>
         * A structure that contains information about the performance metric that this SLO monitors.
         * </p>
         * 
         * @param sli
         *        A structure that contains information about the performance metric that this SLO monitors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sli(ServiceLevelIndicator sli);

        /**
         * <p>
         * A structure that contains information about the performance metric that this SLO monitors.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceLevelIndicator.Builder} avoiding
         * the need to create one manually via {@link ServiceLevelIndicator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceLevelIndicator.Builder#build()} is called immediately and
         * its result is passed to {@link #sli(ServiceLevelIndicator)}.
         * 
         * @param sli
         *        a consumer that will call methods on {@link ServiceLevelIndicator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sli(ServiceLevelIndicator)
         */
        default Builder sli(Consumer<ServiceLevelIndicator.Builder> sli) {
            return sli(ServiceLevelIndicator.builder().applyMutation(sli).build());
        }

        /**
         * Sets the value of the RequestBasedSli property for this object.
         *
         * @param requestBasedSli
         *        The new value for the RequestBasedSli property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestBasedSli(RequestBasedServiceLevelIndicator requestBasedSli);

        /**
         * Sets the value of the RequestBasedSli property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link RequestBasedServiceLevelIndicator.Builder} avoiding the need to create one manually via
         * {@link RequestBasedServiceLevelIndicator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RequestBasedServiceLevelIndicator.Builder#build()} is called
         * immediately and its result is passed to {@link #requestBasedSli(RequestBasedServiceLevelIndicator)}.
         * 
         * @param requestBasedSli
         *        a consumer that will call methods on {@link RequestBasedServiceLevelIndicator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestBasedSli(RequestBasedServiceLevelIndicator)
         */
        default Builder requestBasedSli(Consumer<RequestBasedServiceLevelIndicator.Builder> requestBasedSli) {
            return requestBasedSli(RequestBasedServiceLevelIndicator.builder().applyMutation(requestBasedSli).build());
        }

        /**
         * Sets the value of the Goal property for this object.
         *
         * @param goal
         *        The new value for the Goal property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder goal(Goal goal);

        /**
         * Sets the value of the Goal property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Goal.Builder} avoiding the need to create
         * one manually via {@link Goal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Goal.Builder#build()} is called immediately and its result is
         * passed to {@link #goal(Goal)}.
         * 
         * @param goal
         *        a consumer that will call methods on {@link Goal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #goal(Goal)
         */
        default Builder goal(Consumer<Goal.Builder> goal) {
            return goal(Goal.builder().applyMutation(goal).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String evaluationType;

        private String budgetStatus;

        private Double attainment;

        private Integer totalBudgetSeconds;

        private Integer budgetSecondsRemaining;

        private Integer totalBudgetRequests;

        private Integer budgetRequestsRemaining;

        private ServiceLevelIndicator sli;

        private RequestBasedServiceLevelIndicator requestBasedSli;

        private Goal goal;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLevelObjectiveBudgetReport model) {
            arn(model.arn);
            name(model.name);
            evaluationType(model.evaluationType);
            budgetStatus(model.budgetStatus);
            attainment(model.attainment);
            totalBudgetSeconds(model.totalBudgetSeconds);
            budgetSecondsRemaining(model.budgetSecondsRemaining);
            totalBudgetRequests(model.totalBudgetRequests);
            budgetRequestsRemaining(model.budgetRequestsRemaining);
            sli(model.sli);
            requestBasedSli(model.requestBasedSli);
            goal(model.goal);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEvaluationType() {
            return evaluationType;
        }

        public final void setEvaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
        }

        @Override
        public final Builder evaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
            return this;
        }

        @Override
        public final Builder evaluationType(EvaluationType evaluationType) {
            this.evaluationType(evaluationType == null ? null : evaluationType.toString());
            return this;
        }

        public final String getBudgetStatus() {
            return budgetStatus;
        }

        public final void setBudgetStatus(String budgetStatus) {
            this.budgetStatus = budgetStatus;
        }

        @Override
        public final Builder budgetStatus(String budgetStatus) {
            this.budgetStatus = budgetStatus;
            return this;
        }

        @Override
        public final Builder budgetStatus(ServiceLevelObjectiveBudgetStatus budgetStatus) {
            this.budgetStatus(budgetStatus == null ? null : budgetStatus.toString());
            return this;
        }

        public final Double getAttainment() {
            return attainment;
        }

        public final void setAttainment(Double attainment) {
            this.attainment = attainment;
        }

        @Override
        public final Builder attainment(Double attainment) {
            this.attainment = attainment;
            return this;
        }

        public final Integer getTotalBudgetSeconds() {
            return totalBudgetSeconds;
        }

        public final void setTotalBudgetSeconds(Integer totalBudgetSeconds) {
            this.totalBudgetSeconds = totalBudgetSeconds;
        }

        @Override
        public final Builder totalBudgetSeconds(Integer totalBudgetSeconds) {
            this.totalBudgetSeconds = totalBudgetSeconds;
            return this;
        }

        public final Integer getBudgetSecondsRemaining() {
            return budgetSecondsRemaining;
        }

        public final void setBudgetSecondsRemaining(Integer budgetSecondsRemaining) {
            this.budgetSecondsRemaining = budgetSecondsRemaining;
        }

        @Override
        public final Builder budgetSecondsRemaining(Integer budgetSecondsRemaining) {
            this.budgetSecondsRemaining = budgetSecondsRemaining;
            return this;
        }

        public final Integer getTotalBudgetRequests() {
            return totalBudgetRequests;
        }

        public final void setTotalBudgetRequests(Integer totalBudgetRequests) {
            this.totalBudgetRequests = totalBudgetRequests;
        }

        @Override
        public final Builder totalBudgetRequests(Integer totalBudgetRequests) {
            this.totalBudgetRequests = totalBudgetRequests;
            return this;
        }

        public final Integer getBudgetRequestsRemaining() {
            return budgetRequestsRemaining;
        }

        public final void setBudgetRequestsRemaining(Integer budgetRequestsRemaining) {
            this.budgetRequestsRemaining = budgetRequestsRemaining;
        }

        @Override
        public final Builder budgetRequestsRemaining(Integer budgetRequestsRemaining) {
            this.budgetRequestsRemaining = budgetRequestsRemaining;
            return this;
        }

        public final ServiceLevelIndicator.Builder getSli() {
            return sli != null ? sli.toBuilder() : null;
        }

        public final void setSli(ServiceLevelIndicator.BuilderImpl sli) {
            this.sli = sli != null ? sli.build() : null;
        }

        @Override
        public final Builder sli(ServiceLevelIndicator sli) {
            this.sli = sli;
            return this;
        }

        public final RequestBasedServiceLevelIndicator.Builder getRequestBasedSli() {
            return requestBasedSli != null ? requestBasedSli.toBuilder() : null;
        }

        public final void setRequestBasedSli(RequestBasedServiceLevelIndicator.BuilderImpl requestBasedSli) {
            this.requestBasedSli = requestBasedSli != null ? requestBasedSli.build() : null;
        }

        @Override
        public final Builder requestBasedSli(RequestBasedServiceLevelIndicator requestBasedSli) {
            this.requestBasedSli = requestBasedSli;
            return this;
        }

        public final Goal.Builder getGoal() {
            return goal != null ? goal.toBuilder() : null;
        }

        public final void setGoal(Goal.BuilderImpl goal) {
            this.goal = goal != null ? goal.build() : null;
        }

        @Override
        public final Builder goal(Goal goal) {
            this.goal = goal;
            return this;
        }

        @Override
        public ServiceLevelObjectiveBudgetReport build() {
            return new ServiceLevelObjectiveBudgetReport(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
