/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.applicationsignals.model.AttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DependencyConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DependencyConfig> {
    private static final SdkField<Map<String, String>> DEPENDENCY_KEY_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DependencyKeyAttributes").getter(DependencyConfig.getter(DependencyConfig::dependencyKeyAttributes)).setter(DependencyConfig.setter(Builder::dependencyKeyAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependencyKeyAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DEPENDENCY_OPERATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DependencyOperationName").getter(DependencyConfig.getter(DependencyConfig::dependencyOperationName)).setter(DependencyConfig.setter(Builder::dependencyOperationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependencyOperationName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPENDENCY_KEY_ATTRIBUTES_FIELD, DEPENDENCY_OPERATION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DependencyConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> dependencyKeyAttributes;
    private final String dependencyOperationName;

    private DependencyConfig(BuilderImpl builder) {
        this.dependencyKeyAttributes = builder.dependencyKeyAttributes;
        this.dependencyOperationName = builder.dependencyOperationName;
    }

    public final boolean hasDependencyKeyAttributes() {
        return this.dependencyKeyAttributes != null && !(this.dependencyKeyAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> dependencyKeyAttributes() {
        return this.dependencyKeyAttributes;
    }

    public final String dependencyOperationName() {
        return this.dependencyOperationName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependencyKeyAttributes() ? this.dependencyKeyAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dependencyOperationName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DependencyConfig)) {
            return false;
        }
        DependencyConfig other = (DependencyConfig)obj;
        return this.hasDependencyKeyAttributes() == other.hasDependencyKeyAttributes() && Objects.equals(this.dependencyKeyAttributes(), other.dependencyKeyAttributes()) && Objects.equals(this.dependencyOperationName(), other.dependencyOperationName());
    }

    public final String toString() {
        return ToString.builder((String)"DependencyConfig").add("DependencyKeyAttributes", this.hasDependencyKeyAttributes() ? this.dependencyKeyAttributes() : null).add("DependencyOperationName", (Object)this.dependencyOperationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DependencyKeyAttributes": {
                return Optional.ofNullable(clazz.cast(this.dependencyKeyAttributes()));
            }
            case "DependencyOperationName": {
                return Optional.ofNullable(clazz.cast(this.dependencyOperationName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DependencyKeyAttributes", DEPENDENCY_KEY_ATTRIBUTES_FIELD);
        map.put("DependencyOperationName", DEPENDENCY_OPERATION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DependencyConfig, T> g) {
        return obj -> g.apply((DependencyConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> dependencyKeyAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String dependencyOperationName;

        private BuilderImpl() {
        }

        private BuilderImpl(DependencyConfig model) {
            this.dependencyKeyAttributes(model.dependencyKeyAttributes);
            this.dependencyOperationName(model.dependencyOperationName);
        }

        public final Map<String, String> getDependencyKeyAttributes() {
            if (this.dependencyKeyAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.dependencyKeyAttributes;
        }

        public final void setDependencyKeyAttributes(Map<String, String> dependencyKeyAttributes) {
            this.dependencyKeyAttributes = AttributesCopier.copy(dependencyKeyAttributes);
        }

        @Override
        public final Builder dependencyKeyAttributes(Map<String, String> dependencyKeyAttributes) {
            this.dependencyKeyAttributes = AttributesCopier.copy(dependencyKeyAttributes);
            return this;
        }

        public final String getDependencyOperationName() {
            return this.dependencyOperationName;
        }

        public final void setDependencyOperationName(String dependencyOperationName) {
            this.dependencyOperationName = dependencyOperationName;
        }

        @Override
        public final Builder dependencyOperationName(String dependencyOperationName) {
            this.dependencyOperationName = dependencyOperationName;
            return this;
        }

        public DependencyConfig build() {
            return new DependencyConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DependencyConfig> {
        public Builder dependencyKeyAttributes(Map<String, String> var1);

        public Builder dependencyOperationName(String var1);
    }
}

