/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationsignals.model.ApplicationSignalsResponse;
import software.amazon.awssdk.services.applicationsignals.model.ServiceDependent;
import software.amazon.awssdk.services.applicationsignals.model.ServiceDependentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServiceDependentsResponse
extends ApplicationSignalsResponse
implements ToCopyableBuilder<Builder, ListServiceDependentsResponse> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ListServiceDependentsResponse.getter(ListServiceDependentsResponse::startTime)).setter(ListServiceDependentsResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ListServiceDependentsResponse.getter(ListServiceDependentsResponse::endTime)).setter(ListServiceDependentsResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<List<ServiceDependent>> SERVICE_DEPENDENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceDependents").getter(ListServiceDependentsResponse.getter(ListServiceDependentsResponse::serviceDependents)).setter(ListServiceDependentsResponse.setter(Builder::serviceDependents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceDependents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceDependent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListServiceDependentsResponse.getter(ListServiceDependentsResponse::nextToken)).setter(ListServiceDependentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD, END_TIME_FIELD, SERVICE_DEPENDENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListServiceDependentsResponse.memberNameToFieldInitializer();
    private final Instant startTime;
    private final Instant endTime;
    private final List<ServiceDependent> serviceDependents;
    private final String nextToken;

    private ListServiceDependentsResponse(BuilderImpl builder) {
        super(builder);
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.serviceDependents = builder.serviceDependents;
        this.nextToken = builder.nextToken;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final boolean hasServiceDependents() {
        return this.serviceDependents != null && !(this.serviceDependents instanceof SdkAutoConstructList);
    }

    public final List<ServiceDependent> serviceDependents() {
        return this.serviceDependents;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceDependents() ? this.serviceDependents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceDependentsResponse)) {
            return false;
        }
        ListServiceDependentsResponse other = (ListServiceDependentsResponse)((Object)obj);
        return Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasServiceDependents() == other.hasServiceDependents() && Objects.equals(this.serviceDependents(), other.serviceDependents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListServiceDependentsResponse").add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("ServiceDependents", this.hasServiceDependents() ? this.serviceDependents() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "ServiceDependents": {
                return Optional.ofNullable(clazz.cast(this.serviceDependents()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("ServiceDependents", SERVICE_DEPENDENTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServiceDependentsResponse, T> g) {
        return obj -> g.apply((ListServiceDependentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationSignalsResponse.BuilderImpl
    implements Builder {
        private Instant startTime;
        private Instant endTime;
        private List<ServiceDependent> serviceDependents = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceDependentsResponse model) {
            super(model);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.serviceDependents(model.serviceDependents);
            this.nextToken(model.nextToken);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<ServiceDependent.Builder> getServiceDependents() {
            List<ServiceDependent.Builder> result = ServiceDependentsCopier.copyToBuilder(this.serviceDependents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceDependents(Collection<ServiceDependent.BuilderImpl> serviceDependents) {
            this.serviceDependents = ServiceDependentsCopier.copyFromBuilder(serviceDependents);
        }

        @Override
        public final Builder serviceDependents(Collection<ServiceDependent> serviceDependents) {
            this.serviceDependents = ServiceDependentsCopier.copy(serviceDependents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDependents(ServiceDependent ... serviceDependents) {
            this.serviceDependents(Arrays.asList(serviceDependents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDependents(Consumer<ServiceDependent.Builder> ... serviceDependents) {
            this.serviceDependents(Stream.of(serviceDependents).map(c -> (ServiceDependent)((ServiceDependent.Builder)ServiceDependent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListServiceDependentsResponse build() {
            return new ListServiceDependentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApplicationSignalsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServiceDependentsResponse> {
        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder serviceDependents(Collection<ServiceDependent> var1);

        public Builder serviceDependents(ServiceDependent ... var1);

        public Builder serviceDependents(Consumer<ServiceDependent.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

