/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.applicationsignals.model.AccessDeniedException;
import software.amazon.awssdk.services.applicationsignals.model.ApplicationSignalsException;
import software.amazon.awssdk.services.applicationsignals.model.BatchGetServiceLevelObjectiveBudgetReportRequest;
import software.amazon.awssdk.services.applicationsignals.model.BatchGetServiceLevelObjectiveBudgetReportResponse;
import software.amazon.awssdk.services.applicationsignals.model.BatchUpdateExclusionWindowsRequest;
import software.amazon.awssdk.services.applicationsignals.model.BatchUpdateExclusionWindowsResponse;
import software.amazon.awssdk.services.applicationsignals.model.ConflictException;
import software.amazon.awssdk.services.applicationsignals.model.CreateServiceLevelObjectiveRequest;
import software.amazon.awssdk.services.applicationsignals.model.CreateServiceLevelObjectiveResponse;
import software.amazon.awssdk.services.applicationsignals.model.DeleteServiceLevelObjectiveRequest;
import software.amazon.awssdk.services.applicationsignals.model.DeleteServiceLevelObjectiveResponse;
import software.amazon.awssdk.services.applicationsignals.model.GetServiceLevelObjectiveRequest;
import software.amazon.awssdk.services.applicationsignals.model.GetServiceLevelObjectiveResponse;
import software.amazon.awssdk.services.applicationsignals.model.GetServiceRequest;
import software.amazon.awssdk.services.applicationsignals.model.GetServiceResponse;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceDependenciesRequest;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceDependenciesResponse;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceDependentsRequest;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceDependentsResponse;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectiveExclusionWindowsRequest;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectiveExclusionWindowsResponse;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectivesRequest;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectivesResponse;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceOperationsRequest;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceOperationsResponse;
import software.amazon.awssdk.services.applicationsignals.model.ListServicesRequest;
import software.amazon.awssdk.services.applicationsignals.model.ListServicesResponse;
import software.amazon.awssdk.services.applicationsignals.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.applicationsignals.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.applicationsignals.model.ResourceNotFoundException;
import software.amazon.awssdk.services.applicationsignals.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.applicationsignals.model.StartDiscoveryRequest;
import software.amazon.awssdk.services.applicationsignals.model.StartDiscoveryResponse;
import software.amazon.awssdk.services.applicationsignals.model.TagResourceRequest;
import software.amazon.awssdk.services.applicationsignals.model.TagResourceResponse;
import software.amazon.awssdk.services.applicationsignals.model.ThrottlingException;
import software.amazon.awssdk.services.applicationsignals.model.UntagResourceRequest;
import software.amazon.awssdk.services.applicationsignals.model.UntagResourceResponse;
import software.amazon.awssdk.services.applicationsignals.model.UpdateServiceLevelObjectiveRequest;
import software.amazon.awssdk.services.applicationsignals.model.UpdateServiceLevelObjectiveResponse;
import software.amazon.awssdk.services.applicationsignals.model.ValidationException;
import software.amazon.awssdk.services.applicationsignals.paginators.ListServiceDependenciesIterable;
import software.amazon.awssdk.services.applicationsignals.paginators.ListServiceDependentsIterable;
import software.amazon.awssdk.services.applicationsignals.paginators.ListServiceLevelObjectiveExclusionWindowsIterable;
import software.amazon.awssdk.services.applicationsignals.paginators.ListServiceLevelObjectivesIterable;
import software.amazon.awssdk.services.applicationsignals.paginators.ListServiceOperationsIterable;
import software.amazon.awssdk.services.applicationsignals.paginators.ListServicesIterable;

/**
 * Service client for accessing Amazon CloudWatch Application Signals. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Use CloudWatch Application Signals for comprehensive observability of your cloud-based applications. It enables
 * real-time service health dashboards and helps you track long-term performance trends against your business goals. The
 * application-centric view provides you with unified visibility across your applications, services, and dependencies,
 * so you can proactively monitor and efficiently triage any issues that may arise, ensuring optimal customer
 * experience.
 * </p>
 * <p>
 * Application Signals provides the following benefits:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Automatically collect metrics and traces from your applications, and display key metrics such as call volume,
 * availability, latency, faults, and errors.
 * </p>
 * </li>
 * <li>
 * <p>
 * Create and monitor service level objectives (SLOs).
 * </p>
 * </li>
 * <li>
 * <p>
 * See a map of your application topology that Application Signals automatically discovers, that gives you a visual
 * representation of your applications, dependencies, and their connectivity.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Application Signals works with CloudWatch RUM, CloudWatch Synthetics canaries, and Amazon Web Services Service
 * Catalog AppRegistry, to display your client pages, Synthetics canaries, and application names within dashboards and
 * maps.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ApplicationSignalsClient extends AwsClient {
    String SERVICE_NAME = "application-signals";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "application-signals";

    /**
     * <p>
     * Use this operation to retrieve one or more <i>service level objective (SLO) budget reports</i>.
     * </p>
     * <p>
     * An <i>error budget</i> is the amount of time or requests in an unhealthy state that your service can accumulate
     * during an interval before your overall SLO budget health is breached and the SLO is considered to be unmet. For
     * example, an SLO with a threshold of 99.95% and a monthly interval translates to an error budget of 21.9 minutes
     * of downtime in a 30-day month.
     * </p>
     * <p>
     * Budget reports include a health indicator, the attainment value, and remaining budget.
     * </p>
     * <p>
     * For more information about SLO error budgets, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-ServiceLevelObjectives.html#CloudWatch-ServiceLevelObjectives-concepts"
     * > SLO concepts</a>.
     * </p>
     *
     * @param batchGetServiceLevelObjectiveBudgetReportRequest
     * @return Result of the BatchGetServiceLevelObjectiveBudgetReport operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.BatchGetServiceLevelObjectiveBudgetReport
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/BatchGetServiceLevelObjectiveBudgetReport"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetServiceLevelObjectiveBudgetReportResponse batchGetServiceLevelObjectiveBudgetReport(
            BatchGetServiceLevelObjectiveBudgetReportRequest batchGetServiceLevelObjectiveBudgetReportRequest)
            throws ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to retrieve one or more <i>service level objective (SLO) budget reports</i>.
     * </p>
     * <p>
     * An <i>error budget</i> is the amount of time or requests in an unhealthy state that your service can accumulate
     * during an interval before your overall SLO budget health is breached and the SLO is considered to be unmet. For
     * example, an SLO with a threshold of 99.95% and a monthly interval translates to an error budget of 21.9 minutes
     * of downtime in a 30-day month.
     * </p>
     * <p>
     * Budget reports include a health indicator, the attainment value, and remaining budget.
     * </p>
     * <p>
     * For more information about SLO error budgets, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-ServiceLevelObjectives.html#CloudWatch-ServiceLevelObjectives-concepts"
     * > SLO concepts</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchGetServiceLevelObjectiveBudgetReportRequest.Builder} avoiding the need to create one manually via
     * {@link BatchGetServiceLevelObjectiveBudgetReportRequest#builder()}
     * </p>
     *
     * @param batchGetServiceLevelObjectiveBudgetReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.BatchGetServiceLevelObjectiveBudgetReportRequest.Builder}
     *        to create a request.
     * @return Result of the BatchGetServiceLevelObjectiveBudgetReport operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.BatchGetServiceLevelObjectiveBudgetReport
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/BatchGetServiceLevelObjectiveBudgetReport"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetServiceLevelObjectiveBudgetReportResponse batchGetServiceLevelObjectiveBudgetReport(
            Consumer<BatchGetServiceLevelObjectiveBudgetReportRequest.Builder> batchGetServiceLevelObjectiveBudgetReportRequest)
            throws ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        return batchGetServiceLevelObjectiveBudgetReport(BatchGetServiceLevelObjectiveBudgetReportRequest.builder()
                .applyMutation(batchGetServiceLevelObjectiveBudgetReportRequest).build());
    }

    /**
     * <p>
     * Add or remove time window exclusions for one or more Service Level Objectives (SLOs).
     * </p>
     *
     * @param batchUpdateExclusionWindowsRequest
     * @return Result of the BatchUpdateExclusionWindows operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ResourceNotFoundException
     *         Resource not found.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.BatchUpdateExclusionWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/BatchUpdateExclusionWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateExclusionWindowsResponse batchUpdateExclusionWindows(
            BatchUpdateExclusionWindowsRequest batchUpdateExclusionWindowsRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add or remove time window exclusions for one or more Service Level Objectives (SLOs).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateExclusionWindowsRequest.Builder}
     * avoiding the need to create one manually via {@link BatchUpdateExclusionWindowsRequest#builder()}
     * </p>
     *
     * @param batchUpdateExclusionWindowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.BatchUpdateExclusionWindowsRequest.Builder}
     *        to create a request.
     * @return Result of the BatchUpdateExclusionWindows operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ResourceNotFoundException
     *         Resource not found.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.BatchUpdateExclusionWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/BatchUpdateExclusionWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateExclusionWindowsResponse batchUpdateExclusionWindows(
            Consumer<BatchUpdateExclusionWindowsRequest.Builder> batchUpdateExclusionWindowsRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        return batchUpdateExclusionWindows(BatchUpdateExclusionWindowsRequest.builder()
                .applyMutation(batchUpdateExclusionWindowsRequest).build());
    }

    /**
     * <p>
     * Creates a service level objective (SLO), which can help you ensure that your critical business operations are
     * meeting customer expectations. Use SLOs to set and track specific target levels for the reliability and
     * availability of your applications and services. SLOs use service level indicators (SLIs) to calculate whether the
     * application is performing at the level that you want.
     * </p>
     * <p>
     * Create an SLO to set a target for a service or operation’s availability or latency. CloudWatch measures this
     * target frequently you can find whether it has been breached.
     * </p>
     * <p>
     * The target performance quality that is defined for an SLO is the <i>attainment goal</i>.
     * </p>
     * <p>
     * You can set SLO targets for your applications that are discovered by Application Signals, using critical metrics
     * such as latency and availability. You can also set SLOs against any CloudWatch metric or math expression that
     * produces a time series.
     * </p>
     * <note>
     * <p>
     * You can't create an SLO for a service operation that was discovered by Application Signals until after that
     * operation has reported standard metrics to Application Signals.
     * </p>
     * </note>
     * <p>
     * When you create an SLO, you specify whether it is a <i>period-based SLO</i> or a <i>request-based SLO</i>. Each
     * type of SLO has a different way of evaluating your application's performance against its attainment goal.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A <i>period-based SLO</i> uses defined <i>periods</i> of time within a specified total time interval. For each
     * period of time, Application Signals determines whether the application met its goal. The attainment rate is
     * calculated as the <code>number of good periods/number of total periods</code>.
     * </p>
     * <p>
     * For example, for a period-based SLO, meeting an attainment goal of 99.9% means that within your interval, your
     * application must meet its performance goal during at least 99.9% of the time periods.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <i>request-based SLO</i> doesn't use pre-defined periods of time. Instead, the SLO measures
     * <code>number of good requests/number of total requests</code> during the interval. At any time, you can find the
     * ratio of good requests to total requests for the interval up to the time stamp that you specify, and measure that
     * ratio against the goal set in your SLO.
     * </p>
     * </li>
     * </ul>
     * <p>
     * After you have created an SLO, you can retrieve error budget reports for it. An <i>error budget</i> is the amount
     * of time or amount of requests that your application can be non-compliant with the SLO's goal, and still have your
     * application meet the goal.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For a period-based SLO, the error budget starts at a number defined by the highest number of periods that can
     * fail to meet the threshold, while still meeting the overall goal. The <i>remaining error budget</i> decreases
     * with every failed period that is recorded. The error budget within one interval can never increase.
     * </p>
     * <p>
     * For example, an SLO with a threshold that 99.95% of requests must be completed under 2000ms every month
     * translates to an error budget of 21.9 minutes of downtime per month.
     * </p>
     * </li>
     * <li>
     * <p>
     * For a request-based SLO, the remaining error budget is dynamic and can increase or decrease, depending on the
     * ratio of good requests to total requests.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about SLOs, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-ServiceLevelObjectives.html">
     * Service level objectives (SLOs)</a>.
     * </p>
     * <p>
     * When you perform a <code>CreateServiceLevelObjective</code> operation, Application Signals creates the
     * <i>AWSServiceRoleForCloudWatchApplicationSignals</i> service-linked role, if it doesn't already exist in your
     * account. This service- linked role has the following permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>xray:GetServiceGraph</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>logs:StartQuery</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>logs:GetQueryResults</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cloudwatch:GetMetricData</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cloudwatch:ListMetrics</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag:GetResources</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>autoscaling:DescribeAutoScalingGroups</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param createServiceLevelObjectiveRequest
     * @return Result of the CreateServiceLevelObjective operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws AccessDeniedException
     *         You don't have sufficient permissions to perform this action.
     * @throws ServiceQuotaExceededException
     *         This request exceeds a service quota.
     * @throws ConflictException
     *         This operation attempted to create a resource that already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.CreateServiceLevelObjective
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/CreateServiceLevelObjective"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateServiceLevelObjectiveResponse createServiceLevelObjective(
            CreateServiceLevelObjectiveRequest createServiceLevelObjectiveRequest) throws ValidationException,
            ThrottlingException, AccessDeniedException, ServiceQuotaExceededException, ConflictException, AwsServiceException,
            SdkClientException, ApplicationSignalsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a service level objective (SLO), which can help you ensure that your critical business operations are
     * meeting customer expectations. Use SLOs to set and track specific target levels for the reliability and
     * availability of your applications and services. SLOs use service level indicators (SLIs) to calculate whether the
     * application is performing at the level that you want.
     * </p>
     * <p>
     * Create an SLO to set a target for a service or operation’s availability or latency. CloudWatch measures this
     * target frequently you can find whether it has been breached.
     * </p>
     * <p>
     * The target performance quality that is defined for an SLO is the <i>attainment goal</i>.
     * </p>
     * <p>
     * You can set SLO targets for your applications that are discovered by Application Signals, using critical metrics
     * such as latency and availability. You can also set SLOs against any CloudWatch metric or math expression that
     * produces a time series.
     * </p>
     * <note>
     * <p>
     * You can't create an SLO for a service operation that was discovered by Application Signals until after that
     * operation has reported standard metrics to Application Signals.
     * </p>
     * </note>
     * <p>
     * When you create an SLO, you specify whether it is a <i>period-based SLO</i> or a <i>request-based SLO</i>. Each
     * type of SLO has a different way of evaluating your application's performance against its attainment goal.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A <i>period-based SLO</i> uses defined <i>periods</i> of time within a specified total time interval. For each
     * period of time, Application Signals determines whether the application met its goal. The attainment rate is
     * calculated as the <code>number of good periods/number of total periods</code>.
     * </p>
     * <p>
     * For example, for a period-based SLO, meeting an attainment goal of 99.9% means that within your interval, your
     * application must meet its performance goal during at least 99.9% of the time periods.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <i>request-based SLO</i> doesn't use pre-defined periods of time. Instead, the SLO measures
     * <code>number of good requests/number of total requests</code> during the interval. At any time, you can find the
     * ratio of good requests to total requests for the interval up to the time stamp that you specify, and measure that
     * ratio against the goal set in your SLO.
     * </p>
     * </li>
     * </ul>
     * <p>
     * After you have created an SLO, you can retrieve error budget reports for it. An <i>error budget</i> is the amount
     * of time or amount of requests that your application can be non-compliant with the SLO's goal, and still have your
     * application meet the goal.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For a period-based SLO, the error budget starts at a number defined by the highest number of periods that can
     * fail to meet the threshold, while still meeting the overall goal. The <i>remaining error budget</i> decreases
     * with every failed period that is recorded. The error budget within one interval can never increase.
     * </p>
     * <p>
     * For example, an SLO with a threshold that 99.95% of requests must be completed under 2000ms every month
     * translates to an error budget of 21.9 minutes of downtime per month.
     * </p>
     * </li>
     * <li>
     * <p>
     * For a request-based SLO, the remaining error budget is dynamic and can increase or decrease, depending on the
     * ratio of good requests to total requests.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about SLOs, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-ServiceLevelObjectives.html">
     * Service level objectives (SLOs)</a>.
     * </p>
     * <p>
     * When you perform a <code>CreateServiceLevelObjective</code> operation, Application Signals creates the
     * <i>AWSServiceRoleForCloudWatchApplicationSignals</i> service-linked role, if it doesn't already exist in your
     * account. This service- linked role has the following permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>xray:GetServiceGraph</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>logs:StartQuery</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>logs:GetQueryResults</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cloudwatch:GetMetricData</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cloudwatch:ListMetrics</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag:GetResources</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>autoscaling:DescribeAutoScalingGroups</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceLevelObjectiveRequest.Builder}
     * avoiding the need to create one manually via {@link CreateServiceLevelObjectiveRequest#builder()}
     * </p>
     *
     * @param createServiceLevelObjectiveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.CreateServiceLevelObjectiveRequest.Builder}
     *        to create a request.
     * @return Result of the CreateServiceLevelObjective operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws AccessDeniedException
     *         You don't have sufficient permissions to perform this action.
     * @throws ServiceQuotaExceededException
     *         This request exceeds a service quota.
     * @throws ConflictException
     *         This operation attempted to create a resource that already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.CreateServiceLevelObjective
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/CreateServiceLevelObjective"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateServiceLevelObjectiveResponse createServiceLevelObjective(
            Consumer<CreateServiceLevelObjectiveRequest.Builder> createServiceLevelObjectiveRequest) throws ValidationException,
            ThrottlingException, AccessDeniedException, ServiceQuotaExceededException, ConflictException, AwsServiceException,
            SdkClientException, ApplicationSignalsException {
        return createServiceLevelObjective(CreateServiceLevelObjectiveRequest.builder()
                .applyMutation(createServiceLevelObjectiveRequest).build());
    }

    /**
     * <p>
     * Deletes the specified service level objective.
     * </p>
     *
     * @param deleteServiceLevelObjectiveRequest
     * @return Result of the DeleteServiceLevelObjective operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ResourceNotFoundException
     *         Resource not found.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.DeleteServiceLevelObjective
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/DeleteServiceLevelObjective"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteServiceLevelObjectiveResponse deleteServiceLevelObjective(
            DeleteServiceLevelObjectiveRequest deleteServiceLevelObjectiveRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified service level objective.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServiceLevelObjectiveRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteServiceLevelObjectiveRequest#builder()}
     * </p>
     *
     * @param deleteServiceLevelObjectiveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.DeleteServiceLevelObjectiveRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteServiceLevelObjective operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ResourceNotFoundException
     *         Resource not found.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.DeleteServiceLevelObjective
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/DeleteServiceLevelObjective"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteServiceLevelObjectiveResponse deleteServiceLevelObjective(
            Consumer<DeleteServiceLevelObjectiveRequest.Builder> deleteServiceLevelObjectiveRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        return deleteServiceLevelObjective(DeleteServiceLevelObjectiveRequest.builder()
                .applyMutation(deleteServiceLevelObjectiveRequest).build());
    }

    /**
     * <p>
     * Returns information about a service discovered by Application Signals.
     * </p>
     *
     * @param getServiceRequest
     * @return Result of the GetService operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.GetService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/GetService"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceResponse getService(GetServiceRequest getServiceRequest) throws ValidationException, ThrottlingException,
            AwsServiceException, SdkClientException, ApplicationSignalsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a service discovered by Application Signals.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceRequest.Builder} avoiding the need to
     * create one manually via {@link GetServiceRequest#builder()}
     * </p>
     *
     * @param getServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.GetServiceRequest.Builder} to create a
     *        request.
     * @return Result of the GetService operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.GetService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/GetService"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceResponse getService(Consumer<GetServiceRequest.Builder> getServiceRequest) throws ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        return getService(GetServiceRequest.builder().applyMutation(getServiceRequest).build());
    }

    /**
     * <p>
     * Returns information about one SLO created in the account.
     * </p>
     *
     * @param getServiceLevelObjectiveRequest
     * @return Result of the GetServiceLevelObjective operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ResourceNotFoundException
     *         Resource not found.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.GetServiceLevelObjective
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/GetServiceLevelObjective"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceLevelObjectiveResponse getServiceLevelObjective(
            GetServiceLevelObjectiveRequest getServiceLevelObjectiveRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about one SLO created in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceLevelObjectiveRequest.Builder} avoiding
     * the need to create one manually via {@link GetServiceLevelObjectiveRequest#builder()}
     * </p>
     *
     * @param getServiceLevelObjectiveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.GetServiceLevelObjectiveRequest.Builder}
     *        to create a request.
     * @return Result of the GetServiceLevelObjective operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ResourceNotFoundException
     *         Resource not found.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.GetServiceLevelObjective
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/GetServiceLevelObjective"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceLevelObjectiveResponse getServiceLevelObjective(
            Consumer<GetServiceLevelObjectiveRequest.Builder> getServiceLevelObjectiveRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        return getServiceLevelObjective(GetServiceLevelObjectiveRequest.builder().applyMutation(getServiceLevelObjectiveRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of service dependencies of the service that you specify. A dependency is an infrastructure
     * component that an operation of this service connects with. Dependencies can include Amazon Web Services services,
     * Amazon Web Services resources, and third-party services.
     * </p>
     *
     * @param listServiceDependenciesRequest
     * @return Result of the ListServiceDependencies operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServiceDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceDependencies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceDependenciesResponse listServiceDependencies(ListServiceDependenciesRequest listServiceDependenciesRequest)
            throws ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of service dependencies of the service that you specify. A dependency is an infrastructure
     * component that an operation of this service connects with. Dependencies can include Amazon Web Services services,
     * Amazon Web Services resources, and third-party services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceDependenciesRequest.Builder} avoiding
     * the need to create one manually via {@link ListServiceDependenciesRequest#builder()}
     * </p>
     *
     * @param listServiceDependenciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.ListServiceDependenciesRequest.Builder} to
     *        create a request.
     * @return Result of the ListServiceDependencies operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServiceDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceDependencies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceDependenciesResponse listServiceDependencies(
            Consumer<ListServiceDependenciesRequest.Builder> listServiceDependenciesRequest) throws ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        return listServiceDependencies(ListServiceDependenciesRequest.builder().applyMutation(listServiceDependenciesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceDependencies(software.amazon.awssdk.services.applicationsignals.model.ListServiceDependenciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServiceDependenciesIterable responses = client.listServiceDependenciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationsignals.paginators.ListServiceDependenciesIterable responses = client
     *             .listServiceDependenciesPaginator(request);
     *     for (software.amazon.awssdk.services.applicationsignals.model.ListServiceDependenciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServiceDependenciesIterable responses = client.listServiceDependenciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceDependencies(software.amazon.awssdk.services.applicationsignals.model.ListServiceDependenciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceDependenciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServiceDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceDependencies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceDependenciesIterable listServiceDependenciesPaginator(
            ListServiceDependenciesRequest listServiceDependenciesRequest) throws ValidationException, ThrottlingException,
            AwsServiceException, SdkClientException, ApplicationSignalsException {
        return new ListServiceDependenciesIterable(this, listServiceDependenciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceDependencies(software.amazon.awssdk.services.applicationsignals.model.ListServiceDependenciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServiceDependenciesIterable responses = client.listServiceDependenciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationsignals.paginators.ListServiceDependenciesIterable responses = client
     *             .listServiceDependenciesPaginator(request);
     *     for (software.amazon.awssdk.services.applicationsignals.model.ListServiceDependenciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServiceDependenciesIterable responses = client.listServiceDependenciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceDependencies(software.amazon.awssdk.services.applicationsignals.model.ListServiceDependenciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceDependenciesRequest.Builder} avoiding
     * the need to create one manually via {@link ListServiceDependenciesRequest#builder()}
     * </p>
     *
     * @param listServiceDependenciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.ListServiceDependenciesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServiceDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceDependencies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceDependenciesIterable listServiceDependenciesPaginator(
            Consumer<ListServiceDependenciesRequest.Builder> listServiceDependenciesRequest) throws ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        return listServiceDependenciesPaginator(ListServiceDependenciesRequest.builder()
                .applyMutation(listServiceDependenciesRequest).build());
    }

    /**
     * <p>
     * Returns the list of dependents that invoked the specified service during the provided time range. Dependents
     * include other services, CloudWatch Synthetics canaries, and clients that are instrumented with CloudWatch RUM app
     * monitors.
     * </p>
     *
     * @param listServiceDependentsRequest
     * @return Result of the ListServiceDependents operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServiceDependents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceDependents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceDependentsResponse listServiceDependents(ListServiceDependentsRequest listServiceDependentsRequest)
            throws ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of dependents that invoked the specified service during the provided time range. Dependents
     * include other services, CloudWatch Synthetics canaries, and clients that are instrumented with CloudWatch RUM app
     * monitors.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceDependentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceDependentsRequest#builder()}
     * </p>
     *
     * @param listServiceDependentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.ListServiceDependentsRequest.Builder} to
     *        create a request.
     * @return Result of the ListServiceDependents operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServiceDependents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceDependents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceDependentsResponse listServiceDependents(
            Consumer<ListServiceDependentsRequest.Builder> listServiceDependentsRequest) throws ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        return listServiceDependents(ListServiceDependentsRequest.builder().applyMutation(listServiceDependentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceDependents(software.amazon.awssdk.services.applicationsignals.model.ListServiceDependentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServiceDependentsIterable responses = client.listServiceDependentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationsignals.paginators.ListServiceDependentsIterable responses = client
     *             .listServiceDependentsPaginator(request);
     *     for (software.amazon.awssdk.services.applicationsignals.model.ListServiceDependentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServiceDependentsIterable responses = client.listServiceDependentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceDependents(software.amazon.awssdk.services.applicationsignals.model.ListServiceDependentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceDependentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServiceDependents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceDependents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceDependentsIterable listServiceDependentsPaginator(ListServiceDependentsRequest listServiceDependentsRequest)
            throws ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        return new ListServiceDependentsIterable(this, listServiceDependentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceDependents(software.amazon.awssdk.services.applicationsignals.model.ListServiceDependentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServiceDependentsIterable responses = client.listServiceDependentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationsignals.paginators.ListServiceDependentsIterable responses = client
     *             .listServiceDependentsPaginator(request);
     *     for (software.amazon.awssdk.services.applicationsignals.model.ListServiceDependentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServiceDependentsIterable responses = client.listServiceDependentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceDependents(software.amazon.awssdk.services.applicationsignals.model.ListServiceDependentsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceDependentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceDependentsRequest#builder()}
     * </p>
     *
     * @param listServiceDependentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.ListServiceDependentsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServiceDependents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceDependents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceDependentsIterable listServiceDependentsPaginator(
            Consumer<ListServiceDependentsRequest.Builder> listServiceDependentsRequest) throws ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        return listServiceDependentsPaginator(ListServiceDependentsRequest.builder().applyMutation(listServiceDependentsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves all exclusion windows configured for a specific SLO.
     * </p>
     *
     * @param listServiceLevelObjectiveExclusionWindowsRequest
     * @return Result of the ListServiceLevelObjectiveExclusionWindows operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ResourceNotFoundException
     *         Resource not found.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServiceLevelObjectiveExclusionWindows
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceLevelObjectiveExclusionWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceLevelObjectiveExclusionWindowsResponse listServiceLevelObjectiveExclusionWindows(
            ListServiceLevelObjectiveExclusionWindowsRequest listServiceLevelObjectiveExclusionWindowsRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            ApplicationSignalsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all exclusion windows configured for a specific SLO.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceLevelObjectiveExclusionWindowsRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceLevelObjectiveExclusionWindowsRequest#builder()}
     * </p>
     *
     * @param listServiceLevelObjectiveExclusionWindowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectiveExclusionWindowsRequest.Builder}
     *        to create a request.
     * @return Result of the ListServiceLevelObjectiveExclusionWindows operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ResourceNotFoundException
     *         Resource not found.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServiceLevelObjectiveExclusionWindows
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceLevelObjectiveExclusionWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceLevelObjectiveExclusionWindowsResponse listServiceLevelObjectiveExclusionWindows(
            Consumer<ListServiceLevelObjectiveExclusionWindowsRequest.Builder> listServiceLevelObjectiveExclusionWindowsRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            ApplicationSignalsException {
        return listServiceLevelObjectiveExclusionWindows(ListServiceLevelObjectiveExclusionWindowsRequest.builder()
                .applyMutation(listServiceLevelObjectiveExclusionWindowsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceLevelObjectiveExclusionWindows(software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectiveExclusionWindowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServiceLevelObjectiveExclusionWindowsIterable responses = client.listServiceLevelObjectiveExclusionWindowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationsignals.paginators.ListServiceLevelObjectiveExclusionWindowsIterable responses = client
     *             .listServiceLevelObjectiveExclusionWindowsPaginator(request);
     *     for (software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectiveExclusionWindowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServiceLevelObjectiveExclusionWindowsIterable responses = client.listServiceLevelObjectiveExclusionWindowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceLevelObjectiveExclusionWindows(software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectiveExclusionWindowsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceLevelObjectiveExclusionWindowsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ResourceNotFoundException
     *         Resource not found.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServiceLevelObjectiveExclusionWindows
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceLevelObjectiveExclusionWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceLevelObjectiveExclusionWindowsIterable listServiceLevelObjectiveExclusionWindowsPaginator(
            ListServiceLevelObjectiveExclusionWindowsRequest listServiceLevelObjectiveExclusionWindowsRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            ApplicationSignalsException {
        return new ListServiceLevelObjectiveExclusionWindowsIterable(this, listServiceLevelObjectiveExclusionWindowsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceLevelObjectiveExclusionWindows(software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectiveExclusionWindowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServiceLevelObjectiveExclusionWindowsIterable responses = client.listServiceLevelObjectiveExclusionWindowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationsignals.paginators.ListServiceLevelObjectiveExclusionWindowsIterable responses = client
     *             .listServiceLevelObjectiveExclusionWindowsPaginator(request);
     *     for (software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectiveExclusionWindowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServiceLevelObjectiveExclusionWindowsIterable responses = client.listServiceLevelObjectiveExclusionWindowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceLevelObjectiveExclusionWindows(software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectiveExclusionWindowsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceLevelObjectiveExclusionWindowsRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceLevelObjectiveExclusionWindowsRequest#builder()}
     * </p>
     *
     * @param listServiceLevelObjectiveExclusionWindowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectiveExclusionWindowsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ResourceNotFoundException
     *         Resource not found.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServiceLevelObjectiveExclusionWindows
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceLevelObjectiveExclusionWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceLevelObjectiveExclusionWindowsIterable listServiceLevelObjectiveExclusionWindowsPaginator(
            Consumer<ListServiceLevelObjectiveExclusionWindowsRequest.Builder> listServiceLevelObjectiveExclusionWindowsRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            ApplicationSignalsException {
        return listServiceLevelObjectiveExclusionWindowsPaginator(ListServiceLevelObjectiveExclusionWindowsRequest.builder()
                .applyMutation(listServiceLevelObjectiveExclusionWindowsRequest).build());
    }

    /**
     * <p>
     * Returns a list of SLOs created in this account.
     * </p>
     *
     * @param listServiceLevelObjectivesRequest
     * @return Result of the ListServiceLevelObjectives operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServiceLevelObjectives
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceLevelObjectives"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceLevelObjectivesResponse listServiceLevelObjectives(
            ListServiceLevelObjectivesRequest listServiceLevelObjectivesRequest) throws ValidationException, ThrottlingException,
            AwsServiceException, SdkClientException, ApplicationSignalsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of SLOs created in this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceLevelObjectivesRequest.Builder} avoiding
     * the need to create one manually via {@link ListServiceLevelObjectivesRequest#builder()}
     * </p>
     *
     * @param listServiceLevelObjectivesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectivesRequest.Builder}
     *        to create a request.
     * @return Result of the ListServiceLevelObjectives operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServiceLevelObjectives
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceLevelObjectives"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceLevelObjectivesResponse listServiceLevelObjectives(
            Consumer<ListServiceLevelObjectivesRequest.Builder> listServiceLevelObjectivesRequest) throws ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        return listServiceLevelObjectives(ListServiceLevelObjectivesRequest.builder()
                .applyMutation(listServiceLevelObjectivesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceLevelObjectives(software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectivesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServiceLevelObjectivesIterable responses = client.listServiceLevelObjectivesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationsignals.paginators.ListServiceLevelObjectivesIterable responses = client
     *             .listServiceLevelObjectivesPaginator(request);
     *     for (software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectivesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServiceLevelObjectivesIterable responses = client.listServiceLevelObjectivesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceLevelObjectives(software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectivesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceLevelObjectivesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServiceLevelObjectives
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceLevelObjectives"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceLevelObjectivesIterable listServiceLevelObjectivesPaginator(
            ListServiceLevelObjectivesRequest listServiceLevelObjectivesRequest) throws ValidationException, ThrottlingException,
            AwsServiceException, SdkClientException, ApplicationSignalsException {
        return new ListServiceLevelObjectivesIterable(this, listServiceLevelObjectivesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceLevelObjectives(software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectivesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServiceLevelObjectivesIterable responses = client.listServiceLevelObjectivesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationsignals.paginators.ListServiceLevelObjectivesIterable responses = client
     *             .listServiceLevelObjectivesPaginator(request);
     *     for (software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectivesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServiceLevelObjectivesIterable responses = client.listServiceLevelObjectivesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceLevelObjectives(software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectivesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceLevelObjectivesRequest.Builder} avoiding
     * the need to create one manually via {@link ListServiceLevelObjectivesRequest#builder()}
     * </p>
     *
     * @param listServiceLevelObjectivesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectivesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServiceLevelObjectives
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceLevelObjectives"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceLevelObjectivesIterable listServiceLevelObjectivesPaginator(
            Consumer<ListServiceLevelObjectivesRequest.Builder> listServiceLevelObjectivesRequest) throws ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        return listServiceLevelObjectivesPaginator(ListServiceLevelObjectivesRequest.builder()
                .applyMutation(listServiceLevelObjectivesRequest).build());
    }

    /**
     * <p>
     * Returns a list of the <i>operations</i> of this service that have been discovered by Application Signals. Only
     * the operations that were invoked during the specified time range are returned.
     * </p>
     *
     * @param listServiceOperationsRequest
     * @return Result of the ListServiceOperations operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServiceOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceOperationsResponse listServiceOperations(ListServiceOperationsRequest listServiceOperationsRequest)
            throws ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the <i>operations</i> of this service that have been discovered by Application Signals. Only
     * the operations that were invoked during the specified time range are returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceOperationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceOperationsRequest#builder()}
     * </p>
     *
     * @param listServiceOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.ListServiceOperationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListServiceOperations operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServiceOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceOperationsResponse listServiceOperations(
            Consumer<ListServiceOperationsRequest.Builder> listServiceOperationsRequest) throws ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        return listServiceOperations(ListServiceOperationsRequest.builder().applyMutation(listServiceOperationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceOperations(software.amazon.awssdk.services.applicationsignals.model.ListServiceOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServiceOperationsIterable responses = client.listServiceOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationsignals.paginators.ListServiceOperationsIterable responses = client
     *             .listServiceOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.applicationsignals.model.ListServiceOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServiceOperationsIterable responses = client.listServiceOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceOperations(software.amazon.awssdk.services.applicationsignals.model.ListServiceOperationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceOperationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServiceOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceOperationsIterable listServiceOperationsPaginator(ListServiceOperationsRequest listServiceOperationsRequest)
            throws ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        return new ListServiceOperationsIterable(this, listServiceOperationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceOperations(software.amazon.awssdk.services.applicationsignals.model.ListServiceOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServiceOperationsIterable responses = client.listServiceOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationsignals.paginators.ListServiceOperationsIterable responses = client
     *             .listServiceOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.applicationsignals.model.ListServiceOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServiceOperationsIterable responses = client.listServiceOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceOperations(software.amazon.awssdk.services.applicationsignals.model.ListServiceOperationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceOperationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceOperationsRequest#builder()}
     * </p>
     *
     * @param listServiceOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.ListServiceOperationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServiceOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServiceOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceOperationsIterable listServiceOperationsPaginator(
            Consumer<ListServiceOperationsRequest.Builder> listServiceOperationsRequest) throws ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        return listServiceOperationsPaginator(ListServiceOperationsRequest.builder().applyMutation(listServiceOperationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of services that have been discovered by Application Signals. A service represents a minimum
     * logical and transactional unit that completes a business function. Services are discovered through Application
     * Signals instrumentation.
     * </p>
     *
     * @param listServicesRequest
     * @return Result of the ListServices operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServicesResponse listServices(ListServicesRequest listServicesRequest) throws ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of services that have been discovered by Application Signals. A service represents a minimum
     * logical and transactional unit that completes a business function. Services are discovered through Application
     * Signals instrumentation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListServicesRequest#builder()}
     * </p>
     *
     * @param listServicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.ListServicesRequest.Builder} to create a
     *        request.
     * @return Result of the ListServices operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServicesResponse listServices(Consumer<ListServicesRequest.Builder> listServicesRequest)
            throws ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        return listServices(ListServicesRequest.builder().applyMutation(listServicesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServices(software.amazon.awssdk.services.applicationsignals.model.ListServicesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServicesIterable responses = client.listServicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationsignals.paginators.ListServicesIterable responses = client
     *             .listServicesPaginator(request);
     *     for (software.amazon.awssdk.services.applicationsignals.model.ListServicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServicesIterable responses = client.listServicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServices(software.amazon.awssdk.services.applicationsignals.model.ListServicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServicesIterable listServicesPaginator(ListServicesRequest listServicesRequest) throws ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        return new ListServicesIterable(this, listServicesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServices(software.amazon.awssdk.services.applicationsignals.model.ListServicesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServicesIterable responses = client.listServicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationsignals.paginators.ListServicesIterable responses = client
     *             .listServicesPaginator(request);
     *     for (software.amazon.awssdk.services.applicationsignals.model.ListServicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationsignals.paginators.ListServicesIterable responses = client.listServicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServices(software.amazon.awssdk.services.applicationsignals.model.ListServicesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListServicesRequest#builder()}
     * </p>
     *
     * @param listServicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.ListServicesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListServices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServicesIterable listServicesPaginator(Consumer<ListServicesRequest.Builder> listServicesRequest)
            throws ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        return listServicesPaginator(ListServicesRequest.builder().applyMutation(listServicesRequest).build());
    }

    /**
     * <p>
     * Displays the tags associated with a CloudWatch resource. Tags can be assigned to service level objectives.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            ApplicationSignalsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the tags associated with a CloudWatch resource. Tags can be assigned to service level objectives.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Enables this Amazon Web Services account to be able to use CloudWatch Application Signals by creating the
     * <i>AWSServiceRoleForCloudWatchApplicationSignals</i> service-linked role. This service- linked role has the
     * following permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>xray:GetServiceGraph</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>logs:StartQuery</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>logs:GetQueryResults</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cloudwatch:GetMetricData</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cloudwatch:ListMetrics</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag:GetResources</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>autoscaling:DescribeAutoScalingGroups</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * After completing this step, you still need to instrument your Java and Python applications to send data to
     * Application Signals. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Application-Signals-Enable.html">
     * Enabling Application Signals</a>.
     * </p>
     *
     * @param startDiscoveryRequest
     * @return Result of the StartDiscovery operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws AccessDeniedException
     *         You don't have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.StartDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/StartDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDiscoveryResponse startDiscovery(StartDiscoveryRequest startDiscoveryRequest) throws ValidationException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables this Amazon Web Services account to be able to use CloudWatch Application Signals by creating the
     * <i>AWSServiceRoleForCloudWatchApplicationSignals</i> service-linked role. This service- linked role has the
     * following permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>xray:GetServiceGraph</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>logs:StartQuery</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>logs:GetQueryResults</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cloudwatch:GetMetricData</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cloudwatch:ListMetrics</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag:GetResources</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>autoscaling:DescribeAutoScalingGroups</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * After completing this step, you still need to instrument your Java and Python applications to send data to
     * Application Signals. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Application-Signals-Enable.html">
     * Enabling Application Signals</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDiscoveryRequest.Builder} avoiding the need to
     * create one manually via {@link StartDiscoveryRequest#builder()}
     * </p>
     *
     * @param startDiscoveryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.StartDiscoveryRequest.Builder} to create a
     *        request.
     * @return Result of the StartDiscovery operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws AccessDeniedException
     *         You don't have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.StartDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/StartDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDiscoveryResponse startDiscovery(Consumer<StartDiscoveryRequest.Builder> startDiscoveryRequest)
            throws ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            ApplicationSignalsException {
        return startDiscovery(StartDiscoveryRequest.builder().applyMutation(startDiscoveryRequest).build());
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified CloudWatch resource, such as a service level
     * objective.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
     * granting a user permission to access or change only resources with certain tag values.
     * </p>
     * <p>
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of
     * characters.
     * </p>
     * <p>
     * You can use the <code>TagResource</code> action with an alarm that already has tags. If you specify a new tag key
     * for the alarm, this tag is appended to the list of tags associated with the alarm. If you specify a tag key that
     * is already associated with the alarm, the new tag value that you specify replaces the previous value for that
     * tag.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a CloudWatch resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws ServiceQuotaExceededException
     *         This request exceeds a service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            ThrottlingException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            ApplicationSignalsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified CloudWatch resource, such as a service level
     * objective.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
     * granting a user permission to access or change only resources with certain tag values.
     * </p>
     * <p>
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of
     * characters.
     * </p>
     * <p>
     * You can use the <code>TagResource</code> action with an alarm that already has tags. If you specify a new tag key
     * for the alarm, this tag is appended to the list of tags associated with the alarm. If you specify a tag key that
     * is already associated with the alarm, the new tag value that you specify replaces the previous value for that
     * tag.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a CloudWatch resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws ServiceQuotaExceededException
     *         This request exceeds a service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, ApplicationSignalsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            ApplicationSignalsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing service level objective (SLO). If you omit parameters, the previous values of those
     * parameters are retained.
     * </p>
     * <p>
     * You cannot change from a period-based SLO to a request-based SLO, or change from a request-based SLO to a
     * period-based SLO.
     * </p>
     *
     * @param updateServiceLevelObjectiveRequest
     * @return Result of the UpdateServiceLevelObjective operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ResourceNotFoundException
     *         Resource not found.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.UpdateServiceLevelObjective
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/UpdateServiceLevelObjective"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateServiceLevelObjectiveResponse updateServiceLevelObjective(
            UpdateServiceLevelObjectiveRequest updateServiceLevelObjectiveRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing service level objective (SLO). If you omit parameters, the previous values of those
     * parameters are retained.
     * </p>
     * <p>
     * You cannot change from a period-based SLO to a request-based SLO, or change from a request-based SLO to a
     * period-based SLO.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceLevelObjectiveRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateServiceLevelObjectiveRequest#builder()}
     * </p>
     *
     * @param updateServiceLevelObjectiveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.applicationsignals.model.UpdateServiceLevelObjectiveRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateServiceLevelObjective operation returned by the service.
     * @throws ValidationException
     *         The resource is not valid.
     * @throws ResourceNotFoundException
     *         Resource not found.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationSignalsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationSignalsClient.UpdateServiceLevelObjective
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/UpdateServiceLevelObjective"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateServiceLevelObjectiveResponse updateServiceLevelObjective(
            Consumer<UpdateServiceLevelObjectiveRequest.Builder> updateServiceLevelObjectiveRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, ApplicationSignalsException {
        return updateServiceLevelObjective(UpdateServiceLevelObjectiveRequest.builder()
                .applyMutation(updateServiceLevelObjectiveRequest).build());
    }

    /**
     * Create a {@link ApplicationSignalsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ApplicationSignalsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ApplicationSignalsClient}.
     */
    static ApplicationSignalsClientBuilder builder() {
        return new DefaultApplicationSignalsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default ApplicationSignalsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
