/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetServiceLevelObjectiveBudgetReportRequest extends ApplicationSignalsRequest
        implements
        ToCopyableBuilder<BatchGetServiceLevelObjectiveBudgetReportRequest.Builder, BatchGetServiceLevelObjectiveBudgetReportRequest> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(BatchGetServiceLevelObjectiveBudgetReportRequest::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<List<String>> SLO_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SloIds")
            .getter(getter(BatchGetServiceLevelObjectiveBudgetReportRequest::sloIds))
            .setter(setter(Builder::sloIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SloIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TIMESTAMP_FIELD, SLO_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant timestamp;

    private final List<String> sloIds;

    private BatchGetServiceLevelObjectiveBudgetReportRequest(BuilderImpl builder) {
        super(builder);
        this.timestamp = builder.timestamp;
        this.sloIds = builder.sloIds;
    }

    /**
     * <p>
     * The date and time that you want the report to be for. It is expressed as the number of milliseconds since Jan 1,
     * 1970 00:00:00 UTC.
     * </p>
     * 
     * @return The date and time that you want the report to be for. It is expressed as the number of milliseconds since
     *         Jan 1, 1970 00:00:00 UTC.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the SloIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSloIds() {
        return sloIds != null && !(sloIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array containing the IDs of the service level objectives that you want to include in the report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSloIds} method.
     * </p>
     * 
     * @return An array containing the IDs of the service level objectives that you want to include in the report.
     */
    public final List<String> sloIds() {
        return sloIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasSloIds() ? sloIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetServiceLevelObjectiveBudgetReportRequest)) {
            return false;
        }
        BatchGetServiceLevelObjectiveBudgetReportRequest other = (BatchGetServiceLevelObjectiveBudgetReportRequest) obj;
        return Objects.equals(timestamp(), other.timestamp()) && hasSloIds() == other.hasSloIds()
                && Objects.equals(sloIds(), other.sloIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetServiceLevelObjectiveBudgetReportRequest").add("Timestamp", timestamp())
                .add("SloIds", hasSloIds() ? sloIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "SloIds":
            return Optional.ofNullable(clazz.cast(sloIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("SloIds", SLO_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetServiceLevelObjectiveBudgetReportRequest, T> g) {
        return obj -> g.apply((BatchGetServiceLevelObjectiveBudgetReportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationSignalsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetServiceLevelObjectiveBudgetReportRequest> {
        /**
         * <p>
         * The date and time that you want the report to be for. It is expressed as the number of milliseconds since Jan
         * 1, 1970 00:00:00 UTC.
         * </p>
         * 
         * @param timestamp
         *        The date and time that you want the report to be for. It is expressed as the number of milliseconds
         *        since Jan 1, 1970 00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * An array containing the IDs of the service level objectives that you want to include in the report.
         * </p>
         * 
         * @param sloIds
         *        An array containing the IDs of the service level objectives that you want to include in the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sloIds(Collection<String> sloIds);

        /**
         * <p>
         * An array containing the IDs of the service level objectives that you want to include in the report.
         * </p>
         * 
         * @param sloIds
         *        An array containing the IDs of the service level objectives that you want to include in the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sloIds(String... sloIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationSignalsRequest.BuilderImpl implements Builder {
        private Instant timestamp;

        private List<String> sloIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetServiceLevelObjectiveBudgetReportRequest model) {
            super(model);
            timestamp(model.timestamp);
            sloIds(model.sloIds);
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Collection<String> getSloIds() {
            if (sloIds instanceof SdkAutoConstructList) {
                return null;
            }
            return sloIds;
        }

        public final void setSloIds(Collection<String> sloIds) {
            this.sloIds = ServiceLevelObjectiveIdsCopier.copy(sloIds);
        }

        @Override
        public final Builder sloIds(Collection<String> sloIds) {
            this.sloIds = ServiceLevelObjectiveIdsCopier.copy(sloIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sloIds(String... sloIds) {
            sloIds(Arrays.asList(sloIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetServiceLevelObjectiveBudgetReportRequest build() {
            return new BatchGetServiceLevelObjectiveBudgetReportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
