/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies the dependency using the <code>DependencyKeyAttributes</code> and <code>DependencyOperationName</code>.
 * </p>
 * <p>
 * When creating a service dependency SLO, you must specify the <code>KeyAttributes</code> of the service, and the
 * <code>DependencyConfig</code> for the dependency. You can specify the <code>OperationName</code> of the service, from
 * which it calls the dependency. Alternatively, you can exclude <code>OperationName</code> and the SLO will monitor all
 * of the service's operations that call the dependency.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DependencyConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DependencyConfig.Builder, DependencyConfig> {
    private static final SdkField<Map<String, String>> DEPENDENCY_KEY_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("DependencyKeyAttributes")
            .getter(getter(DependencyConfig::dependencyKeyAttributes))
            .setter(setter(Builder::dependencyKeyAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependencyKeyAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DEPENDENCY_OPERATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DependencyOperationName").getter(getter(DependencyConfig::dependencyOperationName))
            .setter(setter(Builder::dependencyOperationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependencyOperationName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DEPENDENCY_KEY_ATTRIBUTES_FIELD, DEPENDENCY_OPERATION_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, String> dependencyKeyAttributes;

    private final String dependencyOperationName;

    private DependencyConfig(BuilderImpl builder) {
        this.dependencyKeyAttributes = builder.dependencyKeyAttributes;
        this.dependencyOperationName = builder.dependencyOperationName;
    }

    /**
     * For responses, this returns true if the service returned a value for the DependencyKeyAttributes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDependencyKeyAttributes() {
        return dependencyKeyAttributes != null && !(dependencyKeyAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * This is a string-to-string map. It can include the following fields.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Type</code> designates the type of object this is.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the
     * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field
     * is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the
     * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDependencyKeyAttributes} method.
     * </p>
     * 
     * @return This is a string-to-string map. It can include the following fields.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Type</code> designates the type of object this is.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of
     *         the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Name</code> specifies the name of the object. This is used only if the value of the
     *         <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value
     *         of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
     *         </p>
     *         </li>
     */
    public final Map<String, String> dependencyKeyAttributes() {
        return dependencyKeyAttributes;
    }

    /**
     * <p>
     * The name of the called operation in the dependency.
     * </p>
     * 
     * @return The name of the called operation in the dependency.
     */
    public final String dependencyOperationName() {
        return dependencyOperationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDependencyKeyAttributes() ? dependencyKeyAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dependencyOperationName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DependencyConfig)) {
            return false;
        }
        DependencyConfig other = (DependencyConfig) obj;
        return hasDependencyKeyAttributes() == other.hasDependencyKeyAttributes()
                && Objects.equals(dependencyKeyAttributes(), other.dependencyKeyAttributes())
                && Objects.equals(dependencyOperationName(), other.dependencyOperationName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DependencyConfig")
                .add("DependencyKeyAttributes", hasDependencyKeyAttributes() ? dependencyKeyAttributes() : null)
                .add("DependencyOperationName", dependencyOperationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DependencyKeyAttributes":
            return Optional.ofNullable(clazz.cast(dependencyKeyAttributes()));
        case "DependencyOperationName":
            return Optional.ofNullable(clazz.cast(dependencyOperationName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DependencyKeyAttributes", DEPENDENCY_KEY_ATTRIBUTES_FIELD);
        map.put("DependencyOperationName", DEPENDENCY_OPERATION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DependencyConfig, T> g) {
        return obj -> g.apply((DependencyConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DependencyConfig> {
        /**
         * <p>
         * This is a string-to-string map. It can include the following fields.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Type</code> designates the type of object this is.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the
         * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code>
         * field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of
         * the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dependencyKeyAttributes
         *        This is a string-to-string map. It can include the following fields.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Type</code> designates the type of object this is.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ResourceType</code> specifies the type of the resource. This field is used only when the value
         *        of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Name</code> specifies the name of the object. This is used only if the value of the
         *        <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or
         *        <code>AWS::Service</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Identifier</code> identifies the resource objects of this resource. This is used only if the
         *        value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencyKeyAttributes(Map<String, String> dependencyKeyAttributes);

        /**
         * <p>
         * The name of the called operation in the dependency.
         * </p>
         * 
         * @param dependencyOperationName
         *        The name of the called operation in the dependency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencyOperationName(String dependencyOperationName);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> dependencyKeyAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String dependencyOperationName;

        private BuilderImpl() {
        }

        private BuilderImpl(DependencyConfig model) {
            dependencyKeyAttributes(model.dependencyKeyAttributes);
            dependencyOperationName(model.dependencyOperationName);
        }

        public final Map<String, String> getDependencyKeyAttributes() {
            if (dependencyKeyAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return dependencyKeyAttributes;
        }

        public final void setDependencyKeyAttributes(Map<String, String> dependencyKeyAttributes) {
            this.dependencyKeyAttributes = AttributesCopier.copy(dependencyKeyAttributes);
        }

        @Override
        public final Builder dependencyKeyAttributes(Map<String, String> dependencyKeyAttributes) {
            this.dependencyKeyAttributes = AttributesCopier.copy(dependencyKeyAttributes);
            return this;
        }

        public final String getDependencyOperationName() {
            return dependencyOperationName;
        }

        public final void setDependencyOperationName(String dependencyOperationName) {
            this.dependencyOperationName = dependencyOperationName;
        }

        @Override
        public final Builder dependencyOperationName(String dependencyOperationName) {
            this.dependencyOperationName = dependencyOperationName;
            return this;
        }

        @Override
        public DependencyConfig build() {
            return new DependencyConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
