/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceLevelObjectiveExclusionWindowsResponse extends ApplicationSignalsResponse
        implements
        ToCopyableBuilder<ListServiceLevelObjectiveExclusionWindowsResponse.Builder, ListServiceLevelObjectiveExclusionWindowsResponse> {
    private static final SdkField<List<ExclusionWindow>> EXCLUSION_WINDOWS_FIELD = SdkField
            .<List<ExclusionWindow>> builder(MarshallingType.LIST)
            .memberName("ExclusionWindows")
            .getter(getter(ListServiceLevelObjectiveExclusionWindowsResponse::exclusionWindows))
            .setter(setter(Builder::exclusionWindows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionWindows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExclusionWindow> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExclusionWindow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListServiceLevelObjectiveExclusionWindowsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUSION_WINDOWS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ExclusionWindow> exclusionWindows;

    private final String nextToken;

    private ListServiceLevelObjectiveExclusionWindowsResponse(BuilderImpl builder) {
        super(builder);
        this.exclusionWindows = builder.exclusionWindows;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExclusionWindows property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExclusionWindows() {
        return exclusionWindows != null && !(exclusionWindows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of exclusion windows configured for the SLO.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExclusionWindows} method.
     * </p>
     * 
     * @return A list of exclusion windows configured for the SLO.
     */
    public final List<ExclusionWindow> exclusionWindows() {
        return exclusionWindows;
    }

    /**
     * <p>
     * Include this value, if it was returned by the previous operation, to get the next set of service level
     * objectives.
     * 
     * <pre>
     * <code> &lt;/p&gt; </code>
     * </pre>
     * 
     * @return Include this value, if it was returned by the previous operation, to get the next set of service level
     *         objectives.
     * 
     *         <pre>
     * 
     *         <code> &lt;/p&gt; </code>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasExclusionWindows() ? exclusionWindows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceLevelObjectiveExclusionWindowsResponse)) {
            return false;
        }
        ListServiceLevelObjectiveExclusionWindowsResponse other = (ListServiceLevelObjectiveExclusionWindowsResponse) obj;
        return hasExclusionWindows() == other.hasExclusionWindows()
                && Objects.equals(exclusionWindows(), other.exclusionWindows()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServiceLevelObjectiveExclusionWindowsResponse")
                .add("ExclusionWindows", hasExclusionWindows() ? exclusionWindows() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExclusionWindows":
            return Optional.ofNullable(clazz.cast(exclusionWindows()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExclusionWindows", EXCLUSION_WINDOWS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServiceLevelObjectiveExclusionWindowsResponse, T> g) {
        return obj -> g.apply((ListServiceLevelObjectiveExclusionWindowsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationSignalsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListServiceLevelObjectiveExclusionWindowsResponse> {
        /**
         * <p>
         * A list of exclusion windows configured for the SLO.
         * </p>
         * 
         * @param exclusionWindows
         *        A list of exclusion windows configured for the SLO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionWindows(Collection<ExclusionWindow> exclusionWindows);

        /**
         * <p>
         * A list of exclusion windows configured for the SLO.
         * </p>
         * 
         * @param exclusionWindows
         *        A list of exclusion windows configured for the SLO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionWindows(ExclusionWindow... exclusionWindows);

        /**
         * <p>
         * A list of exclusion windows configured for the SLO.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.ExclusionWindow.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.ExclusionWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.ExclusionWindow.Builder#build()} is called
         * immediately and its result is passed to {@link #exclusionWindows(List<ExclusionWindow>)}.
         * 
         * @param exclusionWindows
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.ExclusionWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exclusionWindows(java.util.Collection<ExclusionWindow>)
         */
        Builder exclusionWindows(Consumer<ExclusionWindow.Builder>... exclusionWindows);

        /**
         * <p>
         * Include this value, if it was returned by the previous operation, to get the next set of service level
         * objectives.
         * 
         * <pre>
         * <code> &lt;/p&gt; </code>
         * </pre>
         * 
         * @param nextToken
         *        Include this value, if it was returned by the previous operation, to get the next set of service level
         *        objectives.
         * 
         *        <pre>
         * 
         *        <code> &lt;/p&gt; </code> @return Returns a reference to this object so that method calls can be
         *        chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationSignalsResponse.BuilderImpl implements Builder {
        private List<ExclusionWindow> exclusionWindows = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceLevelObjectiveExclusionWindowsResponse model) {
            super(model);
            exclusionWindows(model.exclusionWindows);
            nextToken(model.nextToken);
        }

        public final List<ExclusionWindow.Builder> getExclusionWindows() {
            List<ExclusionWindow.Builder> result = ExclusionWindowsCopier.copyToBuilder(this.exclusionWindows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExclusionWindows(Collection<ExclusionWindow.BuilderImpl> exclusionWindows) {
            this.exclusionWindows = ExclusionWindowsCopier.copyFromBuilder(exclusionWindows);
        }

        @Override
        public final Builder exclusionWindows(Collection<ExclusionWindow> exclusionWindows) {
            this.exclusionWindows = ExclusionWindowsCopier.copy(exclusionWindows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionWindows(ExclusionWindow... exclusionWindows) {
            exclusionWindows(Arrays.asList(exclusionWindows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionWindows(Consumer<ExclusionWindow.Builder>... exclusionWindows) {
            exclusionWindows(Stream.of(exclusionWindows).map(c -> ExclusionWindow.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListServiceLevelObjectiveExclusionWindowsResponse build() {
            return new ListServiceLevelObjectiveExclusionWindowsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
