/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information about one service level objective (SLO) created in Application Signals.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceLevelObjectiveSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceLevelObjectiveSummary.Builder, ServiceLevelObjectiveSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ServiceLevelObjectiveSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ServiceLevelObjectiveSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Map<String, String>> KEY_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("KeyAttributes")
            .getter(getter(ServiceLevelObjectiveSummary::keyAttributes))
            .setter(setter(Builder::keyAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationName").getter(getter(ServiceLevelObjectiveSummary::operationName))
            .setter(setter(Builder::operationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationName").build()).build();

    private static final SdkField<DependencyConfig> DEPENDENCY_CONFIG_FIELD = SdkField
            .<DependencyConfig> builder(MarshallingType.SDK_POJO).memberName("DependencyConfig")
            .getter(getter(ServiceLevelObjectiveSummary::dependencyConfig)).setter(setter(Builder::dependencyConfig))
            .constructor(DependencyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependencyConfig").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(ServiceLevelObjectiveSummary::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> EVALUATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationType").getter(getter(ServiceLevelObjectiveSummary::evaluationTypeAsString))
            .setter(setter(Builder::evaluationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationType").build()).build();

    private static final SdkField<String> METRIC_SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricSourceType").getter(getter(ServiceLevelObjectiveSummary::metricSourceTypeAsString))
            .setter(setter(Builder::metricSourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            KEY_ATTRIBUTES_FIELD, OPERATION_NAME_FIELD, DEPENDENCY_CONFIG_FIELD, CREATED_TIME_FIELD, EVALUATION_TYPE_FIELD,
            METRIC_SOURCE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final Map<String, String> keyAttributes;

    private final String operationName;

    private final DependencyConfig dependencyConfig;

    private final Instant createdTime;

    private final String evaluationType;

    private final String metricSourceType;

    private ServiceLevelObjectiveSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.keyAttributes = builder.keyAttributes;
        this.operationName = builder.operationName;
        this.dependencyConfig = builder.dependencyConfig;
        this.createdTime = builder.createdTime;
        this.evaluationType = builder.evaluationType;
        this.metricSourceType = builder.metricSourceType;
    }

    /**
     * <p>
     * The ARN of this service level objective.
     * </p>
     * 
     * @return The ARN of this service level objective.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the service level objective.
     * </p>
     * 
     * @return The name of the service level objective.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeyAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKeyAttributes() {
        return keyAttributes != null && !(keyAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * This is a string-to-string map. It can include the following fields.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Type</code> designates the type of object this service level objective is for.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the
     * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field
     * is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the
     * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeyAttributes} method.
     * </p>
     * 
     * @return This is a string-to-string map. It can include the following fields.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Type</code> designates the type of object this service level objective is for.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of
     *         the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Name</code> specifies the name of the object. This is used only if the value of the
     *         <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value
     *         of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
     *         </p>
     *         </li>
     */
    public final Map<String, String> keyAttributes() {
        return keyAttributes;
    }

    /**
     * <p>
     * If this service level objective is specific to a single operation, this field displays the name of that
     * operation.
     * </p>
     * 
     * @return If this service level objective is specific to a single operation, this field displays the name of that
     *         operation.
     */
    public final String operationName() {
        return operationName;
    }

    /**
     * <p>
     * Identifies the dependency using the <code>DependencyKeyAttributes</code> and <code>DependencyOperationName</code>
     * .
     * </p>
     * 
     * @return Identifies the dependency using the <code>DependencyKeyAttributes</code> and
     *         <code>DependencyOperationName</code>.
     */
    public final DependencyConfig dependencyConfig() {
        return dependencyConfig;
    }

    /**
     * <p>
     * The date and time that this service level objective was created. It is expressed as the number of milliseconds
     * since Jan 1, 1970 00:00:00 UTC.
     * </p>
     * 
     * @return The date and time that this service level objective was created. It is expressed as the number of
     *         milliseconds since Jan 1, 1970 00:00:00 UTC.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * Displays whether this is a period-based SLO or a request-based SLO.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationType}
     * will return {@link EvaluationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationTypeAsString}.
     * </p>
     * 
     * @return Displays whether this is a period-based SLO or a request-based SLO.
     * @see EvaluationType
     */
    public final EvaluationType evaluationType() {
        return EvaluationType.fromValue(evaluationType);
    }

    /**
     * <p>
     * Displays whether this is a period-based SLO or a request-based SLO.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationType}
     * will return {@link EvaluationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationTypeAsString}.
     * </p>
     * 
     * @return Displays whether this is a period-based SLO or a request-based SLO.
     * @see EvaluationType
     */
    public final String evaluationTypeAsString() {
        return evaluationType;
    }

    /**
     * <p>
     * Displays the SLI metric source type for this SLO. Supported types are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Service operation
     * </p>
     * </li>
     * <li>
     * <p>
     * Service dependency
     * </p>
     * </li>
     * <li>
     * <p>
     * CloudWatch metric
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricSourceType}
     * will return {@link MetricSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #metricSourceTypeAsString}.
     * </p>
     * 
     * @return Displays the SLI metric source type for this SLO. Supported types are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Service operation
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Service dependency
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CloudWatch metric
     *         </p>
     *         </li>
     * @see MetricSourceType
     */
    public final MetricSourceType metricSourceType() {
        return MetricSourceType.fromValue(metricSourceType);
    }

    /**
     * <p>
     * Displays the SLI metric source type for this SLO. Supported types are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Service operation
     * </p>
     * </li>
     * <li>
     * <p>
     * Service dependency
     * </p>
     * </li>
     * <li>
     * <p>
     * CloudWatch metric
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricSourceType}
     * will return {@link MetricSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #metricSourceTypeAsString}.
     * </p>
     * 
     * @return Displays the SLI metric source type for this SLO. Supported types are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Service operation
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Service dependency
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CloudWatch metric
     *         </p>
     *         </li>
     * @see MetricSourceType
     */
    public final String metricSourceTypeAsString() {
        return metricSourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeyAttributes() ? keyAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(operationName());
        hashCode = 31 * hashCode + Objects.hashCode(dependencyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricSourceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceLevelObjectiveSummary)) {
            return false;
        }
        ServiceLevelObjectiveSummary other = (ServiceLevelObjectiveSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && hasKeyAttributes() == other.hasKeyAttributes() && Objects.equals(keyAttributes(), other.keyAttributes())
                && Objects.equals(operationName(), other.operationName())
                && Objects.equals(dependencyConfig(), other.dependencyConfig())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(evaluationTypeAsString(), other.evaluationTypeAsString())
                && Objects.equals(metricSourceTypeAsString(), other.metricSourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceLevelObjectiveSummary").add("Arn", arn()).add("Name", name())
                .add("KeyAttributes", hasKeyAttributes() ? keyAttributes() : null).add("OperationName", operationName())
                .add("DependencyConfig", dependencyConfig()).add("CreatedTime", createdTime())
                .add("EvaluationType", evaluationTypeAsString()).add("MetricSourceType", metricSourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "KeyAttributes":
            return Optional.ofNullable(clazz.cast(keyAttributes()));
        case "OperationName":
            return Optional.ofNullable(clazz.cast(operationName()));
        case "DependencyConfig":
            return Optional.ofNullable(clazz.cast(dependencyConfig()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "EvaluationType":
            return Optional.ofNullable(clazz.cast(evaluationTypeAsString()));
        case "MetricSourceType":
            return Optional.ofNullable(clazz.cast(metricSourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("KeyAttributes", KEY_ATTRIBUTES_FIELD);
        map.put("OperationName", OPERATION_NAME_FIELD);
        map.put("DependencyConfig", DEPENDENCY_CONFIG_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("EvaluationType", EVALUATION_TYPE_FIELD);
        map.put("MetricSourceType", METRIC_SOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceLevelObjectiveSummary, T> g) {
        return obj -> g.apply((ServiceLevelObjectiveSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceLevelObjectiveSummary> {
        /**
         * <p>
         * The ARN of this service level objective.
         * </p>
         * 
         * @param arn
         *        The ARN of this service level objective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the service level objective.
         * </p>
         * 
         * @param name
         *        The name of the service level objective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * This is a string-to-string map. It can include the following fields.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Type</code> designates the type of object this service level objective is for.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the
         * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code>
         * field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of
         * the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
         * </p>
         * </li>
         * </ul>
         * 
         * @param keyAttributes
         *        This is a string-to-string map. It can include the following fields.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Type</code> designates the type of object this service level objective is for.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ResourceType</code> specifies the type of the resource. This field is used only when the value
         *        of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Name</code> specifies the name of the object. This is used only if the value of the
         *        <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or
         *        <code>AWS::Service</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Identifier</code> identifies the resource objects of this resource. This is used only if the
         *        value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyAttributes(Map<String, String> keyAttributes);

        /**
         * <p>
         * If this service level objective is specific to a single operation, this field displays the name of that
         * operation.
         * </p>
         * 
         * @param operationName
         *        If this service level objective is specific to a single operation, this field displays the name of
         *        that operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationName(String operationName);

        /**
         * <p>
         * Identifies the dependency using the <code>DependencyKeyAttributes</code> and
         * <code>DependencyOperationName</code>.
         * </p>
         * 
         * @param dependencyConfig
         *        Identifies the dependency using the <code>DependencyKeyAttributes</code> and
         *        <code>DependencyOperationName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencyConfig(DependencyConfig dependencyConfig);

        /**
         * <p>
         * Identifies the dependency using the <code>DependencyKeyAttributes</code> and
         * <code>DependencyOperationName</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DependencyConfig.Builder} avoiding the
         * need to create one manually via {@link DependencyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DependencyConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #dependencyConfig(DependencyConfig)}.
         * 
         * @param dependencyConfig
         *        a consumer that will call methods on {@link DependencyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dependencyConfig(DependencyConfig)
         */
        default Builder dependencyConfig(Consumer<DependencyConfig.Builder> dependencyConfig) {
            return dependencyConfig(DependencyConfig.builder().applyMutation(dependencyConfig).build());
        }

        /**
         * <p>
         * The date and time that this service level objective was created. It is expressed as the number of
         * milliseconds since Jan 1, 1970 00:00:00 UTC.
         * </p>
         * 
         * @param createdTime
         *        The date and time that this service level objective was created. It is expressed as the number of
         *        milliseconds since Jan 1, 1970 00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * Displays whether this is a period-based SLO or a request-based SLO.
         * </p>
         * 
         * @param evaluationType
         *        Displays whether this is a period-based SLO or a request-based SLO.
         * @see EvaluationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationType
         */
        Builder evaluationType(String evaluationType);

        /**
         * <p>
         * Displays whether this is a period-based SLO or a request-based SLO.
         * </p>
         * 
         * @param evaluationType
         *        Displays whether this is a period-based SLO or a request-based SLO.
         * @see EvaluationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationType
         */
        Builder evaluationType(EvaluationType evaluationType);

        /**
         * <p>
         * Displays the SLI metric source type for this SLO. Supported types are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Service operation
         * </p>
         * </li>
         * <li>
         * <p>
         * Service dependency
         * </p>
         * </li>
         * <li>
         * <p>
         * CloudWatch metric
         * </p>
         * </li>
         * </ul>
         * 
         * @param metricSourceType
         *        Displays the SLI metric source type for this SLO. Supported types are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Service operation
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Service dependency
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CloudWatch metric
         *        </p>
         *        </li>
         * @see MetricSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricSourceType
         */
        Builder metricSourceType(String metricSourceType);

        /**
         * <p>
         * Displays the SLI metric source type for this SLO. Supported types are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Service operation
         * </p>
         * </li>
         * <li>
         * <p>
         * Service dependency
         * </p>
         * </li>
         * <li>
         * <p>
         * CloudWatch metric
         * </p>
         * </li>
         * </ul>
         * 
         * @param metricSourceType
         *        Displays the SLI metric source type for this SLO. Supported types are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Service operation
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Service dependency
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CloudWatch metric
         *        </p>
         *        </li>
         * @see MetricSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricSourceType
         */
        Builder metricSourceType(MetricSourceType metricSourceType);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private Map<String, String> keyAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String operationName;

        private DependencyConfig dependencyConfig;

        private Instant createdTime;

        private String evaluationType;

        private String metricSourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLevelObjectiveSummary model) {
            arn(model.arn);
            name(model.name);
            keyAttributes(model.keyAttributes);
            operationName(model.operationName);
            dependencyConfig(model.dependencyConfig);
            createdTime(model.createdTime);
            evaluationType(model.evaluationType);
            metricSourceType(model.metricSourceType);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getKeyAttributes() {
            if (keyAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return keyAttributes;
        }

        public final void setKeyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
        }

        @Override
        public final Builder keyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
            return this;
        }

        public final String getOperationName() {
            return operationName;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final DependencyConfig.Builder getDependencyConfig() {
            return dependencyConfig != null ? dependencyConfig.toBuilder() : null;
        }

        public final void setDependencyConfig(DependencyConfig.BuilderImpl dependencyConfig) {
            this.dependencyConfig = dependencyConfig != null ? dependencyConfig.build() : null;
        }

        @Override
        public final Builder dependencyConfig(DependencyConfig dependencyConfig) {
            this.dependencyConfig = dependencyConfig;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getEvaluationType() {
            return evaluationType;
        }

        public final void setEvaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
        }

        @Override
        public final Builder evaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
            return this;
        }

        @Override
        public final Builder evaluationType(EvaluationType evaluationType) {
            this.evaluationType(evaluationType == null ? null : evaluationType.toString());
            return this;
        }

        public final String getMetricSourceType() {
            return metricSourceType;
        }

        public final void setMetricSourceType(String metricSourceType) {
            this.metricSourceType = metricSourceType;
        }

        @Override
        public final Builder metricSourceType(String metricSourceType) {
            this.metricSourceType = metricSourceType;
            return this;
        }

        @Override
        public final Builder metricSourceType(MetricSourceType metricSourceType) {
            this.metricSourceType(metricSourceType == null ? null : metricSourceType.toString());
            return this;
        }

        @Override
        public ServiceLevelObjectiveSummary build() {
            return new ServiceLevelObjectiveSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
