/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationsignals.model.ApplicationSignalsResponse;
import software.amazon.awssdk.services.applicationsignals.model.ExclusionWindow;
import software.amazon.awssdk.services.applicationsignals.model.ExclusionWindowsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServiceLevelObjectiveExclusionWindowsResponse
extends ApplicationSignalsResponse
implements ToCopyableBuilder<Builder, ListServiceLevelObjectiveExclusionWindowsResponse> {
    private static final SdkField<List<ExclusionWindow>> EXCLUSION_WINDOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExclusionWindows").getter(ListServiceLevelObjectiveExclusionWindowsResponse.getter(ListServiceLevelObjectiveExclusionWindowsResponse::exclusionWindows)).setter(ListServiceLevelObjectiveExclusionWindowsResponse.setter(Builder::exclusionWindows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionWindows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExclusionWindow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListServiceLevelObjectiveExclusionWindowsResponse.getter(ListServiceLevelObjectiveExclusionWindowsResponse::nextToken)).setter(ListServiceLevelObjectiveExclusionWindowsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUSION_WINDOWS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListServiceLevelObjectiveExclusionWindowsResponse.memberNameToFieldInitializer();
    private final List<ExclusionWindow> exclusionWindows;
    private final String nextToken;

    private ListServiceLevelObjectiveExclusionWindowsResponse(BuilderImpl builder) {
        super(builder);
        this.exclusionWindows = builder.exclusionWindows;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasExclusionWindows() {
        return this.exclusionWindows != null && !(this.exclusionWindows instanceof SdkAutoConstructList);
    }

    public final List<ExclusionWindow> exclusionWindows() {
        return this.exclusionWindows;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusionWindows() ? this.exclusionWindows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceLevelObjectiveExclusionWindowsResponse)) {
            return false;
        }
        ListServiceLevelObjectiveExclusionWindowsResponse other = (ListServiceLevelObjectiveExclusionWindowsResponse)((Object)obj);
        return this.hasExclusionWindows() == other.hasExclusionWindows() && Objects.equals(this.exclusionWindows(), other.exclusionWindows()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListServiceLevelObjectiveExclusionWindowsResponse").add("ExclusionWindows", this.hasExclusionWindows() ? this.exclusionWindows() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExclusionWindows": {
                return Optional.ofNullable(clazz.cast(this.exclusionWindows()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExclusionWindows", EXCLUSION_WINDOWS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServiceLevelObjectiveExclusionWindowsResponse, T> g) {
        return obj -> g.apply((ListServiceLevelObjectiveExclusionWindowsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationSignalsResponse.BuilderImpl
    implements Builder {
        private List<ExclusionWindow> exclusionWindows = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceLevelObjectiveExclusionWindowsResponse model) {
            super(model);
            this.exclusionWindows(model.exclusionWindows);
            this.nextToken(model.nextToken);
        }

        public final List<ExclusionWindow.Builder> getExclusionWindows() {
            List<ExclusionWindow.Builder> result = ExclusionWindowsCopier.copyToBuilder(this.exclusionWindows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExclusionWindows(Collection<ExclusionWindow.BuilderImpl> exclusionWindows) {
            this.exclusionWindows = ExclusionWindowsCopier.copyFromBuilder(exclusionWindows);
        }

        @Override
        public final Builder exclusionWindows(Collection<ExclusionWindow> exclusionWindows) {
            this.exclusionWindows = ExclusionWindowsCopier.copy(exclusionWindows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionWindows(ExclusionWindow ... exclusionWindows) {
            this.exclusionWindows(Arrays.asList(exclusionWindows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionWindows(Consumer<ExclusionWindow.Builder> ... exclusionWindows) {
            this.exclusionWindows(Stream.of(exclusionWindows).map(c -> (ExclusionWindow)((ExclusionWindow.Builder)ExclusionWindow.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListServiceLevelObjectiveExclusionWindowsResponse build() {
            return new ListServiceLevelObjectiveExclusionWindowsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApplicationSignalsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServiceLevelObjectiveExclusionWindowsResponse> {
        public Builder exclusionWindows(Collection<ExclusionWindow> var1);

        public Builder exclusionWindows(ExclusionWindow ... var1);

        public Builder exclusionWindows(Consumer<ExclusionWindow.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

