/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a filter for service attributes. Used to narrow down results based on specific attribute names and values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeFilter implements SdkPojo, Serializable, ToCopyableBuilder<AttributeFilter.Builder, AttributeFilter> {
    private static final SdkField<String> ATTRIBUTE_FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeFilterName").getter(getter(AttributeFilter::attributeFilterName))
            .setter(setter(Builder::attributeFilterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeFilterName").build())
            .build();

    private static final SdkField<List<String>> ATTRIBUTE_FILTER_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AttributeFilterValues")
            .getter(getter(AttributeFilter::attributeFilterValues))
            .setter(setter(Builder::attributeFilterValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeFilterValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FILTER_NAME_FIELD,
            ATTRIBUTE_FILTER_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attributeFilterName;

    private final List<String> attributeFilterValues;

    private AttributeFilter(BuilderImpl builder) {
        this.attributeFilterName = builder.attributeFilterName;
        this.attributeFilterValues = builder.attributeFilterValues;
    }

    /**
     * <p>
     * The name of the attribute to filter on. This corresponds to service metadata attributes such as environment,
     * team, or custom tags.
     * </p>
     * 
     * @return The name of the attribute to filter on. This corresponds to service metadata attributes such as
     *         environment, team, or custom tags.
     */
    public final String attributeFilterName() {
        return attributeFilterName;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeFilterValues property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAttributeFilterValues() {
        return attributeFilterValues != null && !(attributeFilterValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of values to match against the specified attribute. Services with attribute values matching any of these
     * values will be included in the results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeFilterValues} method.
     * </p>
     * 
     * @return An array of values to match against the specified attribute. Services with attribute values matching any
     *         of these values will be included in the results.
     */
    public final List<String> attributeFilterValues() {
        return attributeFilterValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeFilterValues() ? attributeFilterValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeFilter)) {
            return false;
        }
        AttributeFilter other = (AttributeFilter) obj;
        return Objects.equals(attributeFilterName(), other.attributeFilterName())
                && hasAttributeFilterValues() == other.hasAttributeFilterValues()
                && Objects.equals(attributeFilterValues(), other.attributeFilterValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeFilter").add("AttributeFilterName", attributeFilterName())
                .add("AttributeFilterValues", hasAttributeFilterValues() ? attributeFilterValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeFilterName":
            return Optional.ofNullable(clazz.cast(attributeFilterName()));
        case "AttributeFilterValues":
            return Optional.ofNullable(clazz.cast(attributeFilterValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttributeFilterName", ATTRIBUTE_FILTER_NAME_FIELD);
        map.put("AttributeFilterValues", ATTRIBUTE_FILTER_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttributeFilter, T> g) {
        return obj -> g.apply((AttributeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeFilter> {
        /**
         * <p>
         * The name of the attribute to filter on. This corresponds to service metadata attributes such as environment,
         * team, or custom tags.
         * </p>
         * 
         * @param attributeFilterName
         *        The name of the attribute to filter on. This corresponds to service metadata attributes such as
         *        environment, team, or custom tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeFilterName(String attributeFilterName);

        /**
         * <p>
         * An array of values to match against the specified attribute. Services with attribute values matching any of
         * these values will be included in the results.
         * </p>
         * 
         * @param attributeFilterValues
         *        An array of values to match against the specified attribute. Services with attribute values matching
         *        any of these values will be included in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeFilterValues(Collection<String> attributeFilterValues);

        /**
         * <p>
         * An array of values to match against the specified attribute. Services with attribute values matching any of
         * these values will be included in the results.
         * </p>
         * 
         * @param attributeFilterValues
         *        An array of values to match against the specified attribute. Services with attribute values matching
         *        any of these values will be included in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeFilterValues(String... attributeFilterValues);
    }

    static final class BuilderImpl implements Builder {
        private String attributeFilterName;

        private List<String> attributeFilterValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeFilter model) {
            attributeFilterName(model.attributeFilterName);
            attributeFilterValues(model.attributeFilterValues);
        }

        public final String getAttributeFilterName() {
            return attributeFilterName;
        }

        public final void setAttributeFilterName(String attributeFilterName) {
            this.attributeFilterName = attributeFilterName;
        }

        @Override
        public final Builder attributeFilterName(String attributeFilterName) {
            this.attributeFilterName = attributeFilterName;
            return this;
        }

        public final Collection<String> getAttributeFilterValues() {
            if (attributeFilterValues instanceof SdkAutoConstructList) {
                return null;
            }
            return attributeFilterValues;
        }

        public final void setAttributeFilterValues(Collection<String> attributeFilterValues) {
            this.attributeFilterValues = AttributeFilterValuesCopier.copy(attributeFilterValues);
        }

        @Override
        public final Builder attributeFilterValues(Collection<String> attributeFilterValues) {
            this.attributeFilterValues = AttributeFilterValuesCopier.copy(attributeFilterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeFilterValues(String... attributeFilterValues) {
            attributeFilterValues(Arrays.asList(attributeFilterValues));
            return this;
        }

        @Override
        public AttributeFilter build() {
            return new AttributeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
