/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of an audit performed by a specific auditor on a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuditorResult implements SdkPojo, Serializable, ToCopyableBuilder<AuditorResult.Builder, AuditorResult> {
    private static final SdkField<String> AUDITOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Auditor")
            .getter(getter(AuditorResult::auditor)).setter(setter(Builder::auditor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Auditor").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AuditorResult::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Severity").getter(getter(AuditorResult::severityAsString)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDITOR_FIELD,
            DESCRIPTION_FIELD, SEVERITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String auditor;

    private final String description;

    private final String severity;

    private AuditorResult(BuilderImpl builder) {
        this.auditor = builder.auditor;
        this.description = builder.description;
        this.severity = builder.severity;
    }

    /**
     * <p>
     * The name or identifier of the auditor that performed the examination and generated this result.
     * </p>
     * 
     * @return The name or identifier of the auditor that performed the examination and generated this result.
     */
    public final String auditor() {
        return auditor;
    }

    /**
     * <p>
     * A detailed description of what the auditor found, including any recommendations for remediation or further
     * investigation.
     * </p>
     * 
     * @return A detailed description of what the auditor found, including any recommendations for remediation or
     *         further investigation.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The severity level of the finding, such as "Critical", "High", "Medium", or "Low". This helps prioritize
     * remediation efforts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link Severity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity level of the finding, such as "Critical", "High", "Medium", or "Low". This helps prioritize
     *         remediation efforts.
     * @see Severity
     */
    public final Severity severity() {
        return Severity.fromValue(severity);
    }

    /**
     * <p>
     * The severity level of the finding, such as "Critical", "High", "Medium", or "Low". This helps prioritize
     * remediation efforts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link Severity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity level of the finding, such as "Critical", "High", "Medium", or "Low". This helps prioritize
     *         remediation efforts.
     * @see Severity
     */
    public final String severityAsString() {
        return severity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(auditor());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditorResult)) {
            return false;
        }
        AuditorResult other = (AuditorResult) obj;
        return Objects.equals(auditor(), other.auditor()) && Objects.equals(description(), other.description())
                && Objects.equals(severityAsString(), other.severityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuditorResult").add("Auditor", auditor()).add("Description", description())
                .add("Severity", severityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Auditor":
            return Optional.ofNullable(clazz.cast(auditor()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Auditor", AUDITOR_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Severity", SEVERITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuditorResult, T> g) {
        return obj -> g.apply((AuditorResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuditorResult> {
        /**
         * <p>
         * The name or identifier of the auditor that performed the examination and generated this result.
         * </p>
         * 
         * @param auditor
         *        The name or identifier of the auditor that performed the examination and generated this result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditor(String auditor);

        /**
         * <p>
         * A detailed description of what the auditor found, including any recommendations for remediation or further
         * investigation.
         * </p>
         * 
         * @param description
         *        A detailed description of what the auditor found, including any recommendations for remediation or
         *        further investigation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The severity level of the finding, such as "Critical", "High", "Medium", or "Low". This helps prioritize
         * remediation efforts.
         * </p>
         * 
         * @param severity
         *        The severity level of the finding, such as "Critical", "High", "Medium", or "Low". This helps
         *        prioritize remediation efforts.
         * @see Severity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Severity
         */
        Builder severity(String severity);

        /**
         * <p>
         * The severity level of the finding, such as "Critical", "High", "Medium", or "Low". This helps prioritize
         * remediation efforts.
         * </p>
         * 
         * @param severity
         *        The severity level of the finding, such as "Critical", "High", "Medium", or "Low". This helps
         *        prioritize remediation efforts.
         * @see Severity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Severity
         */
        Builder severity(Severity severity);
    }

    static final class BuilderImpl implements Builder {
        private String auditor;

        private String description;

        private String severity;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditorResult model) {
            auditor(model.auditor);
            description(model.description);
            severity(model.severity);
        }

        public final String getAuditor() {
            return auditor;
        }

        public final void setAuditor(String auditor) {
            this.auditor = auditor;
        }

        @Override
        public final Builder auditor(String auditor) {
            this.auditor = auditor;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(Severity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        @Override
        public AuditorResult build() {
            return new AuditorResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
