/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateExclusionWindowsRequest extends ApplicationSignalsRequest implements
        ToCopyableBuilder<BatchUpdateExclusionWindowsRequest.Builder, BatchUpdateExclusionWindowsRequest> {
    private static final SdkField<List<String>> SLO_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SloIds")
            .getter(getter(BatchUpdateExclusionWindowsRequest::sloIds))
            .setter(setter(Builder::sloIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SloIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ExclusionWindow>> ADD_EXCLUSION_WINDOWS_FIELD = SdkField
            .<List<ExclusionWindow>> builder(MarshallingType.LIST)
            .memberName("AddExclusionWindows")
            .getter(getter(BatchUpdateExclusionWindowsRequest::addExclusionWindows))
            .setter(setter(Builder::addExclusionWindows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddExclusionWindows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExclusionWindow> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExclusionWindow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ExclusionWindow>> REMOVE_EXCLUSION_WINDOWS_FIELD = SdkField
            .<List<ExclusionWindow>> builder(MarshallingType.LIST)
            .memberName("RemoveExclusionWindows")
            .getter(getter(BatchUpdateExclusionWindowsRequest::removeExclusionWindows))
            .setter(setter(Builder::removeExclusionWindows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveExclusionWindows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExclusionWindow> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExclusionWindow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLO_IDS_FIELD,
            ADD_EXCLUSION_WINDOWS_FIELD, REMOVE_EXCLUSION_WINDOWS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> sloIds;

    private final List<ExclusionWindow> addExclusionWindows;

    private final List<ExclusionWindow> removeExclusionWindows;

    private BatchUpdateExclusionWindowsRequest(BuilderImpl builder) {
        super(builder);
        this.sloIds = builder.sloIds;
        this.addExclusionWindows = builder.addExclusionWindows;
        this.removeExclusionWindows = builder.removeExclusionWindows;
    }

    /**
     * For responses, this returns true if the service returned a value for the SloIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSloIds() {
        return sloIds != null && !(sloIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of SLO IDs to add or remove exclusion windows from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSloIds} method.
     * </p>
     * 
     * @return The list of SLO IDs to add or remove exclusion windows from.
     */
    public final List<String> sloIds() {
        return sloIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddExclusionWindows property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddExclusionWindows() {
        return addExclusionWindows != null && !(addExclusionWindows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of exclusion windows to add to the specified SLOs. You can add up to 10 exclusion windows per SLO.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddExclusionWindows} method.
     * </p>
     * 
     * @return A list of exclusion windows to add to the specified SLOs. You can add up to 10 exclusion windows per SLO.
     */
    public final List<ExclusionWindow> addExclusionWindows() {
        return addExclusionWindows;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveExclusionWindows property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRemoveExclusionWindows() {
        return removeExclusionWindows != null && !(removeExclusionWindows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of exclusion windows to remove from the specified SLOs. The window configuration must match an existing
     * exclusion window.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveExclusionWindows} method.
     * </p>
     * 
     * @return A list of exclusion windows to remove from the specified SLOs. The window configuration must match an
     *         existing exclusion window.
     */
    public final List<ExclusionWindow> removeExclusionWindows() {
        return removeExclusionWindows;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSloIds() ? sloIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAddExclusionWindows() ? addExclusionWindows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveExclusionWindows() ? removeExclusionWindows() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateExclusionWindowsRequest)) {
            return false;
        }
        BatchUpdateExclusionWindowsRequest other = (BatchUpdateExclusionWindowsRequest) obj;
        return hasSloIds() == other.hasSloIds() && Objects.equals(sloIds(), other.sloIds())
                && hasAddExclusionWindows() == other.hasAddExclusionWindows()
                && Objects.equals(addExclusionWindows(), other.addExclusionWindows())
                && hasRemoveExclusionWindows() == other.hasRemoveExclusionWindows()
                && Objects.equals(removeExclusionWindows(), other.removeExclusionWindows());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateExclusionWindowsRequest").add("SloIds", hasSloIds() ? sloIds() : null)
                .add("AddExclusionWindows", hasAddExclusionWindows() ? addExclusionWindows() : null)
                .add("RemoveExclusionWindows", hasRemoveExclusionWindows() ? removeExclusionWindows() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SloIds":
            return Optional.ofNullable(clazz.cast(sloIds()));
        case "AddExclusionWindows":
            return Optional.ofNullable(clazz.cast(addExclusionWindows()));
        case "RemoveExclusionWindows":
            return Optional.ofNullable(clazz.cast(removeExclusionWindows()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SloIds", SLO_IDS_FIELD);
        map.put("AddExclusionWindows", ADD_EXCLUSION_WINDOWS_FIELD);
        map.put("RemoveExclusionWindows", REMOVE_EXCLUSION_WINDOWS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateExclusionWindowsRequest, T> g) {
        return obj -> g.apply((BatchUpdateExclusionWindowsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationSignalsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchUpdateExclusionWindowsRequest> {
        /**
         * <p>
         * The list of SLO IDs to add or remove exclusion windows from.
         * </p>
         * 
         * @param sloIds
         *        The list of SLO IDs to add or remove exclusion windows from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sloIds(Collection<String> sloIds);

        /**
         * <p>
         * The list of SLO IDs to add or remove exclusion windows from.
         * </p>
         * 
         * @param sloIds
         *        The list of SLO IDs to add or remove exclusion windows from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sloIds(String... sloIds);

        /**
         * <p>
         * A list of exclusion windows to add to the specified SLOs. You can add up to 10 exclusion windows per SLO.
         * </p>
         * 
         * @param addExclusionWindows
         *        A list of exclusion windows to add to the specified SLOs. You can add up to 10 exclusion windows per
         *        SLO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addExclusionWindows(Collection<ExclusionWindow> addExclusionWindows);

        /**
         * <p>
         * A list of exclusion windows to add to the specified SLOs. You can add up to 10 exclusion windows per SLO.
         * </p>
         * 
         * @param addExclusionWindows
         *        A list of exclusion windows to add to the specified SLOs. You can add up to 10 exclusion windows per
         *        SLO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addExclusionWindows(ExclusionWindow... addExclusionWindows);

        /**
         * <p>
         * A list of exclusion windows to add to the specified SLOs. You can add up to 10 exclusion windows per SLO.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.ExclusionWindow.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.ExclusionWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.ExclusionWindow.Builder#build()} is called
         * immediately and its result is passed to {@link #addExclusionWindows(List<ExclusionWindow>)}.
         * 
         * @param addExclusionWindows
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.ExclusionWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addExclusionWindows(java.util.Collection<ExclusionWindow>)
         */
        Builder addExclusionWindows(Consumer<ExclusionWindow.Builder>... addExclusionWindows);

        /**
         * <p>
         * A list of exclusion windows to remove from the specified SLOs. The window configuration must match an
         * existing exclusion window.
         * </p>
         * 
         * @param removeExclusionWindows
         *        A list of exclusion windows to remove from the specified SLOs. The window configuration must match an
         *        existing exclusion window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeExclusionWindows(Collection<ExclusionWindow> removeExclusionWindows);

        /**
         * <p>
         * A list of exclusion windows to remove from the specified SLOs. The window configuration must match an
         * existing exclusion window.
         * </p>
         * 
         * @param removeExclusionWindows
         *        A list of exclusion windows to remove from the specified SLOs. The window configuration must match an
         *        existing exclusion window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeExclusionWindows(ExclusionWindow... removeExclusionWindows);

        /**
         * <p>
         * A list of exclusion windows to remove from the specified SLOs. The window configuration must match an
         * existing exclusion window.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.ExclusionWindow.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.ExclusionWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.ExclusionWindow.Builder#build()} is called
         * immediately and its result is passed to {@link #removeExclusionWindows(List<ExclusionWindow>)}.
         * 
         * @param removeExclusionWindows
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.ExclusionWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #removeExclusionWindows(java.util.Collection<ExclusionWindow>)
         */
        Builder removeExclusionWindows(Consumer<ExclusionWindow.Builder>... removeExclusionWindows);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationSignalsRequest.BuilderImpl implements Builder {
        private List<String> sloIds = DefaultSdkAutoConstructList.getInstance();

        private List<ExclusionWindow> addExclusionWindows = DefaultSdkAutoConstructList.getInstance();

        private List<ExclusionWindow> removeExclusionWindows = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateExclusionWindowsRequest model) {
            super(model);
            sloIds(model.sloIds);
            addExclusionWindows(model.addExclusionWindows);
            removeExclusionWindows(model.removeExclusionWindows);
        }

        public final Collection<String> getSloIds() {
            if (sloIds instanceof SdkAutoConstructList) {
                return null;
            }
            return sloIds;
        }

        public final void setSloIds(Collection<String> sloIds) {
            this.sloIds = ServiceLevelObjectiveIdsCopier.copy(sloIds);
        }

        @Override
        public final Builder sloIds(Collection<String> sloIds) {
            this.sloIds = ServiceLevelObjectiveIdsCopier.copy(sloIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sloIds(String... sloIds) {
            sloIds(Arrays.asList(sloIds));
            return this;
        }

        public final List<ExclusionWindow.Builder> getAddExclusionWindows() {
            List<ExclusionWindow.Builder> result = ExclusionWindowsCopier.copyToBuilder(this.addExclusionWindows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddExclusionWindows(Collection<ExclusionWindow.BuilderImpl> addExclusionWindows) {
            this.addExclusionWindows = ExclusionWindowsCopier.copyFromBuilder(addExclusionWindows);
        }

        @Override
        public final Builder addExclusionWindows(Collection<ExclusionWindow> addExclusionWindows) {
            this.addExclusionWindows = ExclusionWindowsCopier.copy(addExclusionWindows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addExclusionWindows(ExclusionWindow... addExclusionWindows) {
            addExclusionWindows(Arrays.asList(addExclusionWindows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addExclusionWindows(Consumer<ExclusionWindow.Builder>... addExclusionWindows) {
            addExclusionWindows(Stream.of(addExclusionWindows).map(c -> ExclusionWindow.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ExclusionWindow.Builder> getRemoveExclusionWindows() {
            List<ExclusionWindow.Builder> result = ExclusionWindowsCopier.copyToBuilder(this.removeExclusionWindows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoveExclusionWindows(Collection<ExclusionWindow.BuilderImpl> removeExclusionWindows) {
            this.removeExclusionWindows = ExclusionWindowsCopier.copyFromBuilder(removeExclusionWindows);
        }

        @Override
        public final Builder removeExclusionWindows(Collection<ExclusionWindow> removeExclusionWindows) {
            this.removeExclusionWindows = ExclusionWindowsCopier.copy(removeExclusionWindows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeExclusionWindows(ExclusionWindow... removeExclusionWindows) {
            removeExclusionWindows(Arrays.asList(removeExclusionWindows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeExclusionWindows(Consumer<ExclusionWindow.Builder>... removeExclusionWindows) {
            removeExclusionWindows(Stream.of(removeExclusionWindows).map(c -> ExclusionWindow.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateExclusionWindowsRequest build() {
            return new BatchUpdateExclusionWindowsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
