/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a graph showing the dependencies between services and components in your application architecture.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DependencyGraph implements SdkPojo, Serializable, ToCopyableBuilder<DependencyGraph.Builder, DependencyGraph> {
    private static final SdkField<List<Node>> NODES_FIELD = SdkField
            .<List<Node>> builder(MarshallingType.LIST)
            .memberName("Nodes")
            .getter(getter(DependencyGraph::nodes))
            .setter(setter(Builder::nodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Nodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Node> builder(MarshallingType.SDK_POJO)
                                            .constructor(Node::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Edge>> EDGES_FIELD = SdkField
            .<List<Edge>> builder(MarshallingType.LIST)
            .memberName("Edges")
            .getter(getter(DependencyGraph::edges))
            .setter(setter(Builder::edges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Edge> builder(MarshallingType.SDK_POJO)
                                            .constructor(Edge::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODES_FIELD, EDGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Node> nodes;

    private final List<Edge> edges;

    private DependencyGraph(BuilderImpl builder) {
        this.nodes = builder.nodes;
        this.edges = builder.edges;
    }

    /**
     * For responses, this returns true if the service returned a value for the Nodes property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNodes() {
        return nodes != null && !(nodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of nodes in the dependency graph, where each node represents a service or component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodes} method.
     * </p>
     * 
     * @return An array of nodes in the dependency graph, where each node represents a service or component.
     */
    public final List<Node> nodes() {
        return nodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Edges property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasEdges() {
        return edges != null && !(edges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of edges in the dependency graph, where each edge represents a connection or dependency between two
     * nodes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEdges} method.
     * </p>
     * 
     * @return An array of edges in the dependency graph, where each edge represents a connection or dependency between
     *         two nodes.
     */
    public final List<Edge> edges() {
        return edges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasNodes() ? nodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEdges() ? edges() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DependencyGraph)) {
            return false;
        }
        DependencyGraph other = (DependencyGraph) obj;
        return hasNodes() == other.hasNodes() && Objects.equals(nodes(), other.nodes()) && hasEdges() == other.hasEdges()
                && Objects.equals(edges(), other.edges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DependencyGraph").add("Nodes", hasNodes() ? nodes() : null)
                .add("Edges", hasEdges() ? edges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Nodes":
            return Optional.ofNullable(clazz.cast(nodes()));
        case "Edges":
            return Optional.ofNullable(clazz.cast(edges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Nodes", NODES_FIELD);
        map.put("Edges", EDGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DependencyGraph, T> g) {
        return obj -> g.apply((DependencyGraph) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DependencyGraph> {
        /**
         * <p>
         * An array of nodes in the dependency graph, where each node represents a service or component.
         * </p>
         * 
         * @param nodes
         *        An array of nodes in the dependency graph, where each node represents a service or component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodes(Collection<Node> nodes);

        /**
         * <p>
         * An array of nodes in the dependency graph, where each node represents a service or component.
         * </p>
         * 
         * @param nodes
         *        An array of nodes in the dependency graph, where each node represents a service or component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodes(Node... nodes);

        /**
         * <p>
         * An array of nodes in the dependency graph, where each node represents a service or component.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.Node.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.applicationsignals.model.Node#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.Node.Builder#build()} is called immediately
         * and its result is passed to {@link #nodes(List<Node>)}.
         * 
         * @param nodes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.Node.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodes(java.util.Collection<Node>)
         */
        Builder nodes(Consumer<Node.Builder>... nodes);

        /**
         * <p>
         * An array of edges in the dependency graph, where each edge represents a connection or dependency between two
         * nodes.
         * </p>
         * 
         * @param edges
         *        An array of edges in the dependency graph, where each edge represents a connection or dependency
         *        between two nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edges(Collection<Edge> edges);

        /**
         * <p>
         * An array of edges in the dependency graph, where each edge represents a connection or dependency between two
         * nodes.
         * </p>
         * 
         * @param edges
         *        An array of edges in the dependency graph, where each edge represents a connection or dependency
         *        between two nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edges(Edge... edges);

        /**
         * <p>
         * An array of edges in the dependency graph, where each edge represents a connection or dependency between two
         * nodes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.Edge.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.applicationsignals.model.Edge#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.Edge.Builder#build()} is called immediately
         * and its result is passed to {@link #edges(List<Edge>)}.
         * 
         * @param edges
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.Edge.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #edges(java.util.Collection<Edge>)
         */
        Builder edges(Consumer<Edge.Builder>... edges);
    }

    static final class BuilderImpl implements Builder {
        private List<Node> nodes = DefaultSdkAutoConstructList.getInstance();

        private List<Edge> edges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DependencyGraph model) {
            nodes(model.nodes);
            edges(model.edges);
        }

        public final List<Node.Builder> getNodes() {
            List<Node.Builder> result = NodesCopier.copyToBuilder(this.nodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodes(Collection<Node.BuilderImpl> nodes) {
            this.nodes = NodesCopier.copyFromBuilder(nodes);
        }

        @Override
        public final Builder nodes(Collection<Node> nodes) {
            this.nodes = NodesCopier.copy(nodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(Node... nodes) {
            nodes(Arrays.asList(nodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(Consumer<Node.Builder>... nodes) {
            nodes(Stream.of(nodes).map(c -> Node.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Edge.Builder> getEdges() {
            List<Edge.Builder> result = EdgesCopier.copyToBuilder(this.edges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEdges(Collection<Edge.BuilderImpl> edges) {
            this.edges = EdgesCopier.copyFromBuilder(edges);
        }

        @Override
        public final Builder edges(Collection<Edge> edges) {
            this.edges = EdgesCopier.copy(edges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edges(Edge... edges) {
            edges(Arrays.asList(edges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edges(Consumer<Edge.Builder>... edges) {
            edges(Stream.of(edges).map(c -> Edge.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DependencyGraph build() {
            return new DependencyGraph(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
