/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceResponse extends ApplicationSignalsResponse implements
        ToCopyableBuilder<GetServiceResponse.Builder, GetServiceResponse> {
    private static final SdkField<Service> SERVICE_FIELD = SdkField.<Service> builder(MarshallingType.SDK_POJO)
            .memberName("Service").getter(getter(GetServiceResponse::service)).setter(setter(Builder::service))
            .constructor(Service::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(GetServiceResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(GetServiceResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<List<Map<String, String>>> LOG_GROUP_REFERENCES_FIELD = SdkField
            .<List<Map<String, String>>> builder(MarshallingType.LIST)
            .memberName("LogGroupReferences")
            .getter(getter(GetServiceResponse::logGroupReferences))
            .setter(setter(Builder::logGroupReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupReferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, LOG_GROUP_REFERENCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Service service;

    private final Instant startTime;

    private final Instant endTime;

    private final List<Map<String, String>> logGroupReferences;

    private GetServiceResponse(BuilderImpl builder) {
        super(builder);
        this.service = builder.service;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.logGroupReferences = builder.logGroupReferences;
    }

    /**
     * <p>
     * A structure containing information about the service.
     * </p>
     * 
     * @return A structure containing information about the service.
     */
    public final Service service() {
        return service;
    }

    /**
     * <p>
     * The start time of the data included in the response. In a raw HTTP Query API, it is formatted as be epoch time in
     * seconds. For example: <code>1698778057</code>.
     * </p>
     * <p>
     * This displays the time that Application Signals used for the request. It might not match your request exactly,
     * because it was rounded to the nearest hour.
     * </p>
     * 
     * @return The start time of the data included in the response. In a raw HTTP Query API, it is formatted as be epoch
     *         time in seconds. For example: <code>1698778057</code>.</p>
     *         <p>
     *         This displays the time that Application Signals used for the request. It might not match your request
     *         exactly, because it was rounded to the nearest hour.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time of the data included in the response. In a raw HTTP Query API, it is formatted as be epoch time in
     * seconds. For example: <code>1698778057</code>.
     * </p>
     * <p>
     * This displays the time that Application Signals used for the request. It might not match your request exactly,
     * because it was rounded to the nearest hour.
     * </p>
     * 
     * @return The end time of the data included in the response. In a raw HTTP Query API, it is formatted as be epoch
     *         time in seconds. For example: <code>1698778057</code>.</p>
     *         <p>
     *         This displays the time that Application Signals used for the request. It might not match your request
     *         exactly, because it was rounded to the nearest hour.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogGroupReferences property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogGroupReferences() {
        return logGroupReferences != null && !(logGroupReferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of string-to-string maps that each contain information about one log group associated with this service.
     * Each string-to-string map includes the following fields:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"Type": "AWS::Resource"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"ResourceType": "AWS::Logs::LogGroup"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"Identifier": "<i>name-of-log-group</i>"</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogGroupReferences} method.
     * </p>
     * 
     * @return An array of string-to-string maps that each contain information about one log group associated with this
     *         service. Each string-to-string map includes the following fields:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>"Type": "AWS::Resource"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"ResourceType": "AWS::Logs::LogGroup"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"Identifier": "<i>name-of-log-group</i>"</code>
     *         </p>
     *         </li>
     */
    public final List<Map<String, String>> logGroupReferences() {
        return logGroupReferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogGroupReferences() ? logGroupReferences() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceResponse)) {
            return false;
        }
        GetServiceResponse other = (GetServiceResponse) obj;
        return Objects.equals(service(), other.service()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && hasLogGroupReferences() == other.hasLogGroupReferences()
                && Objects.equals(logGroupReferences(), other.logGroupReferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetServiceResponse").add("Service", service()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("LogGroupReferences", hasLogGroupReferences() ? logGroupReferences() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Service":
            return Optional.ofNullable(clazz.cast(service()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "LogGroupReferences":
            return Optional.ofNullable(clazz.cast(logGroupReferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Service", SERVICE_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("LogGroupReferences", LOG_GROUP_REFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetServiceResponse, T> g) {
        return obj -> g.apply((GetServiceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationSignalsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetServiceResponse> {
        /**
         * <p>
         * A structure containing information about the service.
         * </p>
         * 
         * @param service
         *        A structure containing information about the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(Service service);

        /**
         * <p>
         * A structure containing information about the service.
         * </p>
         * This is a convenience method that creates an instance of the {@link Service.Builder} avoiding the need to
         * create one manually via {@link Service#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Service.Builder#build()} is called immediately and its result is
         * passed to {@link #service(Service)}.
         * 
         * @param service
         *        a consumer that will call methods on {@link Service.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #service(Service)
         */
        default Builder service(Consumer<Service.Builder> service) {
            return service(Service.builder().applyMutation(service).build());
        }

        /**
         * <p>
         * The start time of the data included in the response. In a raw HTTP Query API, it is formatted as be epoch
         * time in seconds. For example: <code>1698778057</code>.
         * </p>
         * <p>
         * This displays the time that Application Signals used for the request. It might not match your request
         * exactly, because it was rounded to the nearest hour.
         * </p>
         * 
         * @param startTime
         *        The start time of the data included in the response. In a raw HTTP Query API, it is formatted as be
         *        epoch time in seconds. For example: <code>1698778057</code>.</p>
         *        <p>
         *        This displays the time that Application Signals used for the request. It might not match your request
         *        exactly, because it was rounded to the nearest hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time of the data included in the response. In a raw HTTP Query API, it is formatted as be epoch time
         * in seconds. For example: <code>1698778057</code>.
         * </p>
         * <p>
         * This displays the time that Application Signals used for the request. It might not match your request
         * exactly, because it was rounded to the nearest hour.
         * </p>
         * 
         * @param endTime
         *        The end time of the data included in the response. In a raw HTTP Query API, it is formatted as be
         *        epoch time in seconds. For example: <code>1698778057</code>.</p>
         *        <p>
         *        This displays the time that Application Signals used for the request. It might not match your request
         *        exactly, because it was rounded to the nearest hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * An array of string-to-string maps that each contain information about one log group associated with this
         * service. Each string-to-string map includes the following fields:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>"Type": "AWS::Resource"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"ResourceType": "AWS::Logs::LogGroup"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"Identifier": "<i>name-of-log-group</i>"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param logGroupReferences
         *        An array of string-to-string maps that each contain information about one log group associated with
         *        this service. Each string-to-string map includes the following fields:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>"Type": "AWS::Resource"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"ResourceType": "AWS::Logs::LogGroup"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"Identifier": "<i>name-of-log-group</i>"</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupReferences(Collection<? extends Map<String, String>> logGroupReferences);

        /**
         * <p>
         * An array of string-to-string maps that each contain information about one log group associated with this
         * service. Each string-to-string map includes the following fields:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>"Type": "AWS::Resource"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"ResourceType": "AWS::Logs::LogGroup"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"Identifier": "<i>name-of-log-group</i>"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param logGroupReferences
         *        An array of string-to-string maps that each contain information about one log group associated with
         *        this service. Each string-to-string map includes the following fields:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>"Type": "AWS::Resource"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"ResourceType": "AWS::Logs::LogGroup"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"Identifier": "<i>name-of-log-group</i>"</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupReferences(Map<String, String>... logGroupReferences);
    }

    static final class BuilderImpl extends ApplicationSignalsResponse.BuilderImpl implements Builder {
        private Service service;

        private Instant startTime;

        private Instant endTime;

        private List<Map<String, String>> logGroupReferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceResponse model) {
            super(model);
            service(model.service);
            startTime(model.startTime);
            endTime(model.endTime);
            logGroupReferences(model.logGroupReferences);
        }

        public final Service.Builder getService() {
            return service != null ? service.toBuilder() : null;
        }

        public final void setService(Service.BuilderImpl service) {
            this.service = service != null ? service.build() : null;
        }

        @Override
        public final Builder service(Service service) {
            this.service = service;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Collection<? extends Map<String, String>> getLogGroupReferences() {
            if (logGroupReferences instanceof SdkAutoConstructList) {
                return null;
            }
            return logGroupReferences;
        }

        public final void setLogGroupReferences(Collection<? extends Map<String, String>> logGroupReferences) {
            this.logGroupReferences = LogGroupReferencesCopier.copy(logGroupReferences);
        }

        @Override
        public final Builder logGroupReferences(Collection<? extends Map<String, String>> logGroupReferences) {
            this.logGroupReferences = LogGroupReferencesCopier.copy(logGroupReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupReferences(Map<String, String>... logGroupReferences) {
            logGroupReferences(Arrays.asList(logGroupReferences));
            return this;
        }

        @Override
        public GetServiceResponse build() {
            return new GetServiceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
