/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAuditFindingsRequest extends ApplicationSignalsRequest implements
        ToCopyableBuilder<ListAuditFindingsRequest.Builder, ListAuditFindingsRequest> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ListAuditFindingsRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ListAuditFindingsRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("EndTime").build()).build();

    private static final SdkField<List<String>> AUDITORS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Auditors")
            .getter(getter(ListAuditFindingsRequest::auditors))
            .setter(setter(Builder::auditors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Auditors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AuditTarget>> AUDIT_TARGETS_FIELD = SdkField
            .<List<AuditTarget>> builder(MarshallingType.LIST)
            .memberName("AuditTargets")
            .getter(getter(ListAuditFindingsRequest::auditTargets))
            .setter(setter(Builder::auditTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuditTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuditTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAuditFindingsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListAuditFindingsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, AUDITORS_FIELD, AUDIT_TARGETS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant startTime;

    private final Instant endTime;

    private final List<String> auditors;

    private final List<AuditTarget> auditTargets;

    private final String nextToken;

    private final Integer maxResults;

    private ListAuditFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.auditors = builder.auditors;
        this.auditTargets = builder.auditTargets;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The start time for the audit findings query. Only findings created on or after this time will be included in the
     * results. Specify the time as the number of milliseconds since January 1, 1970, 00:00:00 UTC.
     * </p>
     * 
     * @return The start time for the audit findings query. Only findings created on or after this time will be included
     *         in the results. Specify the time as the number of milliseconds since January 1, 1970, 00:00:00 UTC.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time for the audit findings query. Only findings created before this time will be included in the
     * results. Specify the time as the number of milliseconds since January 1, 1970, 00:00:00 UTC.
     * </p>
     * 
     * @return The end time for the audit findings query. Only findings created before this time will be included in the
     *         results. Specify the time as the number of milliseconds since January 1, 1970, 00:00:00 UTC.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Auditors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAuditors() {
        return auditors != null && !(auditors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of auditor names to filter the findings. Only findings generated by the specified auditors will be
     * returned. When not specified, findings from all auditors are included except canary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuditors} method.
     * </p>
     * 
     * @return An array of auditor names to filter the findings. Only findings generated by the specified auditors will
     *         be returned. When not specified, findings from all auditors are included except canary.
     */
    public final List<String> auditors() {
        return auditors;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuditTargets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuditTargets() {
        return auditTargets != null && !(auditTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of audit target specifications to filter the findings. Only findings related to the specified targets
     * (such as specific services, SLOs, operations or canary) will be returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuditTargets} method.
     * </p>
     * 
     * @return An array of audit target specifications to filter the findings. Only findings related to the specified
     *         targets (such as specific services, SLOs, operations or canary) will be returned.
     */
    public final List<AuditTarget> auditTargets() {
        return auditTargets;
    }

    /**
     * <p>
     * The token for the next set of results. Use this token to retrieve additional pages of audit findings when the
     * result set is large.
     * </p>
     * 
     * @return The token for the next set of results. Use this token to retrieve additional pages of audit findings when
     *         the result set is large.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of audit findings to return in a single request. Valid range is 1 to 100. If not specified,
     * defaults to 50.
     * </p>
     * 
     * @return The maximum number of audit findings to return in a single request. Valid range is 1 to 100. If not
     *         specified, defaults to 50.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuditors() ? auditors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAuditTargets() ? auditTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuditFindingsRequest)) {
            return false;
        }
        ListAuditFindingsRequest other = (ListAuditFindingsRequest) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && hasAuditors() == other.hasAuditors() && Objects.equals(auditors(), other.auditors())
                && hasAuditTargets() == other.hasAuditTargets() && Objects.equals(auditTargets(), other.auditTargets())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAuditFindingsRequest").add("StartTime", startTime()).add("EndTime", endTime())
                .add("Auditors", hasAuditors() ? auditors() : null)
                .add("AuditTargets", hasAuditTargets() ? auditTargets() : null).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Auditors":
            return Optional.ofNullable(clazz.cast(auditors()));
        case "AuditTargets":
            return Optional.ofNullable(clazz.cast(auditTargets()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Auditors", AUDITORS_FIELD);
        map.put("AuditTargets", AUDIT_TARGETS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAuditFindingsRequest, T> g) {
        return obj -> g.apply((ListAuditFindingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationSignalsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAuditFindingsRequest> {
        /**
         * <p>
         * The start time for the audit findings query. Only findings created on or after this time will be included in
         * the results. Specify the time as the number of milliseconds since January 1, 1970, 00:00:00 UTC.
         * </p>
         * 
         * @param startTime
         *        The start time for the audit findings query. Only findings created on or after this time will be
         *        included in the results. Specify the time as the number of milliseconds since January 1, 1970,
         *        00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time for the audit findings query. Only findings created before this time will be included in the
         * results. Specify the time as the number of milliseconds since January 1, 1970, 00:00:00 UTC.
         * </p>
         * 
         * @param endTime
         *        The end time for the audit findings query. Only findings created before this time will be included in
         *        the results. Specify the time as the number of milliseconds since January 1, 1970, 00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * An array of auditor names to filter the findings. Only findings generated by the specified auditors will be
         * returned. When not specified, findings from all auditors are included except canary.
         * </p>
         * 
         * @param auditors
         *        An array of auditor names to filter the findings. Only findings generated by the specified auditors
         *        will be returned. When not specified, findings from all auditors are included except canary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditors(Collection<String> auditors);

        /**
         * <p>
         * An array of auditor names to filter the findings. Only findings generated by the specified auditors will be
         * returned. When not specified, findings from all auditors are included except canary.
         * </p>
         * 
         * @param auditors
         *        An array of auditor names to filter the findings. Only findings generated by the specified auditors
         *        will be returned. When not specified, findings from all auditors are included except canary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditors(String... auditors);

        /**
         * <p>
         * An array of audit target specifications to filter the findings. Only findings related to the specified
         * targets (such as specific services, SLOs, operations or canary) will be returned.
         * </p>
         * 
         * @param auditTargets
         *        An array of audit target specifications to filter the findings. Only findings related to the specified
         *        targets (such as specific services, SLOs, operations or canary) will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditTargets(Collection<AuditTarget> auditTargets);

        /**
         * <p>
         * An array of audit target specifications to filter the findings. Only findings related to the specified
         * targets (such as specific services, SLOs, operations or canary) will be returned.
         * </p>
         * 
         * @param auditTargets
         *        An array of audit target specifications to filter the findings. Only findings related to the specified
         *        targets (such as specific services, SLOs, operations or canary) will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditTargets(AuditTarget... auditTargets);

        /**
         * <p>
         * An array of audit target specifications to filter the findings. Only findings related to the specified
         * targets (such as specific services, SLOs, operations or canary) will be returned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.AuditTarget.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.AuditTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.AuditTarget.Builder#build()} is called
         * immediately and its result is passed to {@link #auditTargets(List<AuditTarget>)}.
         * 
         * @param auditTargets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.AuditTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auditTargets(java.util.Collection<AuditTarget>)
         */
        Builder auditTargets(Consumer<AuditTarget.Builder>... auditTargets);

        /**
         * <p>
         * The token for the next set of results. Use this token to retrieve additional pages of audit findings when the
         * result set is large.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use this token to retrieve additional pages of audit findings
         *        when the result set is large.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of audit findings to return in a single request. Valid range is 1 to 100. If not
         * specified, defaults to 50.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of audit findings to return in a single request. Valid range is 1 to 100. If not
         *        specified, defaults to 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationSignalsRequest.BuilderImpl implements Builder {
        private Instant startTime;

        private Instant endTime;

        private List<String> auditors = DefaultSdkAutoConstructList.getInstance();

        private List<AuditTarget> auditTargets = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuditFindingsRequest model) {
            super(model);
            startTime(model.startTime);
            endTime(model.endTime);
            auditors(model.auditors);
            auditTargets(model.auditTargets);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Collection<String> getAuditors() {
            if (auditors instanceof SdkAutoConstructList) {
                return null;
            }
            return auditors;
        }

        public final void setAuditors(Collection<String> auditors) {
            this.auditors = AuditorsCopier.copy(auditors);
        }

        @Override
        public final Builder auditors(Collection<String> auditors) {
            this.auditors = AuditorsCopier.copy(auditors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditors(String... auditors) {
            auditors(Arrays.asList(auditors));
            return this;
        }

        public final List<AuditTarget.Builder> getAuditTargets() {
            List<AuditTarget.Builder> result = AuditTargetsCopier.copyToBuilder(this.auditTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuditTargets(Collection<AuditTarget.BuilderImpl> auditTargets) {
            this.auditTargets = AuditTargetsCopier.copyFromBuilder(auditTargets);
        }

        @Override
        public final Builder auditTargets(Collection<AuditTarget> auditTargets) {
            this.auditTargets = AuditTargetsCopier.copy(auditTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditTargets(AuditTarget... auditTargets) {
            auditTargets(Arrays.asList(auditTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditTargets(Consumer<AuditTarget.Builder>... auditTargets) {
            auditTargets(Stream.of(auditTargets).map(c -> AuditTarget.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAuditFindingsRequest build() {
            return new ListAuditFindingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
