/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGroupingAttributeDefinitionsResponse extends ApplicationSignalsResponse implements
        ToCopyableBuilder<ListGroupingAttributeDefinitionsResponse.Builder, ListGroupingAttributeDefinitionsResponse> {
    private static final SdkField<List<GroupingAttributeDefinition>> GROUPING_ATTRIBUTE_DEFINITIONS_FIELD = SdkField
            .<List<GroupingAttributeDefinition>> builder(MarshallingType.LIST)
            .memberName("GroupingAttributeDefinitions")
            .getter(getter(ListGroupingAttributeDefinitionsResponse::groupingAttributeDefinitions))
            .setter(setter(Builder::groupingAttributeDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupingAttributeDefinitions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupingAttributeDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupingAttributeDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(ListGroupingAttributeDefinitionsResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListGroupingAttributeDefinitionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GROUPING_ATTRIBUTE_DEFINITIONS_FIELD, UPDATED_AT_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<GroupingAttributeDefinition> groupingAttributeDefinitions;

    private final Instant updatedAt;

    private final String nextToken;

    private ListGroupingAttributeDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.groupingAttributeDefinitions = builder.groupingAttributeDefinitions;
        this.updatedAt = builder.updatedAt;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupingAttributeDefinitions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGroupingAttributeDefinitions() {
        return groupingAttributeDefinitions != null && !(groupingAttributeDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of available grouping attribute definitions that can be used to create grouping configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupingAttributeDefinitions} method.
     * </p>
     * 
     * @return An array of available grouping attribute definitions that can be used to create grouping configurations.
     */
    public final List<GroupingAttributeDefinition> groupingAttributeDefinitions() {
        return groupingAttributeDefinitions;
    }

    /**
     * <p>
     * The timestamp when the grouping attribute definitions were last updated. Expressed as the number of milliseconds
     * since January 1, 1970, 00:00:00 UTC.
     * </p>
     * 
     * @return The timestamp when the grouping attribute definitions were last updated. Expressed as the number of
     *         milliseconds since January 1, 1970, 00:00:00 UTC.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The token to use for retrieving the next page of results. This value is present only if there are more results
     * available than were returned in the current response.
     * </p>
     * 
     * @return The token to use for retrieving the next page of results. This value is present only if there are more
     *         results available than were returned in the current response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupingAttributeDefinitions() ? groupingAttributeDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupingAttributeDefinitionsResponse)) {
            return false;
        }
        ListGroupingAttributeDefinitionsResponse other = (ListGroupingAttributeDefinitionsResponse) obj;
        return hasGroupingAttributeDefinitions() == other.hasGroupingAttributeDefinitions()
                && Objects.equals(groupingAttributeDefinitions(), other.groupingAttributeDefinitions())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGroupingAttributeDefinitionsResponse")
                .add("GroupingAttributeDefinitions", hasGroupingAttributeDefinitions() ? groupingAttributeDefinitions() : null)
                .add("UpdatedAt", updatedAt()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupingAttributeDefinitions":
            return Optional.ofNullable(clazz.cast(groupingAttributeDefinitions()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupingAttributeDefinitions", GROUPING_ATTRIBUTE_DEFINITIONS_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGroupingAttributeDefinitionsResponse, T> g) {
        return obj -> g.apply((ListGroupingAttributeDefinitionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationSignalsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListGroupingAttributeDefinitionsResponse> {
        /**
         * <p>
         * An array of available grouping attribute definitions that can be used to create grouping configurations.
         * </p>
         * 
         * @param groupingAttributeDefinitions
         *        An array of available grouping attribute definitions that can be used to create grouping
         *        configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingAttributeDefinitions(Collection<GroupingAttributeDefinition> groupingAttributeDefinitions);

        /**
         * <p>
         * An array of available grouping attribute definitions that can be used to create grouping configurations.
         * </p>
         * 
         * @param groupingAttributeDefinitions
         *        An array of available grouping attribute definitions that can be used to create grouping
         *        configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingAttributeDefinitions(GroupingAttributeDefinition... groupingAttributeDefinitions);

        /**
         * <p>
         * An array of available grouping attribute definitions that can be used to create grouping configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.GroupingAttributeDefinition.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.GroupingAttributeDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.GroupingAttributeDefinition.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #groupingAttributeDefinitions(List<GroupingAttributeDefinition>)}.
         * 
         * @param groupingAttributeDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.GroupingAttributeDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupingAttributeDefinitions(java.util.Collection<GroupingAttributeDefinition>)
         */
        Builder groupingAttributeDefinitions(Consumer<GroupingAttributeDefinition.Builder>... groupingAttributeDefinitions);

        /**
         * <p>
         * The timestamp when the grouping attribute definitions were last updated. Expressed as the number of
         * milliseconds since January 1, 1970, 00:00:00 UTC.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the grouping attribute definitions were last updated. Expressed as the number of
         *        milliseconds since January 1, 1970, 00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The token to use for retrieving the next page of results. This value is present only if there are more
         * results available than were returned in the current response.
         * </p>
         * 
         * @param nextToken
         *        The token to use for retrieving the next page of results. This value is present only if there are more
         *        results available than were returned in the current response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationSignalsResponse.BuilderImpl implements Builder {
        private List<GroupingAttributeDefinition> groupingAttributeDefinitions = DefaultSdkAutoConstructList.getInstance();

        private Instant updatedAt;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupingAttributeDefinitionsResponse model) {
            super(model);
            groupingAttributeDefinitions(model.groupingAttributeDefinitions);
            updatedAt(model.updatedAt);
            nextToken(model.nextToken);
        }

        public final List<GroupingAttributeDefinition.Builder> getGroupingAttributeDefinitions() {
            List<GroupingAttributeDefinition.Builder> result = GroupingAttributeDefinitionsCopier
                    .copyToBuilder(this.groupingAttributeDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupingAttributeDefinitions(
                Collection<GroupingAttributeDefinition.BuilderImpl> groupingAttributeDefinitions) {
            this.groupingAttributeDefinitions = GroupingAttributeDefinitionsCopier.copyFromBuilder(groupingAttributeDefinitions);
        }

        @Override
        public final Builder groupingAttributeDefinitions(Collection<GroupingAttributeDefinition> groupingAttributeDefinitions) {
            this.groupingAttributeDefinitions = GroupingAttributeDefinitionsCopier.copy(groupingAttributeDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingAttributeDefinitions(GroupingAttributeDefinition... groupingAttributeDefinitions) {
            groupingAttributeDefinitions(Arrays.asList(groupingAttributeDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingAttributeDefinitions(
                Consumer<GroupingAttributeDefinition.Builder>... groupingAttributeDefinitions) {
            groupingAttributeDefinitions(Stream.of(groupingAttributeDefinitions)
                    .map(c -> GroupingAttributeDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListGroupingAttributeDefinitionsResponse build() {
            return new ListGroupingAttributeDefinitionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
