/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Use this structure to specify the information for the metric that a period-based SLO will monitor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceLevelIndicatorMetricConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceLevelIndicatorMetricConfig.Builder, ServiceLevelIndicatorMetricConfig> {
    private static final SdkField<Map<String, String>> KEY_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("KeyAttributes")
            .getter(getter(ServiceLevelIndicatorMetricConfig::keyAttributes))
            .setter(setter(Builder::keyAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationName").getter(getter(ServiceLevelIndicatorMetricConfig::operationName))
            .setter(setter(Builder::operationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationName").build()).build();

    private static final SdkField<String> METRIC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricType").getter(getter(ServiceLevelIndicatorMetricConfig::metricTypeAsString))
            .setter(setter(Builder::metricType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricType").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(ServiceLevelIndicatorMetricConfig::metricName))
            .setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<String> STATISTIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Statistic").getter(getter(ServiceLevelIndicatorMetricConfig::statistic))
            .setter(setter(Builder::statistic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistic").build()).build();

    private static final SdkField<Integer> PERIOD_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PeriodSeconds").getter(getter(ServiceLevelIndicatorMetricConfig::periodSeconds))
            .setter(setter(Builder::periodSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodSeconds").build()).build();

    private static final SdkField<List<MetricDataQuery>> METRIC_DATA_QUERIES_FIELD = SdkField
            .<List<MetricDataQuery>> builder(MarshallingType.LIST)
            .memberName("MetricDataQueries")
            .getter(getter(ServiceLevelIndicatorMetricConfig::metricDataQueries))
            .setter(setter(Builder::metricDataQueries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDataQueries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricDataQuery> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDataQuery::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DependencyConfig> DEPENDENCY_CONFIG_FIELD = SdkField
            .<DependencyConfig> builder(MarshallingType.SDK_POJO).memberName("DependencyConfig")
            .getter(getter(ServiceLevelIndicatorMetricConfig::dependencyConfig)).setter(setter(Builder::dependencyConfig))
            .constructor(DependencyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependencyConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ATTRIBUTES_FIELD,
            OPERATION_NAME_FIELD, METRIC_TYPE_FIELD, METRIC_NAME_FIELD, STATISTIC_FIELD, PERIOD_SECONDS_FIELD,
            METRIC_DATA_QUERIES_FIELD, DEPENDENCY_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, String> keyAttributes;

    private final String operationName;

    private final String metricType;

    private final String metricName;

    private final String statistic;

    private final Integer periodSeconds;

    private final List<MetricDataQuery> metricDataQueries;

    private final DependencyConfig dependencyConfig;

    private ServiceLevelIndicatorMetricConfig(BuilderImpl builder) {
        this.keyAttributes = builder.keyAttributes;
        this.operationName = builder.operationName;
        this.metricType = builder.metricType;
        this.metricName = builder.metricName;
        this.statistic = builder.statistic;
        this.periodSeconds = builder.periodSeconds;
        this.metricDataQueries = builder.metricDataQueries;
        this.dependencyConfig = builder.dependencyConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeyAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKeyAttributes() {
        return keyAttributes != null && !(keyAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * If this SLO is related to a metric collected by Application Signals, you must use this field to specify which
     * service the SLO metric is related to. To do so, you must specify at least the <code>Type</code>,
     * <code>Name</code>, and <code>Environment</code> attributes.
     * </p>
     * <p>
     * This is a string-to-string map. It can include the following fields.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Type</code> designates the type of object this is.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the
     * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field
     * is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the
     * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeyAttributes} method.
     * </p>
     * 
     * @return If this SLO is related to a metric collected by Application Signals, you must use this field to specify
     *         which service the SLO metric is related to. To do so, you must specify at least the <code>Type</code>,
     *         <code>Name</code>, and <code>Environment</code> attributes.</p>
     *         <p>
     *         This is a string-to-string map. It can include the following fields.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Type</code> designates the type of object this is.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of
     *         the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Name</code> specifies the name of the object. This is used only if the value of the
     *         <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value
     *         of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
     *         </p>
     *         </li>
     */
    public final Map<String, String> keyAttributes() {
        return keyAttributes;
    }

    /**
     * <p>
     * If the SLO is to monitor a specific operation of the service, use this field to specify the name of that
     * operation.
     * </p>
     * 
     * @return If the SLO is to monitor a specific operation of the service, use this field to specify the name of that
     *         operation.
     */
    public final String operationName() {
        return operationName;
    }

    /**
     * <p>
     * If the SLO is to monitor either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that Application
     * Signals collects, use this field to specify which of those metrics is used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricType} will
     * return {@link ServiceLevelIndicatorMetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #metricTypeAsString}.
     * </p>
     * 
     * @return If the SLO is to monitor either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that
     *         Application Signals collects, use this field to specify which of those metrics is used.
     * @see ServiceLevelIndicatorMetricType
     */
    public final ServiceLevelIndicatorMetricType metricType() {
        return ServiceLevelIndicatorMetricType.fromValue(metricType);
    }

    /**
     * <p>
     * If the SLO is to monitor either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that Application
     * Signals collects, use this field to specify which of those metrics is used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricType} will
     * return {@link ServiceLevelIndicatorMetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #metricTypeAsString}.
     * </p>
     * 
     * @return If the SLO is to monitor either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that
     *         Application Signals collects, use this field to specify which of those metrics is used.
     * @see ServiceLevelIndicatorMetricType
     */
    public final String metricTypeAsString() {
        return metricType;
    }

    /**
     * <p>
     * The name of the CloudWatch metric used as a service level indicator (SLI) for measuring service performance.
     * </p>
     * 
     * @return The name of the CloudWatch metric used as a service level indicator (SLI) for measuring service
     *         performance.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The statistic to use for comparison to the threshold. It can be any CloudWatch statistic or extended statistic.
     * For more information about statistics, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html">CloudWatch
     * statistics definitions</a>.
     * </p>
     * 
     * @return The statistic to use for comparison to the threshold. It can be any CloudWatch statistic or extended
     *         statistic. For more information about statistics, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html"
     *         >CloudWatch statistics definitions</a>.
     */
    public final String statistic() {
        return statistic;
    }

    /**
     * <p>
     * The number of seconds to use as the period for SLO evaluation. Your application's performance is compared to the
     * SLI during each period. For each period, the application is determined to have either achieved or not achieved
     * the necessary performance.
     * </p>
     * 
     * @return The number of seconds to use as the period for SLO evaluation. Your application's performance is compared
     *         to the SLI during each period. For each period, the application is determined to have either achieved or
     *         not achieved the necessary performance.
     */
    public final Integer periodSeconds() {
        return periodSeconds;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricDataQueries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricDataQueries() {
        return metricDataQueries != null && !(metricDataQueries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, use this structure
     * to specify that metric or expression.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricDataQueries} method.
     * </p>
     * 
     * @return If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, use this
     *         structure to specify that metric or expression.
     */
    public final List<MetricDataQuery> metricDataQueries() {
        return metricDataQueries;
    }

    /**
     * <p>
     * Identifies the dependency using the <code>DependencyKeyAttributes</code> and <code>DependencyOperationName</code>
     * .
     * </p>
     * 
     * @return Identifies the dependency using the <code>DependencyKeyAttributes</code> and
     *         <code>DependencyOperationName</code>.
     */
    public final DependencyConfig dependencyConfig() {
        return dependencyConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasKeyAttributes() ? keyAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(operationName());
        hashCode = 31 * hashCode + Objects.hashCode(metricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(statistic());
        hashCode = 31 * hashCode + Objects.hashCode(periodSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricDataQueries() ? metricDataQueries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dependencyConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceLevelIndicatorMetricConfig)) {
            return false;
        }
        ServiceLevelIndicatorMetricConfig other = (ServiceLevelIndicatorMetricConfig) obj;
        return hasKeyAttributes() == other.hasKeyAttributes() && Objects.equals(keyAttributes(), other.keyAttributes())
                && Objects.equals(operationName(), other.operationName())
                && Objects.equals(metricTypeAsString(), other.metricTypeAsString())
                && Objects.equals(metricName(), other.metricName()) && Objects.equals(statistic(), other.statistic())
                && Objects.equals(periodSeconds(), other.periodSeconds())
                && hasMetricDataQueries() == other.hasMetricDataQueries()
                && Objects.equals(metricDataQueries(), other.metricDataQueries())
                && Objects.equals(dependencyConfig(), other.dependencyConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceLevelIndicatorMetricConfig")
                .add("KeyAttributes", hasKeyAttributes() ? keyAttributes() : null).add("OperationName", operationName())
                .add("MetricType", metricTypeAsString()).add("MetricName", metricName()).add("Statistic", statistic())
                .add("PeriodSeconds", periodSeconds())
                .add("MetricDataQueries", hasMetricDataQueries() ? metricDataQueries() : null)
                .add("DependencyConfig", dependencyConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyAttributes":
            return Optional.ofNullable(clazz.cast(keyAttributes()));
        case "OperationName":
            return Optional.ofNullable(clazz.cast(operationName()));
        case "MetricType":
            return Optional.ofNullable(clazz.cast(metricTypeAsString()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "Statistic":
            return Optional.ofNullable(clazz.cast(statistic()));
        case "PeriodSeconds":
            return Optional.ofNullable(clazz.cast(periodSeconds()));
        case "MetricDataQueries":
            return Optional.ofNullable(clazz.cast(metricDataQueries()));
        case "DependencyConfig":
            return Optional.ofNullable(clazz.cast(dependencyConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyAttributes", KEY_ATTRIBUTES_FIELD);
        map.put("OperationName", OPERATION_NAME_FIELD);
        map.put("MetricType", METRIC_TYPE_FIELD);
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("Statistic", STATISTIC_FIELD);
        map.put("PeriodSeconds", PERIOD_SECONDS_FIELD);
        map.put("MetricDataQueries", METRIC_DATA_QUERIES_FIELD);
        map.put("DependencyConfig", DEPENDENCY_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceLevelIndicatorMetricConfig, T> g) {
        return obj -> g.apply((ServiceLevelIndicatorMetricConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceLevelIndicatorMetricConfig> {
        /**
         * <p>
         * If this SLO is related to a metric collected by Application Signals, you must use this field to specify which
         * service the SLO metric is related to. To do so, you must specify at least the <code>Type</code>,
         * <code>Name</code>, and <code>Environment</code> attributes.
         * </p>
         * <p>
         * This is a string-to-string map. It can include the following fields.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Type</code> designates the type of object this is.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the
         * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code>
         * field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of
         * the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
         * </p>
         * </li>
         * </ul>
         * 
         * @param keyAttributes
         *        If this SLO is related to a metric collected by Application Signals, you must use this field to
         *        specify which service the SLO metric is related to. To do so, you must specify at least the
         *        <code>Type</code>, <code>Name</code>, and <code>Environment</code> attributes.</p>
         *        <p>
         *        This is a string-to-string map. It can include the following fields.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Type</code> designates the type of object this is.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ResourceType</code> specifies the type of the resource. This field is used only when the value
         *        of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Name</code> specifies the name of the object. This is used only if the value of the
         *        <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or
         *        <code>AWS::Service</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Identifier</code> identifies the resource objects of this resource. This is used only if the
         *        value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyAttributes(Map<String, String> keyAttributes);

        /**
         * <p>
         * If the SLO is to monitor a specific operation of the service, use this field to specify the name of that
         * operation.
         * </p>
         * 
         * @param operationName
         *        If the SLO is to monitor a specific operation of the service, use this field to specify the name of
         *        that operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationName(String operationName);

        /**
         * <p>
         * If the SLO is to monitor either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that Application
         * Signals collects, use this field to specify which of those metrics is used.
         * </p>
         * 
         * @param metricType
         *        If the SLO is to monitor either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that
         *        Application Signals collects, use this field to specify which of those metrics is used.
         * @see ServiceLevelIndicatorMetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceLevelIndicatorMetricType
         */
        Builder metricType(String metricType);

        /**
         * <p>
         * If the SLO is to monitor either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that Application
         * Signals collects, use this field to specify which of those metrics is used.
         * </p>
         * 
         * @param metricType
         *        If the SLO is to monitor either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that
         *        Application Signals collects, use this field to specify which of those metrics is used.
         * @see ServiceLevelIndicatorMetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceLevelIndicatorMetricType
         */
        Builder metricType(ServiceLevelIndicatorMetricType metricType);

        /**
         * <p>
         * The name of the CloudWatch metric used as a service level indicator (SLI) for measuring service performance.
         * </p>
         * 
         * @param metricName
         *        The name of the CloudWatch metric used as a service level indicator (SLI) for measuring service
         *        performance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The statistic to use for comparison to the threshold. It can be any CloudWatch statistic or extended
         * statistic. For more information about statistics, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html">CloudWatch
         * statistics definitions</a>.
         * </p>
         * 
         * @param statistic
         *        The statistic to use for comparison to the threshold. It can be any CloudWatch statistic or extended
         *        statistic. For more information about statistics, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html"
         *        >CloudWatch statistics definitions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistic(String statistic);

        /**
         * <p>
         * The number of seconds to use as the period for SLO evaluation. Your application's performance is compared to
         * the SLI during each period. For each period, the application is determined to have either achieved or not
         * achieved the necessary performance.
         * </p>
         * 
         * @param periodSeconds
         *        The number of seconds to use as the period for SLO evaluation. Your application's performance is
         *        compared to the SLI during each period. For each period, the application is determined to have either
         *        achieved or not achieved the necessary performance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodSeconds(Integer periodSeconds);

        /**
         * <p>
         * If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, use this
         * structure to specify that metric or expression.
         * </p>
         * 
         * @param metricDataQueries
         *        If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, use
         *        this structure to specify that metric or expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDataQueries(Collection<MetricDataQuery> metricDataQueries);

        /**
         * <p>
         * If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, use this
         * structure to specify that metric or expression.
         * </p>
         * 
         * @param metricDataQueries
         *        If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, use
         *        this structure to specify that metric or expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDataQueries(MetricDataQuery... metricDataQueries);

        /**
         * <p>
         * If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, use this
         * structure to specify that metric or expression.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery.Builder#build()} is called
         * immediately and its result is passed to {@link #metricDataQueries(List<MetricDataQuery>)}.
         * 
         * @param metricDataQueries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricDataQueries(java.util.Collection<MetricDataQuery>)
         */
        Builder metricDataQueries(Consumer<MetricDataQuery.Builder>... metricDataQueries);

        /**
         * <p>
         * Identifies the dependency using the <code>DependencyKeyAttributes</code> and
         * <code>DependencyOperationName</code>.
         * </p>
         * 
         * @param dependencyConfig
         *        Identifies the dependency using the <code>DependencyKeyAttributes</code> and
         *        <code>DependencyOperationName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencyConfig(DependencyConfig dependencyConfig);

        /**
         * <p>
         * Identifies the dependency using the <code>DependencyKeyAttributes</code> and
         * <code>DependencyOperationName</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DependencyConfig.Builder} avoiding the
         * need to create one manually via {@link DependencyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DependencyConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #dependencyConfig(DependencyConfig)}.
         * 
         * @param dependencyConfig
         *        a consumer that will call methods on {@link DependencyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dependencyConfig(DependencyConfig)
         */
        default Builder dependencyConfig(Consumer<DependencyConfig.Builder> dependencyConfig) {
            return dependencyConfig(DependencyConfig.builder().applyMutation(dependencyConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> keyAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String operationName;

        private String metricType;

        private String metricName;

        private String statistic;

        private Integer periodSeconds;

        private List<MetricDataQuery> metricDataQueries = DefaultSdkAutoConstructList.getInstance();

        private DependencyConfig dependencyConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLevelIndicatorMetricConfig model) {
            keyAttributes(model.keyAttributes);
            operationName(model.operationName);
            metricType(model.metricType);
            metricName(model.metricName);
            statistic(model.statistic);
            periodSeconds(model.periodSeconds);
            metricDataQueries(model.metricDataQueries);
            dependencyConfig(model.dependencyConfig);
        }

        public final Map<String, String> getKeyAttributes() {
            if (keyAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return keyAttributes;
        }

        public final void setKeyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
        }

        @Override
        public final Builder keyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
            return this;
        }

        public final String getOperationName() {
            return operationName;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final String getMetricType() {
            return metricType;
        }

        public final void setMetricType(String metricType) {
            this.metricType = metricType;
        }

        @Override
        public final Builder metricType(String metricType) {
            this.metricType = metricType;
            return this;
        }

        @Override
        public final Builder metricType(ServiceLevelIndicatorMetricType metricType) {
            this.metricType(metricType == null ? null : metricType.toString());
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getStatistic() {
            return statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        public final Integer getPeriodSeconds() {
            return periodSeconds;
        }

        public final void setPeriodSeconds(Integer periodSeconds) {
            this.periodSeconds = periodSeconds;
        }

        @Override
        public final Builder periodSeconds(Integer periodSeconds) {
            this.periodSeconds = periodSeconds;
            return this;
        }

        public final List<MetricDataQuery.Builder> getMetricDataQueries() {
            List<MetricDataQuery.Builder> result = MetricDataQueriesCopier.copyToBuilder(this.metricDataQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDataQueries(Collection<MetricDataQuery.BuilderImpl> metricDataQueries) {
            this.metricDataQueries = MetricDataQueriesCopier.copyFromBuilder(metricDataQueries);
        }

        @Override
        public final Builder metricDataQueries(Collection<MetricDataQuery> metricDataQueries) {
            this.metricDataQueries = MetricDataQueriesCopier.copy(metricDataQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataQueries(MetricDataQuery... metricDataQueries) {
            metricDataQueries(Arrays.asList(metricDataQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataQueries(Consumer<MetricDataQuery.Builder>... metricDataQueries) {
            metricDataQueries(Stream.of(metricDataQueries).map(c -> MetricDataQuery.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final DependencyConfig.Builder getDependencyConfig() {
            return dependencyConfig != null ? dependencyConfig.toBuilder() : null;
        }

        public final void setDependencyConfig(DependencyConfig.BuilderImpl dependencyConfig) {
            this.dependencyConfig = dependencyConfig != null ? dependencyConfig.build() : null;
        }

        @Override
        public final Builder dependencyConfig(DependencyConfig dependencyConfig) {
            this.dependencyConfig = dependencyConfig;
            return this;
        }

        @Override
        public ServiceLevelIndicatorMetricConfig build() {
            return new ServiceLevelIndicatorMetricConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
