/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a Service Level Objective (SLO) entity that can be audited for compliance and performance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceLevelObjectiveEntity implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceLevelObjectiveEntity.Builder, ServiceLevelObjectiveEntity> {
    private static final SdkField<String> SLO_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SloName").getter(getter(ServiceLevelObjectiveEntity::sloName)).setter(setter(Builder::sloName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SloName").build()).build();

    private static final SdkField<String> SLO_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SloArn")
            .getter(getter(ServiceLevelObjectiveEntity::sloArn)).setter(setter(Builder::sloArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SloArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SLO_NAME_FIELD, SLO_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sloName;

    private final String sloArn;

    private ServiceLevelObjectiveEntity(BuilderImpl builder) {
        this.sloName = builder.sloName;
        this.sloArn = builder.sloArn;
    }

    /**
     * <p>
     * The name of the Service Level Objective.
     * </p>
     * 
     * @return The name of the Service Level Objective.
     */
    public final String sloName() {
        return sloName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Service Level Objective.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Service Level Objective.
     */
    public final String sloArn() {
        return sloArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sloName());
        hashCode = 31 * hashCode + Objects.hashCode(sloArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceLevelObjectiveEntity)) {
            return false;
        }
        ServiceLevelObjectiveEntity other = (ServiceLevelObjectiveEntity) obj;
        return Objects.equals(sloName(), other.sloName()) && Objects.equals(sloArn(), other.sloArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceLevelObjectiveEntity").add("SloName", sloName()).add("SloArn", sloArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SloName":
            return Optional.ofNullable(clazz.cast(sloName()));
        case "SloArn":
            return Optional.ofNullable(clazz.cast(sloArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SloName", SLO_NAME_FIELD);
        map.put("SloArn", SLO_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceLevelObjectiveEntity, T> g) {
        return obj -> g.apply((ServiceLevelObjectiveEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceLevelObjectiveEntity> {
        /**
         * <p>
         * The name of the Service Level Objective.
         * </p>
         * 
         * @param sloName
         *        The name of the Service Level Objective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sloName(String sloName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Service Level Objective.
         * </p>
         * 
         * @param sloArn
         *        The Amazon Resource Name (ARN) of the Service Level Objective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sloArn(String sloArn);
    }

    static final class BuilderImpl implements Builder {
        private String sloName;

        private String sloArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLevelObjectiveEntity model) {
            sloName(model.sloName);
            sloArn(model.sloArn);
        }

        public final String getSloName() {
            return sloName;
        }

        public final void setSloName(String sloName) {
            this.sloName = sloName;
        }

        @Override
        public final Builder sloName(String sloName) {
            this.sloName = sloName;
            return this;
        }

        public final String getSloArn() {
            return sloArn;
        }

        public final void setSloArn(String sloArn) {
            this.sloArn = sloArn;
        }

        @Override
        public final Builder sloArn(String sloArn) {
            this.sloArn = sloArn;
            return this;
        }

        @Override
        public ServiceLevelObjectiveEntity build() {
            return new ServiceLevelObjectiveEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
