/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServiceLevelObjectiveRequest extends ApplicationSignalsRequest implements
        ToCopyableBuilder<CreateServiceLevelObjectiveRequest.Builder, CreateServiceLevelObjectiveRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateServiceLevelObjectiveRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateServiceLevelObjectiveRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ServiceLevelIndicatorConfig> SLI_CONFIG_FIELD = SdkField
            .<ServiceLevelIndicatorConfig> builder(MarshallingType.SDK_POJO).memberName("SliConfig")
            .getter(getter(CreateServiceLevelObjectiveRequest::sliConfig)).setter(setter(Builder::sliConfig))
            .constructor(ServiceLevelIndicatorConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SliConfig").build()).build();

    private static final SdkField<RequestBasedServiceLevelIndicatorConfig> REQUEST_BASED_SLI_CONFIG_FIELD = SdkField
            .<RequestBasedServiceLevelIndicatorConfig> builder(MarshallingType.SDK_POJO).memberName("RequestBasedSliConfig")
            .getter(getter(CreateServiceLevelObjectiveRequest::requestBasedSliConfig))
            .setter(setter(Builder::requestBasedSliConfig)).constructor(RequestBasedServiceLevelIndicatorConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestBasedSliConfig").build())
            .build();

    private static final SdkField<Goal> GOAL_FIELD = SdkField.<Goal> builder(MarshallingType.SDK_POJO).memberName("Goal")
            .getter(getter(CreateServiceLevelObjectiveRequest::goal)).setter(setter(Builder::goal)).constructor(Goal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Goal").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateServiceLevelObjectiveRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BurnRateConfiguration>> BURN_RATE_CONFIGURATIONS_FIELD = SdkField
            .<List<BurnRateConfiguration>> builder(MarshallingType.LIST)
            .memberName("BurnRateConfigurations")
            .getter(getter(CreateServiceLevelObjectiveRequest::burnRateConfigurations))
            .setter(setter(Builder::burnRateConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BurnRateConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BurnRateConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(BurnRateConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            SLI_CONFIG_FIELD, REQUEST_BASED_SLI_CONFIG_FIELD, GOAL_FIELD, TAGS_FIELD, BURN_RATE_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final ServiceLevelIndicatorConfig sliConfig;

    private final RequestBasedServiceLevelIndicatorConfig requestBasedSliConfig;

    private final Goal goal;

    private final List<Tag> tags;

    private final List<BurnRateConfiguration> burnRateConfigurations;

    private CreateServiceLevelObjectiveRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.sliConfig = builder.sliConfig;
        this.requestBasedSliConfig = builder.requestBasedSliConfig;
        this.goal = builder.goal;
        this.tags = builder.tags;
        this.burnRateConfigurations = builder.burnRateConfigurations;
    }

    /**
     * <p>
     * A name for this SLO.
     * </p>
     * 
     * @return A name for this SLO.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An optional description for this SLO.
     * </p>
     * 
     * @return An optional description for this SLO.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * If this SLO is a period-based SLO, this structure defines the information about what performance metric this SLO
     * will monitor.
     * </p>
     * <p>
     * You can't specify both <code>RequestBasedSliConfig</code> and <code>SliConfig</code> in the same operation.
     * </p>
     * 
     * @return If this SLO is a period-based SLO, this structure defines the information about what performance metric
     *         this SLO will monitor.</p>
     *         <p>
     *         You can't specify both <code>RequestBasedSliConfig</code> and <code>SliConfig</code> in the same
     *         operation.
     */
    public final ServiceLevelIndicatorConfig sliConfig() {
        return sliConfig;
    }

    /**
     * <p>
     * If this SLO is a request-based SLO, this structure defines the information about what performance metric this SLO
     * will monitor.
     * </p>
     * <p>
     * You can't specify both <code>RequestBasedSliConfig</code> and <code>SliConfig</code> in the same operation.
     * </p>
     * 
     * @return If this SLO is a request-based SLO, this structure defines the information about what performance metric
     *         this SLO will monitor.</p>
     *         <p>
     *         You can't specify both <code>RequestBasedSliConfig</code> and <code>SliConfig</code> in the same
     *         operation.
     */
    public final RequestBasedServiceLevelIndicatorConfig requestBasedSliConfig() {
        return requestBasedSliConfig;
    }

    /**
     * <p>
     * This structure contains the attributes that determine the goal of the SLO.
     * </p>
     * 
     * @return This structure contains the attributes that determine the goal of the SLO.
     */
    public final Goal goal() {
        return goal;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs to associate with the SLO. You can associate as many as 50 tags with an SLO. To be able
     * to associate tags with the SLO when you create the SLO, you must have the <code>cloudwatch:TagResource</code>
     * permission.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
     * granting a user permission to access or change only resources with certain tag values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs to associate with the SLO. You can associate as many as 50 tags with an SLO. To
     *         be able to associate tags with the SLO when you create the SLO, you must have the
     *         <code>cloudwatch:TagResource</code> permission.</p>
     *         <p>
     *         Tags can help you organize and categorize your resources. You can also use them to scope user permissions
     *         by granting a user permission to access or change only resources with certain tag values.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the BurnRateConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBurnRateConfigurations() {
        return burnRateConfigurations != null && !(burnRateConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Use this array to create <i>burn rates</i> for this SLO. Each burn rate is a metric that indicates how fast the
     * service is consuming the error budget, relative to the attainment goal of the SLO.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBurnRateConfigurations} method.
     * </p>
     * 
     * @return Use this array to create <i>burn rates</i> for this SLO. Each burn rate is a metric that indicates how
     *         fast the service is consuming the error budget, relative to the attainment goal of the SLO.
     */
    public final List<BurnRateConfiguration> burnRateConfigurations() {
        return burnRateConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(sliConfig());
        hashCode = 31 * hashCode + Objects.hashCode(requestBasedSliConfig());
        hashCode = 31 * hashCode + Objects.hashCode(goal());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBurnRateConfigurations() ? burnRateConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceLevelObjectiveRequest)) {
            return false;
        }
        CreateServiceLevelObjectiveRequest other = (CreateServiceLevelObjectiveRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(sliConfig(), other.sliConfig())
                && Objects.equals(requestBasedSliConfig(), other.requestBasedSliConfig()) && Objects.equals(goal(), other.goal())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && hasBurnRateConfigurations() == other.hasBurnRateConfigurations()
                && Objects.equals(burnRateConfigurations(), other.burnRateConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateServiceLevelObjectiveRequest").add("Name", name()).add("Description", description())
                .add("SliConfig", sliConfig()).add("RequestBasedSliConfig", requestBasedSliConfig()).add("Goal", goal())
                .add("Tags", hasTags() ? tags() : null)
                .add("BurnRateConfigurations", hasBurnRateConfigurations() ? burnRateConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SliConfig":
            return Optional.ofNullable(clazz.cast(sliConfig()));
        case "RequestBasedSliConfig":
            return Optional.ofNullable(clazz.cast(requestBasedSliConfig()));
        case "Goal":
            return Optional.ofNullable(clazz.cast(goal()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "BurnRateConfigurations":
            return Optional.ofNullable(clazz.cast(burnRateConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("SliConfig", SLI_CONFIG_FIELD);
        map.put("RequestBasedSliConfig", REQUEST_BASED_SLI_CONFIG_FIELD);
        map.put("Goal", GOAL_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("BurnRateConfigurations", BURN_RATE_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceLevelObjectiveRequest, T> g) {
        return obj -> g.apply((CreateServiceLevelObjectiveRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationSignalsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateServiceLevelObjectiveRequest> {
        /**
         * <p>
         * A name for this SLO.
         * </p>
         * 
         * @param name
         *        A name for this SLO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An optional description for this SLO.
         * </p>
         * 
         * @param description
         *        An optional description for this SLO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * If this SLO is a period-based SLO, this structure defines the information about what performance metric this
         * SLO will monitor.
         * </p>
         * <p>
         * You can't specify both <code>RequestBasedSliConfig</code> and <code>SliConfig</code> in the same operation.
         * </p>
         * 
         * @param sliConfig
         *        If this SLO is a period-based SLO, this structure defines the information about what performance
         *        metric this SLO will monitor.</p>
         *        <p>
         *        You can't specify both <code>RequestBasedSliConfig</code> and <code>SliConfig</code> in the same
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sliConfig(ServiceLevelIndicatorConfig sliConfig);

        /**
         * <p>
         * If this SLO is a period-based SLO, this structure defines the information about what performance metric this
         * SLO will monitor.
         * </p>
         * <p>
         * You can't specify both <code>RequestBasedSliConfig</code> and <code>SliConfig</code> in the same operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceLevelIndicatorConfig.Builder}
         * avoiding the need to create one manually via {@link ServiceLevelIndicatorConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceLevelIndicatorConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #sliConfig(ServiceLevelIndicatorConfig)}.
         * 
         * @param sliConfig
         *        a consumer that will call methods on {@link ServiceLevelIndicatorConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sliConfig(ServiceLevelIndicatorConfig)
         */
        default Builder sliConfig(Consumer<ServiceLevelIndicatorConfig.Builder> sliConfig) {
            return sliConfig(ServiceLevelIndicatorConfig.builder().applyMutation(sliConfig).build());
        }

        /**
         * <p>
         * If this SLO is a request-based SLO, this structure defines the information about what performance metric this
         * SLO will monitor.
         * </p>
         * <p>
         * You can't specify both <code>RequestBasedSliConfig</code> and <code>SliConfig</code> in the same operation.
         * </p>
         * 
         * @param requestBasedSliConfig
         *        If this SLO is a request-based SLO, this structure defines the information about what performance
         *        metric this SLO will monitor.</p>
         *        <p>
         *        You can't specify both <code>RequestBasedSliConfig</code> and <code>SliConfig</code> in the same
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestBasedSliConfig(RequestBasedServiceLevelIndicatorConfig requestBasedSliConfig);

        /**
         * <p>
         * If this SLO is a request-based SLO, this structure defines the information about what performance metric this
         * SLO will monitor.
         * </p>
         * <p>
         * You can't specify both <code>RequestBasedSliConfig</code> and <code>SliConfig</code> in the same operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RequestBasedServiceLevelIndicatorConfig.Builder} avoiding the need to create one manually via
         * {@link RequestBasedServiceLevelIndicatorConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RequestBasedServiceLevelIndicatorConfig.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #requestBasedSliConfig(RequestBasedServiceLevelIndicatorConfig)}.
         * 
         * @param requestBasedSliConfig
         *        a consumer that will call methods on {@link RequestBasedServiceLevelIndicatorConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestBasedSliConfig(RequestBasedServiceLevelIndicatorConfig)
         */
        default Builder requestBasedSliConfig(Consumer<RequestBasedServiceLevelIndicatorConfig.Builder> requestBasedSliConfig) {
            return requestBasedSliConfig(RequestBasedServiceLevelIndicatorConfig.builder().applyMutation(requestBasedSliConfig)
                    .build());
        }

        /**
         * <p>
         * This structure contains the attributes that determine the goal of the SLO.
         * </p>
         * 
         * @param goal
         *        This structure contains the attributes that determine the goal of the SLO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder goal(Goal goal);

        /**
         * <p>
         * This structure contains the attributes that determine the goal of the SLO.
         * </p>
         * This is a convenience method that creates an instance of the {@link Goal.Builder} avoiding the need to create
         * one manually via {@link Goal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Goal.Builder#build()} is called immediately and its result is
         * passed to {@link #goal(Goal)}.
         * 
         * @param goal
         *        a consumer that will call methods on {@link Goal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #goal(Goal)
         */
        default Builder goal(Consumer<Goal.Builder> goal) {
            return goal(Goal.builder().applyMutation(goal).build());
        }

        /**
         * <p>
         * A list of key-value pairs to associate with the SLO. You can associate as many as 50 tags with an SLO. To be
         * able to associate tags with the SLO when you create the SLO, you must have the
         * <code>cloudwatch:TagResource</code> permission.
         * </p>
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
         * granting a user permission to access or change only resources with certain tag values.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs to associate with the SLO. You can associate as many as 50 tags with an SLO.
         *        To be able to associate tags with the SLO when you create the SLO, you must have the
         *        <code>cloudwatch:TagResource</code> permission.</p>
         *        <p>
         *        Tags can help you organize and categorize your resources. You can also use them to scope user
         *        permissions by granting a user permission to access or change only resources with certain tag values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs to associate with the SLO. You can associate as many as 50 tags with an SLO. To be
         * able to associate tags with the SLO when you create the SLO, you must have the
         * <code>cloudwatch:TagResource</code> permission.
         * </p>
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
         * granting a user permission to access or change only resources with certain tag values.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs to associate with the SLO. You can associate as many as 50 tags with an SLO.
         *        To be able to associate tags with the SLO when you create the SLO, you must have the
         *        <code>cloudwatch:TagResource</code> permission.</p>
         *        <p>
         *        Tags can help you organize and categorize your resources. You can also use them to scope user
         *        permissions by granting a user permission to access or change only resources with certain tag values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs to associate with the SLO. You can associate as many as 50 tags with an SLO. To be
         * able to associate tags with the SLO when you create the SLO, you must have the
         * <code>cloudwatch:TagResource</code> permission.
         * </p>
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
         * granting a user permission to access or change only resources with certain tag values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.applicationsignals.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.Tag.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Use this array to create <i>burn rates</i> for this SLO. Each burn rate is a metric that indicates how fast
         * the service is consuming the error budget, relative to the attainment goal of the SLO.
         * </p>
         * 
         * @param burnRateConfigurations
         *        Use this array to create <i>burn rates</i> for this SLO. Each burn rate is a metric that indicates how
         *        fast the service is consuming the error budget, relative to the attainment goal of the SLO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder burnRateConfigurations(Collection<BurnRateConfiguration> burnRateConfigurations);

        /**
         * <p>
         * Use this array to create <i>burn rates</i> for this SLO. Each burn rate is a metric that indicates how fast
         * the service is consuming the error budget, relative to the attainment goal of the SLO.
         * </p>
         * 
         * @param burnRateConfigurations
         *        Use this array to create <i>burn rates</i> for this SLO. Each burn rate is a metric that indicates how
         *        fast the service is consuming the error budget, relative to the attainment goal of the SLO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder burnRateConfigurations(BurnRateConfiguration... burnRateConfigurations);

        /**
         * <p>
         * Use this array to create <i>burn rates</i> for this SLO. Each burn rate is a metric that indicates how fast
         * the service is consuming the error budget, relative to the attainment goal of the SLO.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.BurnRateConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.BurnRateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.BurnRateConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link #burnRateConfigurations(List<BurnRateConfiguration>)}.
         * 
         * @param burnRateConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.BurnRateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #burnRateConfigurations(java.util.Collection<BurnRateConfiguration>)
         */
        Builder burnRateConfigurations(Consumer<BurnRateConfiguration.Builder>... burnRateConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationSignalsRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private ServiceLevelIndicatorConfig sliConfig;

        private RequestBasedServiceLevelIndicatorConfig requestBasedSliConfig;

        private Goal goal;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<BurnRateConfiguration> burnRateConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceLevelObjectiveRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            sliConfig(model.sliConfig);
            requestBasedSliConfig(model.requestBasedSliConfig);
            goal(model.goal);
            tags(model.tags);
            burnRateConfigurations(model.burnRateConfigurations);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ServiceLevelIndicatorConfig.Builder getSliConfig() {
            return sliConfig != null ? sliConfig.toBuilder() : null;
        }

        public final void setSliConfig(ServiceLevelIndicatorConfig.BuilderImpl sliConfig) {
            this.sliConfig = sliConfig != null ? sliConfig.build() : null;
        }

        @Override
        public final Builder sliConfig(ServiceLevelIndicatorConfig sliConfig) {
            this.sliConfig = sliConfig;
            return this;
        }

        public final RequestBasedServiceLevelIndicatorConfig.Builder getRequestBasedSliConfig() {
            return requestBasedSliConfig != null ? requestBasedSliConfig.toBuilder() : null;
        }

        public final void setRequestBasedSliConfig(RequestBasedServiceLevelIndicatorConfig.BuilderImpl requestBasedSliConfig) {
            this.requestBasedSliConfig = requestBasedSliConfig != null ? requestBasedSliConfig.build() : null;
        }

        @Override
        public final Builder requestBasedSliConfig(RequestBasedServiceLevelIndicatorConfig requestBasedSliConfig) {
            this.requestBasedSliConfig = requestBasedSliConfig;
            return this;
        }

        public final Goal.Builder getGoal() {
            return goal != null ? goal.toBuilder() : null;
        }

        public final void setGoal(Goal.BuilderImpl goal) {
            this.goal = goal != null ? goal.build() : null;
        }

        @Override
        public final Builder goal(Goal goal) {
            this.goal = goal;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BurnRateConfiguration.Builder> getBurnRateConfigurations() {
            List<BurnRateConfiguration.Builder> result = BurnRateConfigurationsCopier.copyToBuilder(this.burnRateConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBurnRateConfigurations(Collection<BurnRateConfiguration.BuilderImpl> burnRateConfigurations) {
            this.burnRateConfigurations = BurnRateConfigurationsCopier.copyFromBuilder(burnRateConfigurations);
        }

        @Override
        public final Builder burnRateConfigurations(Collection<BurnRateConfiguration> burnRateConfigurations) {
            this.burnRateConfigurations = BurnRateConfigurationsCopier.copy(burnRateConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder burnRateConfigurations(BurnRateConfiguration... burnRateConfigurations) {
            burnRateConfigurations(Arrays.asList(burnRateConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder burnRateConfigurations(Consumer<BurnRateConfiguration.Builder>... burnRateConfigurations) {
            burnRateConfigurations(Stream.of(burnRateConfigurations)
                    .map(c -> BurnRateConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceLevelObjectiveRequest build() {
            return new CreateServiceLevelObjectiveRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
