/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceLevelObjectiveResponse extends ApplicationSignalsResponse implements
        ToCopyableBuilder<GetServiceLevelObjectiveResponse.Builder, GetServiceLevelObjectiveResponse> {
    private static final SdkField<ServiceLevelObjective> SLO_FIELD = SdkField
            .<ServiceLevelObjective> builder(MarshallingType.SDK_POJO).memberName("Slo")
            .getter(getter(GetServiceLevelObjectiveResponse::slo)).setter(setter(Builder::slo))
            .constructor(ServiceLevelObjective::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ServiceLevelObjective slo;

    private GetServiceLevelObjectiveResponse(BuilderImpl builder) {
        super(builder);
        this.slo = builder.slo;
    }

    /**
     * <p>
     * A structure containing the information about the SLO.
     * </p>
     * 
     * @return A structure containing the information about the SLO.
     */
    public final ServiceLevelObjective slo() {
        return slo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(slo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceLevelObjectiveResponse)) {
            return false;
        }
        GetServiceLevelObjectiveResponse other = (GetServiceLevelObjectiveResponse) obj;
        return Objects.equals(slo(), other.slo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetServiceLevelObjectiveResponse").add("Slo", slo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Slo":
            return Optional.ofNullable(clazz.cast(slo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Slo", SLO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetServiceLevelObjectiveResponse, T> g) {
        return obj -> g.apply((GetServiceLevelObjectiveResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationSignalsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetServiceLevelObjectiveResponse> {
        /**
         * <p>
         * A structure containing the information about the SLO.
         * </p>
         * 
         * @param slo
         *        A structure containing the information about the SLO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slo(ServiceLevelObjective slo);

        /**
         * <p>
         * A structure containing the information about the SLO.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceLevelObjective.Builder} avoiding
         * the need to create one manually via {@link ServiceLevelObjective#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceLevelObjective.Builder#build()} is called immediately and
         * its result is passed to {@link #slo(ServiceLevelObjective)}.
         * 
         * @param slo
         *        a consumer that will call methods on {@link ServiceLevelObjective.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slo(ServiceLevelObjective)
         */
        default Builder slo(Consumer<ServiceLevelObjective.Builder> slo) {
            return slo(ServiceLevelObjective.builder().applyMutation(slo).build());
        }
    }

    static final class BuilderImpl extends ApplicationSignalsResponse.BuilderImpl implements Builder {
        private ServiceLevelObjective slo;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceLevelObjectiveResponse model) {
            super(model);
            slo(model.slo);
        }

        public final ServiceLevelObjective.Builder getSlo() {
            return slo != null ? slo.toBuilder() : null;
        }

        public final void setSlo(ServiceLevelObjective.BuilderImpl slo) {
            this.slo = slo != null ? slo.build() : null;
        }

        @Override
        public final Builder slo(ServiceLevelObjective slo) {
            this.slo = slo;
            return this;
        }

        @Override
        public GetServiceLevelObjectiveResponse build() {
            return new GetServiceLevelObjectiveResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
