/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains the attributes that determine the goal of an SLO. This includes the time period for
 * evaluation and the attainment threshold.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Goal implements SdkPojo, Serializable, ToCopyableBuilder<Goal.Builder, Goal> {
    private static final SdkField<Interval> INTERVAL_FIELD = SdkField.<Interval> builder(MarshallingType.SDK_POJO)
            .memberName("Interval").getter(getter(Goal::interval)).setter(setter(Builder::interval))
            .constructor(Interval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()).build();

    private static final SdkField<Double> ATTAINMENT_GOAL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("AttainmentGoal").getter(getter(Goal::attainmentGoal)).setter(setter(Builder::attainmentGoal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttainmentGoal").build()).build();

    private static final SdkField<Double> WARNING_THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("WarningThreshold").getter(getter(Goal::warningThreshold)).setter(setter(Builder::warningThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarningThreshold").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERVAL_FIELD,
            ATTAINMENT_GOAL_FIELD, WARNING_THRESHOLD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Interval interval;

    private final Double attainmentGoal;

    private final Double warningThreshold;

    private Goal(BuilderImpl builder) {
        this.interval = builder.interval;
        this.attainmentGoal = builder.attainmentGoal;
        this.warningThreshold = builder.warningThreshold;
    }

    /**
     * <p>
     * The time period used to evaluate the SLO. It can be either a calendar interval or rolling interval.
     * </p>
     * <p>
     * If you omit this parameter, a rolling interval of 7 days is used.
     * </p>
     * 
     * @return The time period used to evaluate the SLO. It can be either a calendar interval or rolling interval.</p>
     *         <p>
     *         If you omit this parameter, a rolling interval of 7 days is used.
     */
    public final Interval interval() {
        return interval;
    }

    /**
     * <p>
     * The threshold that determines if the goal is being met.
     * </p>
     * <p>
     * If this is a period-based SLO, the attainment goal is the percentage of good periods that meet the threshold
     * requirements to the total periods within the interval. For example, an attainment goal of 99.9% means that within
     * your interval, you are targeting 99.9% of the periods to be in healthy state.
     * </p>
     * <p>
     * If this is a request-based SLO, the attainment goal is the percentage of requests that must be successful to meet
     * the attainment goal.
     * </p>
     * <p>
     * If you omit this parameter, 99 is used to represent 99% as the attainment goal.
     * </p>
     * 
     * @return The threshold that determines if the goal is being met.</p>
     *         <p>
     *         If this is a period-based SLO, the attainment goal is the percentage of good periods that meet the
     *         threshold requirements to the total periods within the interval. For example, an attainment goal of 99.9%
     *         means that within your interval, you are targeting 99.9% of the periods to be in healthy state.
     *         </p>
     *         <p>
     *         If this is a request-based SLO, the attainment goal is the percentage of requests that must be successful
     *         to meet the attainment goal.
     *         </p>
     *         <p>
     *         If you omit this parameter, 99 is used to represent 99% as the attainment goal.
     */
    public final Double attainmentGoal() {
        return attainmentGoal;
    }

    /**
     * <p>
     * The percentage of remaining budget over total budget that you want to get warnings for. If you omit this
     * parameter, the default of 50.0 is used.
     * </p>
     * 
     * @return The percentage of remaining budget over total budget that you want to get warnings for. If you omit this
     *         parameter, the default of 50.0 is used.
     */
    public final Double warningThreshold() {
        return warningThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(interval());
        hashCode = 31 * hashCode + Objects.hashCode(attainmentGoal());
        hashCode = 31 * hashCode + Objects.hashCode(warningThreshold());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Goal)) {
            return false;
        }
        Goal other = (Goal) obj;
        return Objects.equals(interval(), other.interval()) && Objects.equals(attainmentGoal(), other.attainmentGoal())
                && Objects.equals(warningThreshold(), other.warningThreshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Goal").add("Interval", interval()).add("AttainmentGoal", attainmentGoal())
                .add("WarningThreshold", warningThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Interval":
            return Optional.ofNullable(clazz.cast(interval()));
        case "AttainmentGoal":
            return Optional.ofNullable(clazz.cast(attainmentGoal()));
        case "WarningThreshold":
            return Optional.ofNullable(clazz.cast(warningThreshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Interval", INTERVAL_FIELD);
        map.put("AttainmentGoal", ATTAINMENT_GOAL_FIELD);
        map.put("WarningThreshold", WARNING_THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Goal, T> g) {
        return obj -> g.apply((Goal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Goal> {
        /**
         * <p>
         * The time period used to evaluate the SLO. It can be either a calendar interval or rolling interval.
         * </p>
         * <p>
         * If you omit this parameter, a rolling interval of 7 days is used.
         * </p>
         * 
         * @param interval
         *        The time period used to evaluate the SLO. It can be either a calendar interval or rolling
         *        interval.</p>
         *        <p>
         *        If you omit this parameter, a rolling interval of 7 days is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interval(Interval interval);

        /**
         * <p>
         * The time period used to evaluate the SLO. It can be either a calendar interval or rolling interval.
         * </p>
         * <p>
         * If you omit this parameter, a rolling interval of 7 days is used.
         * </p>
         * This is a convenience method that creates an instance of the {@link Interval.Builder} avoiding the need to
         * create one manually via {@link Interval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Interval.Builder#build()} is called immediately and its result is
         * passed to {@link #interval(Interval)}.
         * 
         * @param interval
         *        a consumer that will call methods on {@link Interval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interval(Interval)
         */
        default Builder interval(Consumer<Interval.Builder> interval) {
            return interval(Interval.builder().applyMutation(interval).build());
        }

        /**
         * <p>
         * The threshold that determines if the goal is being met.
         * </p>
         * <p>
         * If this is a period-based SLO, the attainment goal is the percentage of good periods that meet the threshold
         * requirements to the total periods within the interval. For example, an attainment goal of 99.9% means that
         * within your interval, you are targeting 99.9% of the periods to be in healthy state.
         * </p>
         * <p>
         * If this is a request-based SLO, the attainment goal is the percentage of requests that must be successful to
         * meet the attainment goal.
         * </p>
         * <p>
         * If you omit this parameter, 99 is used to represent 99% as the attainment goal.
         * </p>
         * 
         * @param attainmentGoal
         *        The threshold that determines if the goal is being met.</p>
         *        <p>
         *        If this is a period-based SLO, the attainment goal is the percentage of good periods that meet the
         *        threshold requirements to the total periods within the interval. For example, an attainment goal of
         *        99.9% means that within your interval, you are targeting 99.9% of the periods to be in healthy state.
         *        </p>
         *        <p>
         *        If this is a request-based SLO, the attainment goal is the percentage of requests that must be
         *        successful to meet the attainment goal.
         *        </p>
         *        <p>
         *        If you omit this parameter, 99 is used to represent 99% as the attainment goal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attainmentGoal(Double attainmentGoal);

        /**
         * <p>
         * The percentage of remaining budget over total budget that you want to get warnings for. If you omit this
         * parameter, the default of 50.0 is used.
         * </p>
         * 
         * @param warningThreshold
         *        The percentage of remaining budget over total budget that you want to get warnings for. If you omit
         *        this parameter, the default of 50.0 is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warningThreshold(Double warningThreshold);
    }

    static final class BuilderImpl implements Builder {
        private Interval interval;

        private Double attainmentGoal;

        private Double warningThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(Goal model) {
            interval(model.interval);
            attainmentGoal(model.attainmentGoal);
            warningThreshold(model.warningThreshold);
        }

        public final Interval.Builder getInterval() {
            return interval != null ? interval.toBuilder() : null;
        }

        public final void setInterval(Interval.BuilderImpl interval) {
            this.interval = interval != null ? interval.build() : null;
        }

        @Override
        public final Builder interval(Interval interval) {
            this.interval = interval;
            return this;
        }

        public final Double getAttainmentGoal() {
            return attainmentGoal;
        }

        public final void setAttainmentGoal(Double attainmentGoal) {
            this.attainmentGoal = attainmentGoal;
        }

        @Override
        public final Builder attainmentGoal(Double attainmentGoal) {
            this.attainmentGoal = attainmentGoal;
            return this;
        }

        public final Double getWarningThreshold() {
            return warningThreshold;
        }

        public final void setWarningThreshold(Double warningThreshold) {
            this.warningThreshold = warningThreshold;
        }

        @Override
        public final Builder warningThreshold(Double warningThreshold) {
            this.warningThreshold = warningThreshold;
            return this;
        }

        @Override
        public Goal build() {
            return new Goal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
