/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines how services should be grouped based on specific attributes. This allows logical organization of services in
 * dashboards and service maps.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupingAttributeDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<GroupingAttributeDefinition.Builder, GroupingAttributeDefinition> {
    private static final SdkField<String> GROUPING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupingName").getter(getter(GroupingAttributeDefinition::groupingName))
            .setter(setter(Builder::groupingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupingName").build()).build();

    private static final SdkField<List<String>> GROUPING_SOURCE_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GroupingSourceKeys")
            .getter(getter(GroupingAttributeDefinition::groupingSourceKeys))
            .setter(setter(Builder::groupingSourceKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupingSourceKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_GROUPING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultGroupingValue").getter(getter(GroupingAttributeDefinition::defaultGroupingValue))
            .setter(setter(Builder::defaultGroupingValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultGroupingValue").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUPING_NAME_FIELD,
            GROUPING_SOURCE_KEYS_FIELD, DEFAULT_GROUPING_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String groupingName;

    private final List<String> groupingSourceKeys;

    private final String defaultGroupingValue;

    private GroupingAttributeDefinition(BuilderImpl builder) {
        this.groupingName = builder.groupingName;
        this.groupingSourceKeys = builder.groupingSourceKeys;
        this.defaultGroupingValue = builder.defaultGroupingValue;
    }

    /**
     * <p>
     * The name of the grouping attribute, such as "Environment", "Team", or "Application".
     * </p>
     * 
     * @return The name of the grouping attribute, such as "Environment", "Team", or "Application".
     */
    public final String groupingName() {
        return groupingName;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupingSourceKeys property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupingSourceKeys() {
        return groupingSourceKeys != null && !(groupingSourceKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of source attribute keys that will be used to determine the grouping value for each service. These keys
     * correspond to service metadata or tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupingSourceKeys} method.
     * </p>
     * 
     * @return An array of source attribute keys that will be used to determine the grouping value for each service.
     *         These keys correspond to service metadata or tags.
     */
    public final List<String> groupingSourceKeys() {
        return groupingSourceKeys;
    }

    /**
     * <p>
     * The default value to use for grouping when a service doesn't have any of the specified source keys, such as
     * "Unknown" or "Unassigned".
     * </p>
     * 
     * @return The default value to use for grouping when a service doesn't have any of the specified source keys, such
     *         as "Unknown" or "Unassigned".
     */
    public final String defaultGroupingValue() {
        return defaultGroupingValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupingName());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupingSourceKeys() ? groupingSourceKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultGroupingValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupingAttributeDefinition)) {
            return false;
        }
        GroupingAttributeDefinition other = (GroupingAttributeDefinition) obj;
        return Objects.equals(groupingName(), other.groupingName()) && hasGroupingSourceKeys() == other.hasGroupingSourceKeys()
                && Objects.equals(groupingSourceKeys(), other.groupingSourceKeys())
                && Objects.equals(defaultGroupingValue(), other.defaultGroupingValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupingAttributeDefinition").add("GroupingName", groupingName())
                .add("GroupingSourceKeys", hasGroupingSourceKeys() ? groupingSourceKeys() : null)
                .add("DefaultGroupingValue", defaultGroupingValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupingName":
            return Optional.ofNullable(clazz.cast(groupingName()));
        case "GroupingSourceKeys":
            return Optional.ofNullable(clazz.cast(groupingSourceKeys()));
        case "DefaultGroupingValue":
            return Optional.ofNullable(clazz.cast(defaultGroupingValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupingName", GROUPING_NAME_FIELD);
        map.put("GroupingSourceKeys", GROUPING_SOURCE_KEYS_FIELD);
        map.put("DefaultGroupingValue", DEFAULT_GROUPING_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GroupingAttributeDefinition, T> g) {
        return obj -> g.apply((GroupingAttributeDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupingAttributeDefinition> {
        /**
         * <p>
         * The name of the grouping attribute, such as "Environment", "Team", or "Application".
         * </p>
         * 
         * @param groupingName
         *        The name of the grouping attribute, such as "Environment", "Team", or "Application".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingName(String groupingName);

        /**
         * <p>
         * An array of source attribute keys that will be used to determine the grouping value for each service. These
         * keys correspond to service metadata or tags.
         * </p>
         * 
         * @param groupingSourceKeys
         *        An array of source attribute keys that will be used to determine the grouping value for each service.
         *        These keys correspond to service metadata or tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingSourceKeys(Collection<String> groupingSourceKeys);

        /**
         * <p>
         * An array of source attribute keys that will be used to determine the grouping value for each service. These
         * keys correspond to service metadata or tags.
         * </p>
         * 
         * @param groupingSourceKeys
         *        An array of source attribute keys that will be used to determine the grouping value for each service.
         *        These keys correspond to service metadata or tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingSourceKeys(String... groupingSourceKeys);

        /**
         * <p>
         * The default value to use for grouping when a service doesn't have any of the specified source keys, such as
         * "Unknown" or "Unassigned".
         * </p>
         * 
         * @param defaultGroupingValue
         *        The default value to use for grouping when a service doesn't have any of the specified source keys,
         *        such as "Unknown" or "Unassigned".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultGroupingValue(String defaultGroupingValue);
    }

    static final class BuilderImpl implements Builder {
        private String groupingName;

        private List<String> groupingSourceKeys = DefaultSdkAutoConstructList.getInstance();

        private String defaultGroupingValue;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupingAttributeDefinition model) {
            groupingName(model.groupingName);
            groupingSourceKeys(model.groupingSourceKeys);
            defaultGroupingValue(model.defaultGroupingValue);
        }

        public final String getGroupingName() {
            return groupingName;
        }

        public final void setGroupingName(String groupingName) {
            this.groupingName = groupingName;
        }

        @Override
        public final Builder groupingName(String groupingName) {
            this.groupingName = groupingName;
            return this;
        }

        public final Collection<String> getGroupingSourceKeys() {
            if (groupingSourceKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return groupingSourceKeys;
        }

        public final void setGroupingSourceKeys(Collection<String> groupingSourceKeys) {
            this.groupingSourceKeys = GroupingSourceKeyStringListCopier.copy(groupingSourceKeys);
        }

        @Override
        public final Builder groupingSourceKeys(Collection<String> groupingSourceKeys) {
            this.groupingSourceKeys = GroupingSourceKeyStringListCopier.copy(groupingSourceKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingSourceKeys(String... groupingSourceKeys) {
            groupingSourceKeys(Arrays.asList(groupingSourceKeys));
            return this;
        }

        public final String getDefaultGroupingValue() {
            return defaultGroupingValue;
        }

        public final void setDefaultGroupingValue(String defaultGroupingValue) {
            this.defaultGroupingValue = defaultGroupingValue;
        }

        @Override
        public final Builder defaultGroupingValue(String defaultGroupingValue) {
            this.defaultGroupingValue = defaultGroupingValue;
            return this;
        }

        @Override
        public GroupingAttributeDefinition build() {
            return new GroupingAttributeDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
