/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceStatesRequest extends ApplicationSignalsRequest implements
        ToCopyableBuilder<ListServiceStatesRequest.Builder, ListServiceStatesRequest> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ListServiceStatesRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ListServiceStatesRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListServiceStatesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListServiceStatesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Boolean> INCLUDE_LINKED_ACCOUNTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeLinkedAccounts").getter(getter(ListServiceStatesRequest::includeLinkedAccounts))
            .setter(setter(Builder::includeLinkedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeLinkedAccounts").build())
            .build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(ListServiceStatesRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()).build();

    private static final SdkField<List<AttributeFilter>> ATTRIBUTE_FILTERS_FIELD = SdkField
            .<List<AttributeFilter>> builder(MarshallingType.LIST)
            .memberName("AttributeFilters")
            .getter(getter(ListServiceStatesRequest::attributeFilters))
            .setter(setter(Builder::attributeFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, INCLUDE_LINKED_ACCOUNTS_FIELD, AWS_ACCOUNT_ID_FIELD,
            ATTRIBUTE_FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant startTime;

    private final Instant endTime;

    private final Integer maxResults;

    private final String nextToken;

    private final Boolean includeLinkedAccounts;

    private final String awsAccountId;

    private final List<AttributeFilter> attributeFilters;

    private ListServiceStatesRequest(BuilderImpl builder) {
        super(builder);
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.includeLinkedAccounts = builder.includeLinkedAccounts;
        this.awsAccountId = builder.awsAccountId;
        this.attributeFilters = builder.attributeFilters;
    }

    /**
     * <p>
     * The start time for the service states query. Only service states from this time onward will be included. Specify
     * the time as the number of milliseconds since January 1, 1970, 00:00:00 UTC.
     * </p>
     * 
     * @return The start time for the service states query. Only service states from this time onward will be included.
     *         Specify the time as the number of milliseconds since January 1, 1970, 00:00:00 UTC.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time for the service states query. Only service states before this time will be included. Specify the
     * time as the number of milliseconds since January 1, 1970, 00:00:00 UTC.
     * </p>
     * 
     * @return The end time for the service states query. Only service states before this time will be included. Specify
     *         the time as the number of milliseconds since January 1, 1970, 00:00:00 UTC.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The maximum number of service states to return in a single request. Valid range is 1 to 100. If not specified,
     * defaults to 50.
     * </p>
     * 
     * @return The maximum number of service states to return in a single request. Valid range is 1 to 100. If not
     *         specified, defaults to 50.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results. Use this token to retrieve additional pages of service states when the
     * result set is large.
     * </p>
     * 
     * @return The token for the next set of results. Use this token to retrieve additional pages of service states when
     *         the result set is large.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies whether to include service states from linked AWS accounts in the results. Set to <code>true</code> to
     * include linked accounts, or <code>false</code> to only include the current account. Defaults to
     * <code>false</code>.
     * </p>
     * 
     * @return Specifies whether to include service states from linked AWS accounts in the results. Set to
     *         <code>true</code> to include linked accounts, or <code>false</code> to only include the current account.
     *         Defaults to <code>false</code>.
     */
    public final Boolean includeLinkedAccounts() {
        return includeLinkedAccounts;
    }

    /**
     * <p>
     * The AWS account ID to filter service states. If specified, only service states from this account will be
     * returned. If not specified, service states from the current account (and linked accounts if enabled) are
     * returned.
     * </p>
     * 
     * @return The AWS account ID to filter service states. If specified, only service states from this account will be
     *         returned. If not specified, service states from the current account (and linked accounts if enabled) are
     *         returned.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeFilters() {
        return attributeFilters != null && !(attributeFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of attribute filters to narrow down the service states returned. Each filter specifies an attribute name
     * and the values to match against.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeFilters} method.
     * </p>
     * 
     * @return An array of attribute filters to narrow down the service states returned. Each filter specifies an
     *         attribute name and the values to match against.
     */
    public final List<AttributeFilter> attributeFilters() {
        return attributeFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(includeLinkedAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeFilters() ? attributeFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceStatesRequest)) {
            return false;
        }
        ListServiceStatesRequest other = (ListServiceStatesRequest) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(includeLinkedAccounts(), other.includeLinkedAccounts())
                && Objects.equals(awsAccountId(), other.awsAccountId()) && hasAttributeFilters() == other.hasAttributeFilters()
                && Objects.equals(attributeFilters(), other.attributeFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServiceStatesRequest").add("StartTime", startTime()).add("EndTime", endTime())
                .add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("IncludeLinkedAccounts", includeLinkedAccounts()).add("AwsAccountId", awsAccountId())
                .add("AttributeFilters", hasAttributeFilters() ? attributeFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "IncludeLinkedAccounts":
            return Optional.ofNullable(clazz.cast(includeLinkedAccounts()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "AttributeFilters":
            return Optional.ofNullable(clazz.cast(attributeFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("IncludeLinkedAccounts", INCLUDE_LINKED_ACCOUNTS_FIELD);
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("AttributeFilters", ATTRIBUTE_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServiceStatesRequest, T> g) {
        return obj -> g.apply((ListServiceStatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationSignalsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListServiceStatesRequest> {
        /**
         * <p>
         * The start time for the service states query. Only service states from this time onward will be included.
         * Specify the time as the number of milliseconds since January 1, 1970, 00:00:00 UTC.
         * </p>
         * 
         * @param startTime
         *        The start time for the service states query. Only service states from this time onward will be
         *        included. Specify the time as the number of milliseconds since January 1, 1970, 00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time for the service states query. Only service states before this time will be included. Specify the
         * time as the number of milliseconds since January 1, 1970, 00:00:00 UTC.
         * </p>
         * 
         * @param endTime
         *        The end time for the service states query. Only service states before this time will be included.
         *        Specify the time as the number of milliseconds since January 1, 1970, 00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The maximum number of service states to return in a single request. Valid range is 1 to 100. If not
         * specified, defaults to 50.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of service states to return in a single request. Valid range is 1 to 100. If not
         *        specified, defaults to 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results. Use this token to retrieve additional pages of service states when the
         * result set is large.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use this token to retrieve additional pages of service states
         *        when the result set is large.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies whether to include service states from linked AWS accounts in the results. Set to <code>true</code>
         * to include linked accounts, or <code>false</code> to only include the current account. Defaults to
         * <code>false</code>.
         * </p>
         * 
         * @param includeLinkedAccounts
         *        Specifies whether to include service states from linked AWS accounts in the results. Set to
         *        <code>true</code> to include linked accounts, or <code>false</code> to only include the current
         *        account. Defaults to <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeLinkedAccounts(Boolean includeLinkedAccounts);

        /**
         * <p>
         * The AWS account ID to filter service states. If specified, only service states from this account will be
         * returned. If not specified, service states from the current account (and linked accounts if enabled) are
         * returned.
         * </p>
         * 
         * @param awsAccountId
         *        The AWS account ID to filter service states. If specified, only service states from this account will
         *        be returned. If not specified, service states from the current account (and linked accounts if
         *        enabled) are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * An array of attribute filters to narrow down the service states returned. Each filter specifies an attribute
         * name and the values to match against.
         * </p>
         * 
         * @param attributeFilters
         *        An array of attribute filters to narrow down the service states returned. Each filter specifies an
         *        attribute name and the values to match against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeFilters(Collection<AttributeFilter> attributeFilters);

        /**
         * <p>
         * An array of attribute filters to narrow down the service states returned. Each filter specifies an attribute
         * name and the values to match against.
         * </p>
         * 
         * @param attributeFilters
         *        An array of attribute filters to narrow down the service states returned. Each filter specifies an
         *        attribute name and the values to match against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeFilters(AttributeFilter... attributeFilters);

        /**
         * <p>
         * An array of attribute filters to narrow down the service states returned. Each filter specifies an attribute
         * name and the values to match against.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.AttributeFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.AttributeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.AttributeFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #attributeFilters(List<AttributeFilter>)}.
         * 
         * @param attributeFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.AttributeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeFilters(java.util.Collection<AttributeFilter>)
         */
        Builder attributeFilters(Consumer<AttributeFilter.Builder>... attributeFilters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationSignalsRequest.BuilderImpl implements Builder {
        private Instant startTime;

        private Instant endTime;

        private Integer maxResults;

        private String nextToken;

        private Boolean includeLinkedAccounts;

        private String awsAccountId;

        private List<AttributeFilter> attributeFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceStatesRequest model) {
            super(model);
            startTime(model.startTime);
            endTime(model.endTime);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            includeLinkedAccounts(model.includeLinkedAccounts);
            awsAccountId(model.awsAccountId);
            attributeFilters(model.attributeFilters);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getIncludeLinkedAccounts() {
            return includeLinkedAccounts;
        }

        public final void setIncludeLinkedAccounts(Boolean includeLinkedAccounts) {
            this.includeLinkedAccounts = includeLinkedAccounts;
        }

        @Override
        public final Builder includeLinkedAccounts(Boolean includeLinkedAccounts) {
            this.includeLinkedAccounts = includeLinkedAccounts;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final List<AttributeFilter.Builder> getAttributeFilters() {
            List<AttributeFilter.Builder> result = AttributeFiltersCopier.copyToBuilder(this.attributeFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeFilters(Collection<AttributeFilter.BuilderImpl> attributeFilters) {
            this.attributeFilters = AttributeFiltersCopier.copyFromBuilder(attributeFilters);
        }

        @Override
        public final Builder attributeFilters(Collection<AttributeFilter> attributeFilters) {
            this.attributeFilters = AttributeFiltersCopier.copy(attributeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeFilters(AttributeFilter... attributeFilters) {
            attributeFilters(Arrays.asList(attributeFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeFilters(Consumer<AttributeFilter.Builder>... attributeFilters) {
            attributeFilters(Stream.of(attributeFilters).map(c -> AttributeFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServiceStatesRequest build() {
            return new ListServiceStatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
