/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Use this structure to specify the information for the metric that a period-based SLO will monitor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestBasedServiceLevelIndicatorMetricConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<RequestBasedServiceLevelIndicatorMetricConfig.Builder, RequestBasedServiceLevelIndicatorMetricConfig> {
    private static final SdkField<Map<String, String>> KEY_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("KeyAttributes")
            .getter(getter(RequestBasedServiceLevelIndicatorMetricConfig::keyAttributes))
            .setter(setter(Builder::keyAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationName").getter(getter(RequestBasedServiceLevelIndicatorMetricConfig::operationName))
            .setter(setter(Builder::operationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationName").build()).build();

    private static final SdkField<String> METRIC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricType").getter(getter(RequestBasedServiceLevelIndicatorMetricConfig::metricTypeAsString))
            .setter(setter(Builder::metricType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricType").build()).build();

    private static final SdkField<List<MetricDataQuery>> TOTAL_REQUEST_COUNT_METRIC_FIELD = SdkField
            .<List<MetricDataQuery>> builder(MarshallingType.LIST)
            .memberName("TotalRequestCountMetric")
            .getter(getter(RequestBasedServiceLevelIndicatorMetricConfig::totalRequestCountMetric))
            .setter(setter(Builder::totalRequestCountMetric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRequestCountMetric").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricDataQuery> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDataQuery::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MonitoredRequestCountMetricDataQueries> MONITORED_REQUEST_COUNT_METRIC_FIELD = SdkField
            .<MonitoredRequestCountMetricDataQueries> builder(MarshallingType.SDK_POJO)
            .memberName("MonitoredRequestCountMetric")
            .getter(getter(RequestBasedServiceLevelIndicatorMetricConfig::monitoredRequestCountMetric))
            .setter(setter(Builder::monitoredRequestCountMetric))
            .constructor(MonitoredRequestCountMetricDataQueries::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoredRequestCountMetric")
                    .build()).build();

    private static final SdkField<DependencyConfig> DEPENDENCY_CONFIG_FIELD = SdkField
            .<DependencyConfig> builder(MarshallingType.SDK_POJO).memberName("DependencyConfig")
            .getter(getter(RequestBasedServiceLevelIndicatorMetricConfig::dependencyConfig))
            .setter(setter(Builder::dependencyConfig)).constructor(DependencyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependencyConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ATTRIBUTES_FIELD,
            OPERATION_NAME_FIELD, METRIC_TYPE_FIELD, TOTAL_REQUEST_COUNT_METRIC_FIELD, MONITORED_REQUEST_COUNT_METRIC_FIELD,
            DEPENDENCY_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, String> keyAttributes;

    private final String operationName;

    private final String metricType;

    private final List<MetricDataQuery> totalRequestCountMetric;

    private final MonitoredRequestCountMetricDataQueries monitoredRequestCountMetric;

    private final DependencyConfig dependencyConfig;

    private RequestBasedServiceLevelIndicatorMetricConfig(BuilderImpl builder) {
        this.keyAttributes = builder.keyAttributes;
        this.operationName = builder.operationName;
        this.metricType = builder.metricType;
        this.totalRequestCountMetric = builder.totalRequestCountMetric;
        this.monitoredRequestCountMetric = builder.monitoredRequestCountMetric;
        this.dependencyConfig = builder.dependencyConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeyAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKeyAttributes() {
        return keyAttributes != null && !(keyAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * If this SLO is related to a metric collected by Application Signals, you must use this field to specify which
     * service the SLO metric is related to. To do so, you must specify at least the <code>Type</code>,
     * <code>Name</code>, and <code>Environment</code> attributes.
     * </p>
     * <p>
     * This is a string-to-string map. It can include the following fields.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Type</code> designates the type of object this is.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the
     * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field
     * is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the
     * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeyAttributes} method.
     * </p>
     * 
     * @return If this SLO is related to a metric collected by Application Signals, you must use this field to specify
     *         which service the SLO metric is related to. To do so, you must specify at least the <code>Type</code>,
     *         <code>Name</code>, and <code>Environment</code> attributes.</p>
     *         <p>
     *         This is a string-to-string map. It can include the following fields.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Type</code> designates the type of object this is.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of
     *         the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Name</code> specifies the name of the object. This is used only if the value of the
     *         <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value
     *         of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
     *         </p>
     *         </li>
     */
    public final Map<String, String> keyAttributes() {
        return keyAttributes;
    }

    /**
     * <p>
     * If the SLO is to monitor a specific operation of the service, use this field to specify the name of that
     * operation.
     * </p>
     * 
     * @return If the SLO is to monitor a specific operation of the service, use this field to specify the name of that
     *         operation.
     */
    public final String operationName() {
        return operationName;
    }

    /**
     * <p>
     * If the SLO is to monitor either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that Application
     * Signals collects, use this field to specify which of those metrics is used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricType} will
     * return {@link ServiceLevelIndicatorMetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #metricTypeAsString}.
     * </p>
     * 
     * @return If the SLO is to monitor either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that
     *         Application Signals collects, use this field to specify which of those metrics is used.
     * @see ServiceLevelIndicatorMetricType
     */
    public final ServiceLevelIndicatorMetricType metricType() {
        return ServiceLevelIndicatorMetricType.fromValue(metricType);
    }

    /**
     * <p>
     * If the SLO is to monitor either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that Application
     * Signals collects, use this field to specify which of those metrics is used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricType} will
     * return {@link ServiceLevelIndicatorMetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #metricTypeAsString}.
     * </p>
     * 
     * @return If the SLO is to monitor either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that
     *         Application Signals collects, use this field to specify which of those metrics is used.
     * @see ServiceLevelIndicatorMetricType
     */
    public final String metricTypeAsString() {
        return metricType;
    }

    /**
     * For responses, this returns true if the service returned a value for the TotalRequestCountMetric property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTotalRequestCountMetric() {
        return totalRequestCountMetric != null && !(totalRequestCountMetric instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Use this structure to define the metric that you want to use as the "total requests" number for a request-based
     * SLO. This result will be divided by the "good request" or "bad request" value defined in
     * <code>MonitoredRequestCountMetric</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTotalRequestCountMetric} method.
     * </p>
     * 
     * @return Use this structure to define the metric that you want to use as the "total requests" number for a
     *         request-based SLO. This result will be divided by the "good request" or "bad request" value defined in
     *         <code>MonitoredRequestCountMetric</code>.
     */
    public final List<MetricDataQuery> totalRequestCountMetric() {
        return totalRequestCountMetric;
    }

    /**
     * <p>
     * Use this structure to define the metric that you want to use as the "good request" or "bad request" value for a
     * request-based SLO. This value observed for the metric defined in <code>TotalRequestCountMetric</code> will be
     * divided by the number found for <code>MonitoredRequestCountMetric</code> to determine the percentage of
     * successful requests that this SLO tracks.
     * </p>
     * 
     * @return Use this structure to define the metric that you want to use as the "good request" or "bad request" value
     *         for a request-based SLO. This value observed for the metric defined in
     *         <code>TotalRequestCountMetric</code> will be divided by the number found for
     *         <code>MonitoredRequestCountMetric</code> to determine the percentage of successful requests that this SLO
     *         tracks.
     */
    public final MonitoredRequestCountMetricDataQueries monitoredRequestCountMetric() {
        return monitoredRequestCountMetric;
    }

    /**
     * <p>
     * Identifies the dependency using the <code>DependencyKeyAttributes</code> and <code>DependencyOperationName</code>
     * .
     * </p>
     * 
     * @return Identifies the dependency using the <code>DependencyKeyAttributes</code> and
     *         <code>DependencyOperationName</code>.
     */
    public final DependencyConfig dependencyConfig() {
        return dependencyConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasKeyAttributes() ? keyAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(operationName());
        hashCode = 31 * hashCode + Objects.hashCode(metricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTotalRequestCountMetric() ? totalRequestCountMetric() : null);
        hashCode = 31 * hashCode + Objects.hashCode(monitoredRequestCountMetric());
        hashCode = 31 * hashCode + Objects.hashCode(dependencyConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestBasedServiceLevelIndicatorMetricConfig)) {
            return false;
        }
        RequestBasedServiceLevelIndicatorMetricConfig other = (RequestBasedServiceLevelIndicatorMetricConfig) obj;
        return hasKeyAttributes() == other.hasKeyAttributes() && Objects.equals(keyAttributes(), other.keyAttributes())
                && Objects.equals(operationName(), other.operationName())
                && Objects.equals(metricTypeAsString(), other.metricTypeAsString())
                && hasTotalRequestCountMetric() == other.hasTotalRequestCountMetric()
                && Objects.equals(totalRequestCountMetric(), other.totalRequestCountMetric())
                && Objects.equals(monitoredRequestCountMetric(), other.monitoredRequestCountMetric())
                && Objects.equals(dependencyConfig(), other.dependencyConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RequestBasedServiceLevelIndicatorMetricConfig")
                .add("KeyAttributes", hasKeyAttributes() ? keyAttributes() : null).add("OperationName", operationName())
                .add("MetricType", metricTypeAsString())
                .add("TotalRequestCountMetric", hasTotalRequestCountMetric() ? totalRequestCountMetric() : null)
                .add("MonitoredRequestCountMetric", monitoredRequestCountMetric()).add("DependencyConfig", dependencyConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyAttributes":
            return Optional.ofNullable(clazz.cast(keyAttributes()));
        case "OperationName":
            return Optional.ofNullable(clazz.cast(operationName()));
        case "MetricType":
            return Optional.ofNullable(clazz.cast(metricTypeAsString()));
        case "TotalRequestCountMetric":
            return Optional.ofNullable(clazz.cast(totalRequestCountMetric()));
        case "MonitoredRequestCountMetric":
            return Optional.ofNullable(clazz.cast(monitoredRequestCountMetric()));
        case "DependencyConfig":
            return Optional.ofNullable(clazz.cast(dependencyConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyAttributes", KEY_ATTRIBUTES_FIELD);
        map.put("OperationName", OPERATION_NAME_FIELD);
        map.put("MetricType", METRIC_TYPE_FIELD);
        map.put("TotalRequestCountMetric", TOTAL_REQUEST_COUNT_METRIC_FIELD);
        map.put("MonitoredRequestCountMetric", MONITORED_REQUEST_COUNT_METRIC_FIELD);
        map.put("DependencyConfig", DEPENDENCY_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RequestBasedServiceLevelIndicatorMetricConfig, T> g) {
        return obj -> g.apply((RequestBasedServiceLevelIndicatorMetricConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RequestBasedServiceLevelIndicatorMetricConfig> {
        /**
         * <p>
         * If this SLO is related to a metric collected by Application Signals, you must use this field to specify which
         * service the SLO metric is related to. To do so, you must specify at least the <code>Type</code>,
         * <code>Name</code>, and <code>Environment</code> attributes.
         * </p>
         * <p>
         * This is a string-to-string map. It can include the following fields.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Type</code> designates the type of object this is.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the
         * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code>
         * field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of
         * the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
         * </p>
         * </li>
         * </ul>
         * 
         * @param keyAttributes
         *        If this SLO is related to a metric collected by Application Signals, you must use this field to
         *        specify which service the SLO metric is related to. To do so, you must specify at least the
         *        <code>Type</code>, <code>Name</code>, and <code>Environment</code> attributes.</p>
         *        <p>
         *        This is a string-to-string map. It can include the following fields.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Type</code> designates the type of object this is.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ResourceType</code> specifies the type of the resource. This field is used only when the value
         *        of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Name</code> specifies the name of the object. This is used only if the value of the
         *        <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or
         *        <code>AWS::Service</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Identifier</code> identifies the resource objects of this resource. This is used only if the
         *        value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyAttributes(Map<String, String> keyAttributes);

        /**
         * <p>
         * If the SLO is to monitor a specific operation of the service, use this field to specify the name of that
         * operation.
         * </p>
         * 
         * @param operationName
         *        If the SLO is to monitor a specific operation of the service, use this field to specify the name of
         *        that operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationName(String operationName);

        /**
         * <p>
         * If the SLO is to monitor either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that Application
         * Signals collects, use this field to specify which of those metrics is used.
         * </p>
         * 
         * @param metricType
         *        If the SLO is to monitor either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that
         *        Application Signals collects, use this field to specify which of those metrics is used.
         * @see ServiceLevelIndicatorMetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceLevelIndicatorMetricType
         */
        Builder metricType(String metricType);

        /**
         * <p>
         * If the SLO is to monitor either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that Application
         * Signals collects, use this field to specify which of those metrics is used.
         * </p>
         * 
         * @param metricType
         *        If the SLO is to monitor either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that
         *        Application Signals collects, use this field to specify which of those metrics is used.
         * @see ServiceLevelIndicatorMetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceLevelIndicatorMetricType
         */
        Builder metricType(ServiceLevelIndicatorMetricType metricType);

        /**
         * <p>
         * Use this structure to define the metric that you want to use as the "total requests" number for a
         * request-based SLO. This result will be divided by the "good request" or "bad request" value defined in
         * <code>MonitoredRequestCountMetric</code>.
         * </p>
         * 
         * @param totalRequestCountMetric
         *        Use this structure to define the metric that you want to use as the "total requests" number for a
         *        request-based SLO. This result will be divided by the "good request" or "bad request" value defined in
         *        <code>MonitoredRequestCountMetric</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRequestCountMetric(Collection<MetricDataQuery> totalRequestCountMetric);

        /**
         * <p>
         * Use this structure to define the metric that you want to use as the "total requests" number for a
         * request-based SLO. This result will be divided by the "good request" or "bad request" value defined in
         * <code>MonitoredRequestCountMetric</code>.
         * </p>
         * 
         * @param totalRequestCountMetric
         *        Use this structure to define the metric that you want to use as the "total requests" number for a
         *        request-based SLO. This result will be divided by the "good request" or "bad request" value defined in
         *        <code>MonitoredRequestCountMetric</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRequestCountMetric(MetricDataQuery... totalRequestCountMetric);

        /**
         * <p>
         * Use this structure to define the metric that you want to use as the "total requests" number for a
         * request-based SLO. This result will be divided by the "good request" or "bad request" value defined in
         * <code>MonitoredRequestCountMetric</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery.Builder#build()} is called
         * immediately and its result is passed to {@link #totalRequestCountMetric(List<MetricDataQuery>)}.
         * 
         * @param totalRequestCountMetric
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #totalRequestCountMetric(java.util.Collection<MetricDataQuery>)
         */
        Builder totalRequestCountMetric(Consumer<MetricDataQuery.Builder>... totalRequestCountMetric);

        /**
         * <p>
         * Use this structure to define the metric that you want to use as the "good request" or "bad request" value for
         * a request-based SLO. This value observed for the metric defined in <code>TotalRequestCountMetric</code> will
         * be divided by the number found for <code>MonitoredRequestCountMetric</code> to determine the percentage of
         * successful requests that this SLO tracks.
         * </p>
         * 
         * @param monitoredRequestCountMetric
         *        Use this structure to define the metric that you want to use as the "good request" or "bad request"
         *        value for a request-based SLO. This value observed for the metric defined in
         *        <code>TotalRequestCountMetric</code> will be divided by the number found for
         *        <code>MonitoredRequestCountMetric</code> to determine the percentage of successful requests that this
         *        SLO tracks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoredRequestCountMetric(MonitoredRequestCountMetricDataQueries monitoredRequestCountMetric);

        /**
         * <p>
         * Use this structure to define the metric that you want to use as the "good request" or "bad request" value for
         * a request-based SLO. This value observed for the metric defined in <code>TotalRequestCountMetric</code> will
         * be divided by the number found for <code>MonitoredRequestCountMetric</code> to determine the percentage of
         * successful requests that this SLO tracks.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MonitoredRequestCountMetricDataQueries.Builder} avoiding the need to create one manually via
         * {@link MonitoredRequestCountMetricDataQueries#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoredRequestCountMetricDataQueries.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #monitoredRequestCountMetric(MonitoredRequestCountMetricDataQueries)}.
         * 
         * @param monitoredRequestCountMetric
         *        a consumer that will call methods on {@link MonitoredRequestCountMetricDataQueries.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoredRequestCountMetric(MonitoredRequestCountMetricDataQueries)
         */
        default Builder monitoredRequestCountMetric(
                Consumer<MonitoredRequestCountMetricDataQueries.Builder> monitoredRequestCountMetric) {
            return monitoredRequestCountMetric(MonitoredRequestCountMetricDataQueries.builder()
                    .applyMutation(monitoredRequestCountMetric).build());
        }

        /**
         * <p>
         * Identifies the dependency using the <code>DependencyKeyAttributes</code> and
         * <code>DependencyOperationName</code>.
         * </p>
         * 
         * @param dependencyConfig
         *        Identifies the dependency using the <code>DependencyKeyAttributes</code> and
         *        <code>DependencyOperationName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencyConfig(DependencyConfig dependencyConfig);

        /**
         * <p>
         * Identifies the dependency using the <code>DependencyKeyAttributes</code> and
         * <code>DependencyOperationName</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DependencyConfig.Builder} avoiding the
         * need to create one manually via {@link DependencyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DependencyConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #dependencyConfig(DependencyConfig)}.
         * 
         * @param dependencyConfig
         *        a consumer that will call methods on {@link DependencyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dependencyConfig(DependencyConfig)
         */
        default Builder dependencyConfig(Consumer<DependencyConfig.Builder> dependencyConfig) {
            return dependencyConfig(DependencyConfig.builder().applyMutation(dependencyConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> keyAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String operationName;

        private String metricType;

        private List<MetricDataQuery> totalRequestCountMetric = DefaultSdkAutoConstructList.getInstance();

        private MonitoredRequestCountMetricDataQueries monitoredRequestCountMetric;

        private DependencyConfig dependencyConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestBasedServiceLevelIndicatorMetricConfig model) {
            keyAttributes(model.keyAttributes);
            operationName(model.operationName);
            metricType(model.metricType);
            totalRequestCountMetric(model.totalRequestCountMetric);
            monitoredRequestCountMetric(model.monitoredRequestCountMetric);
            dependencyConfig(model.dependencyConfig);
        }

        public final Map<String, String> getKeyAttributes() {
            if (keyAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return keyAttributes;
        }

        public final void setKeyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
        }

        @Override
        public final Builder keyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
            return this;
        }

        public final String getOperationName() {
            return operationName;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final String getMetricType() {
            return metricType;
        }

        public final void setMetricType(String metricType) {
            this.metricType = metricType;
        }

        @Override
        public final Builder metricType(String metricType) {
            this.metricType = metricType;
            return this;
        }

        @Override
        public final Builder metricType(ServiceLevelIndicatorMetricType metricType) {
            this.metricType(metricType == null ? null : metricType.toString());
            return this;
        }

        public final List<MetricDataQuery.Builder> getTotalRequestCountMetric() {
            List<MetricDataQuery.Builder> result = MetricDataQueriesCopier.copyToBuilder(this.totalRequestCountMetric);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTotalRequestCountMetric(Collection<MetricDataQuery.BuilderImpl> totalRequestCountMetric) {
            this.totalRequestCountMetric = MetricDataQueriesCopier.copyFromBuilder(totalRequestCountMetric);
        }

        @Override
        public final Builder totalRequestCountMetric(Collection<MetricDataQuery> totalRequestCountMetric) {
            this.totalRequestCountMetric = MetricDataQueriesCopier.copy(totalRequestCountMetric);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder totalRequestCountMetric(MetricDataQuery... totalRequestCountMetric) {
            totalRequestCountMetric(Arrays.asList(totalRequestCountMetric));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder totalRequestCountMetric(Consumer<MetricDataQuery.Builder>... totalRequestCountMetric) {
            totalRequestCountMetric(Stream.of(totalRequestCountMetric)
                    .map(c -> MetricDataQuery.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final MonitoredRequestCountMetricDataQueries.Builder getMonitoredRequestCountMetric() {
            return monitoredRequestCountMetric != null ? monitoredRequestCountMetric.toBuilder() : null;
        }

        public final void setMonitoredRequestCountMetric(
                MonitoredRequestCountMetricDataQueries.BuilderImpl monitoredRequestCountMetric) {
            this.monitoredRequestCountMetric = monitoredRequestCountMetric != null ? monitoredRequestCountMetric.build() : null;
        }

        @Override
        public final Builder monitoredRequestCountMetric(MonitoredRequestCountMetricDataQueries monitoredRequestCountMetric) {
            this.monitoredRequestCountMetric = monitoredRequestCountMetric;
            return this;
        }

        public final DependencyConfig.Builder getDependencyConfig() {
            return dependencyConfig != null ? dependencyConfig.toBuilder() : null;
        }

        public final void setDependencyConfig(DependencyConfig.BuilderImpl dependencyConfig) {
            this.dependencyConfig = dependencyConfig != null ? dependencyConfig.build() : null;
        }

        @Override
        public final Builder dependencyConfig(DependencyConfig dependencyConfig) {
            this.dependencyConfig = dependencyConfig;
            return this;
        }

        @Override
        public RequestBasedServiceLevelIndicatorMetricConfig build() {
            return new RequestBasedServiceLevelIndicatorMetricConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
