/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a service entity that is monitored by Application Signals.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceEntity implements SdkPojo, Serializable, ToCopyableBuilder<ServiceEntity.Builder, ServiceEntity> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ServiceEntity::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ServiceEntity::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ENVIRONMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Environment").getter(getter(ServiceEntity::environment)).setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(ServiceEntity::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, NAME_FIELD,
            ENVIRONMENT_FIELD, AWS_ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String name;

    private final String environment;

    private final String awsAccountId;

    private ServiceEntity(BuilderImpl builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.environment = builder.environment;
        this.awsAccountId = builder.awsAccountId;
    }

    /**
     * <p>
     * The type of service, such as "WebService", "Database", "Queue", or "Function".
     * </p>
     * 
     * @return The type of service, such as "WebService", "Database", "Queue", or "Function".
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The name of the service as identified by Application Signals.
     * </p>
     * 
     * @return The name of the service as identified by Application Signals.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The environment where the service is deployed, such as "Production", "Staging", or "Development".
     * </p>
     * 
     * @return The environment where the service is deployed, such as "Production", "Staging", or "Development".
     */
    public final String environment() {
        return environment;
    }

    /**
     * <p>
     * The AWS account ID where the service is deployed.
     * </p>
     * 
     * @return The AWS account ID where the service is deployed.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceEntity)) {
            return false;
        }
        ServiceEntity other = (ServiceEntity) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(name(), other.name())
                && Objects.equals(environment(), other.environment()) && Objects.equals(awsAccountId(), other.awsAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceEntity").add("Type", type()).add("Name", name()).add("Environment", environment())
                .add("AwsAccountId", awsAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Environment", ENVIRONMENT_FIELD);
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceEntity, T> g) {
        return obj -> g.apply((ServiceEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceEntity> {
        /**
         * <p>
         * The type of service, such as "WebService", "Database", "Queue", or "Function".
         * </p>
         * 
         * @param type
         *        The type of service, such as "WebService", "Database", "Queue", or "Function".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The name of the service as identified by Application Signals.
         * </p>
         * 
         * @param name
         *        The name of the service as identified by Application Signals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The environment where the service is deployed, such as "Production", "Staging", or "Development".
         * </p>
         * 
         * @param environment
         *        The environment where the service is deployed, such as "Production", "Staging", or "Development".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(String environment);

        /**
         * <p>
         * The AWS account ID where the service is deployed.
         * </p>
         * 
         * @param awsAccountId
         *        The AWS account ID where the service is deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String name;

        private String environment;

        private String awsAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceEntity model) {
            type(model.type);
            name(model.name);
            environment(model.environment);
            awsAccountId(model.awsAccountId);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEnvironment() {
            return environment;
        }

        public final void setEnvironment(String environment) {
            this.environment = environment;
        }

        @Override
        public final Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        @Override
        public ServiceEntity build() {
            return new ServiceEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
