/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the current state and health information for a service monitored by Application Signals.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceState implements SdkPojo, Serializable, ToCopyableBuilder<ServiceState.Builder, ServiceState> {
    private static final SdkField<List<AttributeFilter>> ATTRIBUTE_FILTERS_FIELD = SdkField
            .<List<AttributeFilter>> builder(MarshallingType.LIST)
            .memberName("AttributeFilters")
            .getter(getter(ServiceState::attributeFilters))
            .setter(setter(Builder::attributeFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> SERVICE_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Service")
            .getter(getter(ServiceState::service))
            .setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<ChangeEvent>> LATEST_CHANGE_EVENTS_FIELD = SdkField
            .<List<ChangeEvent>> builder(MarshallingType.LIST)
            .memberName("LatestChangeEvents")
            .getter(getter(ServiceState::latestChangeEvents))
            .setter(setter(Builder::latestChangeEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestChangeEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChangeEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChangeEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FILTERS_FIELD,
            SERVICE_FIELD, LATEST_CHANGE_EVENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AttributeFilter> attributeFilters;

    private final Map<String, String> service;

    private final List<ChangeEvent> latestChangeEvents;

    private ServiceState(BuilderImpl builder) {
        this.attributeFilters = builder.attributeFilters;
        this.service = builder.service;
        this.latestChangeEvents = builder.latestChangeEvents;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeFilters() {
        return attributeFilters != null && !(attributeFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attribute filters that were applied when retrieving this service state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeFilters} method.
     * </p>
     * 
     * @return The attribute filters that were applied when retrieving this service state.
     */
    public final List<AttributeFilter> attributeFilters() {
        return attributeFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Service property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasService() {
        return service != null && !(service instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The service entity information for this service state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasService} method.
     * </p>
     * 
     * @return The service entity information for this service state.
     */
    public final Map<String, String> service() {
        return service;
    }

    /**
     * For responses, this returns true if the service returned a value for the LatestChangeEvents property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLatestChangeEvents() {
        return latestChangeEvents != null && !(latestChangeEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the most recent change events that may have affected this service, such as deployments or
     * configuration changes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLatestChangeEvents} method.
     * </p>
     * 
     * @return An array of the most recent change events that may have affected this service, such as deployments or
     *         configuration changes.
     */
    public final List<ChangeEvent> latestChangeEvents() {
        return latestChangeEvents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeFilters() ? attributeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasService() ? service() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLatestChangeEvents() ? latestChangeEvents() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceState)) {
            return false;
        }
        ServiceState other = (ServiceState) obj;
        return hasAttributeFilters() == other.hasAttributeFilters()
                && Objects.equals(attributeFilters(), other.attributeFilters()) && hasService() == other.hasService()
                && Objects.equals(service(), other.service()) && hasLatestChangeEvents() == other.hasLatestChangeEvents()
                && Objects.equals(latestChangeEvents(), other.latestChangeEvents());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceState").add("AttributeFilters", hasAttributeFilters() ? attributeFilters() : null)
                .add("Service", hasService() ? service() : null)
                .add("LatestChangeEvents", hasLatestChangeEvents() ? latestChangeEvents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeFilters":
            return Optional.ofNullable(clazz.cast(attributeFilters()));
        case "Service":
            return Optional.ofNullable(clazz.cast(service()));
        case "LatestChangeEvents":
            return Optional.ofNullable(clazz.cast(latestChangeEvents()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttributeFilters", ATTRIBUTE_FILTERS_FIELD);
        map.put("Service", SERVICE_FIELD);
        map.put("LatestChangeEvents", LATEST_CHANGE_EVENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceState, T> g) {
        return obj -> g.apply((ServiceState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceState> {
        /**
         * <p>
         * The attribute filters that were applied when retrieving this service state.
         * </p>
         * 
         * @param attributeFilters
         *        The attribute filters that were applied when retrieving this service state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeFilters(Collection<AttributeFilter> attributeFilters);

        /**
         * <p>
         * The attribute filters that were applied when retrieving this service state.
         * </p>
         * 
         * @param attributeFilters
         *        The attribute filters that were applied when retrieving this service state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeFilters(AttributeFilter... attributeFilters);

        /**
         * <p>
         * The attribute filters that were applied when retrieving this service state.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.AttributeFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.AttributeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.AttributeFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #attributeFilters(List<AttributeFilter>)}.
         * 
         * @param attributeFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.AttributeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeFilters(java.util.Collection<AttributeFilter>)
         */
        Builder attributeFilters(Consumer<AttributeFilter.Builder>... attributeFilters);

        /**
         * <p>
         * The service entity information for this service state.
         * </p>
         * 
         * @param service
         *        The service entity information for this service state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(Map<String, String> service);

        /**
         * <p>
         * An array of the most recent change events that may have affected this service, such as deployments or
         * configuration changes.
         * </p>
         * 
         * @param latestChangeEvents
         *        An array of the most recent change events that may have affected this service, such as deployments or
         *        configuration changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestChangeEvents(Collection<ChangeEvent> latestChangeEvents);

        /**
         * <p>
         * An array of the most recent change events that may have affected this service, such as deployments or
         * configuration changes.
         * </p>
         * 
         * @param latestChangeEvents
         *        An array of the most recent change events that may have affected this service, such as deployments or
         *        configuration changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestChangeEvents(ChangeEvent... latestChangeEvents);

        /**
         * <p>
         * An array of the most recent change events that may have affected this service, such as deployments or
         * configuration changes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.ChangeEvent.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.ChangeEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.ChangeEvent.Builder#build()} is called
         * immediately and its result is passed to {@link #latestChangeEvents(List<ChangeEvent>)}.
         * 
         * @param latestChangeEvents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.ChangeEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestChangeEvents(java.util.Collection<ChangeEvent>)
         */
        Builder latestChangeEvents(Consumer<ChangeEvent.Builder>... latestChangeEvents);
    }

    static final class BuilderImpl implements Builder {
        private List<AttributeFilter> attributeFilters = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> service = DefaultSdkAutoConstructMap.getInstance();

        private List<ChangeEvent> latestChangeEvents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceState model) {
            attributeFilters(model.attributeFilters);
            service(model.service);
            latestChangeEvents(model.latestChangeEvents);
        }

        public final List<AttributeFilter.Builder> getAttributeFilters() {
            List<AttributeFilter.Builder> result = AttributeFiltersCopier.copyToBuilder(this.attributeFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeFilters(Collection<AttributeFilter.BuilderImpl> attributeFilters) {
            this.attributeFilters = AttributeFiltersCopier.copyFromBuilder(attributeFilters);
        }

        @Override
        public final Builder attributeFilters(Collection<AttributeFilter> attributeFilters) {
            this.attributeFilters = AttributeFiltersCopier.copy(attributeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeFilters(AttributeFilter... attributeFilters) {
            attributeFilters(Arrays.asList(attributeFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeFilters(Consumer<AttributeFilter.Builder>... attributeFilters) {
            attributeFilters(Stream.of(attributeFilters).map(c -> AttributeFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getService() {
            if (service instanceof SdkAutoConstructMap) {
                return null;
            }
            return service;
        }

        public final void setService(Map<String, String> service) {
            this.service = AttributesCopier.copy(service);
        }

        @Override
        public final Builder service(Map<String, String> service) {
            this.service = AttributesCopier.copy(service);
            return this;
        }

        public final List<ChangeEvent.Builder> getLatestChangeEvents() {
            List<ChangeEvent.Builder> result = LatestChangeEventsCopier.copyToBuilder(this.latestChangeEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLatestChangeEvents(Collection<ChangeEvent.BuilderImpl> latestChangeEvents) {
            this.latestChangeEvents = LatestChangeEventsCopier.copyFromBuilder(latestChangeEvents);
        }

        @Override
        public final Builder latestChangeEvents(Collection<ChangeEvent> latestChangeEvents) {
            this.latestChangeEvents = LatestChangeEventsCopier.copy(latestChangeEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder latestChangeEvents(ChangeEvent... latestChangeEvents) {
            latestChangeEvents(Arrays.asList(latestChangeEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder latestChangeEvents(Consumer<ChangeEvent.Builder>... latestChangeEvents) {
            latestChangeEvents(Stream.of(latestChangeEvents).map(c -> ChangeEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ServiceState build() {
            return new ServiceState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
