/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the criteria for determining a request match.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GrpcRouteMatch implements SdkPojo, Serializable, ToCopyableBuilder<GrpcRouteMatch.Builder, GrpcRouteMatch> {
    private static final SdkField<List<GrpcRouteMetadata>> METADATA_FIELD = SdkField
            .<List<GrpcRouteMetadata>> builder(MarshallingType.LIST)
            .getter(getter(GrpcRouteMatch::metadata))
            .setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GrpcRouteMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(GrpcRouteMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> METHOD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GrpcRouteMatch::methodName)).setter(setter(Builder::methodName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("methodName").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GrpcRouteMatch::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_FIELD,
            METHOD_NAME_FIELD, SERVICE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<GrpcRouteMetadata> metadata;

    private final String methodName;

    private final String serviceName;

    private GrpcRouteMatch(BuilderImpl builder) {
        this.metadata = builder.metadata;
        this.methodName = builder.methodName;
        this.serviceName = builder.serviceName;
    }

    /**
     * <p>
     * An object that represents the data to match from the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An object that represents the data to match from the request.
     */
    public List<GrpcRouteMetadata> metadata() {
        return metadata;
    }

    /**
     * <p>
     * The method name to match from the request. If you specify a name, you must also specify a
     * <code>serviceName</code>.
     * </p>
     * 
     * @return The method name to match from the request. If you specify a name, you must also specify a
     *         <code>serviceName</code>.
     */
    public String methodName() {
        return methodName;
    }

    /**
     * <p>
     * The fully qualified domain name for the service to match from the request.
     * </p>
     * 
     * @return The fully qualified domain name for the service to match from the request.
     */
    public String serviceName() {
        return serviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(methodName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrpcRouteMatch)) {
            return false;
        }
        GrpcRouteMatch other = (GrpcRouteMatch) obj;
        return Objects.equals(metadata(), other.metadata()) && Objects.equals(methodName(), other.methodName())
                && Objects.equals(serviceName(), other.serviceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GrpcRouteMatch").add("Metadata", metadata()).add("MethodName", methodName())
                .add("ServiceName", serviceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "methodName":
            return Optional.ofNullable(clazz.cast(methodName()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrpcRouteMatch, T> g) {
        return obj -> g.apply((GrpcRouteMatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GrpcRouteMatch> {
        /**
         * <p>
         * An object that represents the data to match from the request.
         * </p>
         * 
         * @param metadata
         *        An object that represents the data to match from the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Collection<GrpcRouteMetadata> metadata);

        /**
         * <p>
         * An object that represents the data to match from the request.
         * </p>
         * 
         * @param metadata
         *        An object that represents the data to match from the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(GrpcRouteMetadata... metadata);

        /**
         * <p>
         * An object that represents the data to match from the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GrpcRouteMetadata>.Builder} avoiding the
         * need to create one manually via {@link List<GrpcRouteMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GrpcRouteMetadata>.Builder#build()} is called immediately
         * and its result is passed to {@link #metadata(List<GrpcRouteMetadata>)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link List<GrpcRouteMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(List<GrpcRouteMetadata>)
         */
        Builder metadata(Consumer<GrpcRouteMetadata.Builder>... metadata);

        /**
         * <p>
         * The method name to match from the request. If you specify a name, you must also specify a
         * <code>serviceName</code>.
         * </p>
         * 
         * @param methodName
         *        The method name to match from the request. If you specify a name, you must also specify a
         *        <code>serviceName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder methodName(String methodName);

        /**
         * <p>
         * The fully qualified domain name for the service to match from the request.
         * </p>
         * 
         * @param serviceName
         *        The fully qualified domain name for the service to match from the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);
    }

    static final class BuilderImpl implements Builder {
        private List<GrpcRouteMetadata> metadata = DefaultSdkAutoConstructList.getInstance();

        private String methodName;

        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(GrpcRouteMatch model) {
            metadata(model.metadata);
            methodName(model.methodName);
            serviceName(model.serviceName);
        }

        public final Collection<GrpcRouteMetadata.Builder> getMetadata() {
            return metadata != null ? metadata.stream().map(GrpcRouteMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metadata(Collection<GrpcRouteMetadata> metadata) {
            this.metadata = GrpcRouteMetadataListCopier.copy(metadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadata(GrpcRouteMetadata... metadata) {
            metadata(Arrays.asList(metadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadata(Consumer<GrpcRouteMetadata.Builder>... metadata) {
            metadata(Stream.of(metadata).map(c -> GrpcRouteMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMetadata(Collection<GrpcRouteMetadata.BuilderImpl> metadata) {
            this.metadata = GrpcRouteMetadataListCopier.copyFromBuilder(metadata);
        }

        public final String getMethodName() {
            return methodName;
        }

        @Override
        public final Builder methodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public final void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public final String getServiceName() {
            return serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public GrpcRouteMatch build() {
            return new GrpcRouteMatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
