/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the requirements for a route to match HTTP requests for a virtual router.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpRouteMatch implements SdkPojo, Serializable, ToCopyableBuilder<HttpRouteMatch.Builder, HttpRouteMatch> {
    private static final SdkField<List<HttpRouteHeader>> HEADERS_FIELD = SdkField
            .<List<HttpRouteHeader>> builder(MarshallingType.LIST)
            .getter(getter(HttpRouteMatch::headers))
            .setter(setter(Builder::headers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HttpRouteHeader> builder(MarshallingType.SDK_POJO)
                                            .constructor(HttpRouteHeader::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HttpRouteMatch::methodAsString)).setter(setter(Builder::method))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("method").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HttpRouteMatch::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()).build();

    private static final SdkField<String> SCHEME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HttpRouteMatch::schemeAsString)).setter(setter(Builder::scheme))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheme").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADERS_FIELD, METHOD_FIELD,
            PREFIX_FIELD, SCHEME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<HttpRouteHeader> headers;

    private final String method;

    private final String prefix;

    private final String scheme;

    private HttpRouteMatch(BuilderImpl builder) {
        this.headers = builder.headers;
        this.method = builder.method;
        this.prefix = builder.prefix;
        this.scheme = builder.scheme;
    }

    /**
     * <p>
     * An object that represents the client request headers to match on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An object that represents the client request headers to match on.
     */
    public List<HttpRouteHeader> headers() {
        return headers;
    }

    /**
     * <p>
     * The client request method to match on. Specify only one.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #method} will
     * return {@link HttpMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #methodAsString}.
     * </p>
     * 
     * @return The client request method to match on. Specify only one.
     * @see HttpMethod
     */
    public HttpMethod method() {
        return HttpMethod.fromValue(method);
    }

    /**
     * <p>
     * The client request method to match on. Specify only one.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #method} will
     * return {@link HttpMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #methodAsString}.
     * </p>
     * 
     * @return The client request method to match on. Specify only one.
     * @see HttpMethod
     */
    public String methodAsString() {
        return method;
    }

    /**
     * <p>
     * Specifies the path to match requests with. This parameter must always start with <code>/</code>, which by itself
     * matches all requests to the virtual service name. You can also match for path-based routing of requests. For
     * example, if your virtual service name is <code>my-service.local</code> and you want the route to match requests
     * to <code>my-service.local/metrics</code>, your prefix should be <code>/metrics</code>.
     * </p>
     * 
     * @return Specifies the path to match requests with. This parameter must always start with <code>/</code>, which by
     *         itself matches all requests to the virtual service name. You can also match for path-based routing of
     *         requests. For example, if your virtual service name is <code>my-service.local</code> and you want the
     *         route to match requests to <code>my-service.local/metrics</code>, your prefix should be
     *         <code>/metrics</code>.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * <p>
     * The client request scheme to match on. Specify only one.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scheme} will
     * return {@link HttpScheme#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #schemeAsString}.
     * </p>
     * 
     * @return The client request scheme to match on. Specify only one.
     * @see HttpScheme
     */
    public HttpScheme scheme() {
        return HttpScheme.fromValue(scheme);
    }

    /**
     * <p>
     * The client request scheme to match on. Specify only one.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scheme} will
     * return {@link HttpScheme#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #schemeAsString}.
     * </p>
     * 
     * @return The client request scheme to match on. Specify only one.
     * @see HttpScheme
     */
    public String schemeAsString() {
        return scheme;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(headers());
        hashCode = 31 * hashCode + Objects.hashCode(methodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(schemeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpRouteMatch)) {
            return false;
        }
        HttpRouteMatch other = (HttpRouteMatch) obj;
        return Objects.equals(headers(), other.headers()) && Objects.equals(methodAsString(), other.methodAsString())
                && Objects.equals(prefix(), other.prefix()) && Objects.equals(schemeAsString(), other.schemeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HttpRouteMatch").add("Headers", headers()).add("Method", methodAsString())
                .add("Prefix", prefix()).add("Scheme", schemeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "headers":
            return Optional.ofNullable(clazz.cast(headers()));
        case "method":
            return Optional.ofNullable(clazz.cast(methodAsString()));
        case "prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "scheme":
            return Optional.ofNullable(clazz.cast(schemeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpRouteMatch, T> g) {
        return obj -> g.apply((HttpRouteMatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpRouteMatch> {
        /**
         * <p>
         * An object that represents the client request headers to match on.
         * </p>
         * 
         * @param headers
         *        An object that represents the client request headers to match on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(Collection<HttpRouteHeader> headers);

        /**
         * <p>
         * An object that represents the client request headers to match on.
         * </p>
         * 
         * @param headers
         *        An object that represents the client request headers to match on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(HttpRouteHeader... headers);

        /**
         * <p>
         * An object that represents the client request headers to match on.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HttpRouteHeader>.Builder} avoiding the need
         * to create one manually via {@link List<HttpRouteHeader>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HttpRouteHeader>.Builder#build()} is called immediately and
         * its result is passed to {@link #headers(List<HttpRouteHeader>)}.
         * 
         * @param headers
         *        a consumer that will call methods on {@link List<HttpRouteHeader>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headers(List<HttpRouteHeader>)
         */
        Builder headers(Consumer<HttpRouteHeader.Builder>... headers);

        /**
         * <p>
         * The client request method to match on. Specify only one.
         * </p>
         * 
         * @param method
         *        The client request method to match on. Specify only one.
         * @see HttpMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpMethod
         */
        Builder method(String method);

        /**
         * <p>
         * The client request method to match on. Specify only one.
         * </p>
         * 
         * @param method
         *        The client request method to match on. Specify only one.
         * @see HttpMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpMethod
         */
        Builder method(HttpMethod method);

        /**
         * <p>
         * Specifies the path to match requests with. This parameter must always start with <code>/</code>, which by
         * itself matches all requests to the virtual service name. You can also match for path-based routing of
         * requests. For example, if your virtual service name is <code>my-service.local</code> and you want the route
         * to match requests to <code>my-service.local/metrics</code>, your prefix should be <code>/metrics</code>.
         * </p>
         * 
         * @param prefix
         *        Specifies the path to match requests with. This parameter must always start with <code>/</code>, which
         *        by itself matches all requests to the virtual service name. You can also match for path-based routing
         *        of requests. For example, if your virtual service name is <code>my-service.local</code> and you want
         *        the route to match requests to <code>my-service.local/metrics</code>, your prefix should be
         *        <code>/metrics</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * The client request scheme to match on. Specify only one.
         * </p>
         * 
         * @param scheme
         *        The client request scheme to match on. Specify only one.
         * @see HttpScheme
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpScheme
         */
        Builder scheme(String scheme);

        /**
         * <p>
         * The client request scheme to match on. Specify only one.
         * </p>
         * 
         * @param scheme
         *        The client request scheme to match on. Specify only one.
         * @see HttpScheme
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpScheme
         */
        Builder scheme(HttpScheme scheme);
    }

    static final class BuilderImpl implements Builder {
        private List<HttpRouteHeader> headers = DefaultSdkAutoConstructList.getInstance();

        private String method;

        private String prefix;

        private String scheme;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpRouteMatch model) {
            headers(model.headers);
            method(model.method);
            prefix(model.prefix);
            scheme(model.scheme);
        }

        public final Collection<HttpRouteHeader.Builder> getHeaders() {
            return headers != null ? headers.stream().map(HttpRouteHeader::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder headers(Collection<HttpRouteHeader> headers) {
            this.headers = HttpRouteHeadersCopier.copy(headers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(HttpRouteHeader... headers) {
            headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(Consumer<HttpRouteHeader.Builder>... headers) {
            headers(Stream.of(headers).map(c -> HttpRouteHeader.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHeaders(Collection<HttpRouteHeader.BuilderImpl> headers) {
            this.headers = HttpRouteHeadersCopier.copyFromBuilder(headers);
        }

        public final String getMethodAsString() {
            return method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        @Override
        public final Builder method(HttpMethod method) {
            this.method(method == null ? null : method.toString());
            return this;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getSchemeAsString() {
            return scheme;
        }

        @Override
        public final Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        @Override
        public final Builder scheme(HttpScheme scheme) {
            this.scheme(scheme == null ? null : scheme.toString());
            return this;
        }

        public final void setScheme(String scheme) {
            this.scheme = scheme;
        }

        @Override
        public HttpRouteMatch build() {
            return new HttpRouteMatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
