/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a retry policy. Specify at least one value for at least one of the types of
 * <code>RetryEvents</code>, a value for <code>maxRetries</code>, and a value for <code>perRetryTimeout</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpRetryPolicy implements SdkPojo, Serializable, ToCopyableBuilder<HttpRetryPolicy.Builder, HttpRetryPolicy> {
    private static final SdkField<List<String>> HTTP_RETRY_EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(HttpRetryPolicy::httpRetryEvents))
            .setter(setter(Builder::httpRetryEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpRetryEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> MAX_RETRIES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(HttpRetryPolicy::maxRetries)).setter(setter(Builder::maxRetries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRetries").build()).build();

    private static final SdkField<Duration> PER_RETRY_TIMEOUT_FIELD = SdkField.<Duration> builder(MarshallingType.SDK_POJO)
            .getter(getter(HttpRetryPolicy::perRetryTimeout)).setter(setter(Builder::perRetryTimeout))
            .constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("perRetryTimeout").build()).build();

    private static final SdkField<List<String>> TCP_RETRY_EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(HttpRetryPolicy::tcpRetryEventsAsStrings))
            .setter(setter(Builder::tcpRetryEventsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tcpRetryEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_RETRY_EVENTS_FIELD,
            MAX_RETRIES_FIELD, PER_RETRY_TIMEOUT_FIELD, TCP_RETRY_EVENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> httpRetryEvents;

    private final Long maxRetries;

    private final Duration perRetryTimeout;

    private final List<String> tcpRetryEvents;

    private HttpRetryPolicy(BuilderImpl builder) {
        this.httpRetryEvents = builder.httpRetryEvents;
        this.maxRetries = builder.maxRetries;
        this.perRetryTimeout = builder.perRetryTimeout;
        this.tcpRetryEvents = builder.tcpRetryEvents;
    }

    /**
     * <p>
     * Specify at least one of the following values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>server-error</b> – HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>gateway-error</b> – HTTP status codes 502, 503, and 504
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>client-error</b> – HTTP status code 409
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>stream-error</b> – Retry on refused stream
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specify at least one of the following values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>server-error</b> – HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>gateway-error</b> – HTTP status codes 502, 503, and 504
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>client-error</b> – HTTP status code 409
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>stream-error</b> – Retry on refused stream
     *         </p>
     *         </li>
     */
    public List<String> httpRetryEvents() {
        return httpRetryEvents;
    }

    /**
     * <p>
     * The maximum number of retry attempts.
     * </p>
     * 
     * @return The maximum number of retry attempts.
     */
    public Long maxRetries() {
        return maxRetries;
    }

    /**
     * <p>
     * An object that represents a duration of time.
     * </p>
     * 
     * @return An object that represents a duration of time.
     */
    public Duration perRetryTimeout() {
        return perRetryTimeout;
    }

    /**
     * <p>
     * Specify a valid value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specify a valid value.
     */
    public List<TcpRetryPolicyEvent> tcpRetryEvents() {
        return TcpRetryPolicyEventsCopier.copyStringToEnum(tcpRetryEvents);
    }

    /**
     * <p>
     * Specify a valid value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specify a valid value.
     */
    public List<String> tcpRetryEventsAsStrings() {
        return tcpRetryEvents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(httpRetryEvents());
        hashCode = 31 * hashCode + Objects.hashCode(maxRetries());
        hashCode = 31 * hashCode + Objects.hashCode(perRetryTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(tcpRetryEventsAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpRetryPolicy)) {
            return false;
        }
        HttpRetryPolicy other = (HttpRetryPolicy) obj;
        return Objects.equals(httpRetryEvents(), other.httpRetryEvents()) && Objects.equals(maxRetries(), other.maxRetries())
                && Objects.equals(perRetryTimeout(), other.perRetryTimeout())
                && Objects.equals(tcpRetryEventsAsStrings(), other.tcpRetryEventsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HttpRetryPolicy").add("HttpRetryEvents", httpRetryEvents()).add("MaxRetries", maxRetries())
                .add("PerRetryTimeout", perRetryTimeout()).add("TcpRetryEvents", tcpRetryEventsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "httpRetryEvents":
            return Optional.ofNullable(clazz.cast(httpRetryEvents()));
        case "maxRetries":
            return Optional.ofNullable(clazz.cast(maxRetries()));
        case "perRetryTimeout":
            return Optional.ofNullable(clazz.cast(perRetryTimeout()));
        case "tcpRetryEvents":
            return Optional.ofNullable(clazz.cast(tcpRetryEventsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpRetryPolicy, T> g) {
        return obj -> g.apply((HttpRetryPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpRetryPolicy> {
        /**
         * <p>
         * Specify at least one of the following values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>server-error</b> – HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>gateway-error</b> – HTTP status codes 502, 503, and 504
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>client-error</b> – HTTP status code 409
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>stream-error</b> – Retry on refused stream
         * </p>
         * </li>
         * </ul>
         * 
         * @param httpRetryEvents
         *        Specify at least one of the following values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>server-error</b> – HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>gateway-error</b> – HTTP status codes 502, 503, and 504
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>client-error</b> – HTTP status code 409
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>stream-error</b> – Retry on refused stream
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpRetryEvents(Collection<String> httpRetryEvents);

        /**
         * <p>
         * Specify at least one of the following values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>server-error</b> – HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>gateway-error</b> – HTTP status codes 502, 503, and 504
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>client-error</b> – HTTP status code 409
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>stream-error</b> – Retry on refused stream
         * </p>
         * </li>
         * </ul>
         * 
         * @param httpRetryEvents
         *        Specify at least one of the following values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>server-error</b> – HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>gateway-error</b> – HTTP status codes 502, 503, and 504
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>client-error</b> – HTTP status code 409
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>stream-error</b> – Retry on refused stream
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpRetryEvents(String... httpRetryEvents);

        /**
         * <p>
         * The maximum number of retry attempts.
         * </p>
         * 
         * @param maxRetries
         *        The maximum number of retry attempts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRetries(Long maxRetries);

        /**
         * <p>
         * An object that represents a duration of time.
         * </p>
         * 
         * @param perRetryTimeout
         *        An object that represents a duration of time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder perRetryTimeout(Duration perRetryTimeout);

        /**
         * <p>
         * An object that represents a duration of time.
         * </p>
         * This is a convenience that creates an instance of the {@link Duration.Builder} avoiding the need to create
         * one manually via {@link Duration#builder()}.
         *
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #perRetryTimeout(Duration)}.
         * 
         * @param perRetryTimeout
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #perRetryTimeout(Duration)
         */
        default Builder perRetryTimeout(Consumer<Duration.Builder> perRetryTimeout) {
            return perRetryTimeout(Duration.builder().applyMutation(perRetryTimeout).build());
        }

        /**
         * <p>
         * Specify a valid value.
         * </p>
         * 
         * @param tcpRetryEvents
         *        Specify a valid value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tcpRetryEventsWithStrings(Collection<String> tcpRetryEvents);

        /**
         * <p>
         * Specify a valid value.
         * </p>
         * 
         * @param tcpRetryEvents
         *        Specify a valid value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tcpRetryEventsWithStrings(String... tcpRetryEvents);

        /**
         * <p>
         * Specify a valid value.
         * </p>
         * 
         * @param tcpRetryEvents
         *        Specify a valid value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tcpRetryEvents(Collection<TcpRetryPolicyEvent> tcpRetryEvents);

        /**
         * <p>
         * Specify a valid value.
         * </p>
         * 
         * @param tcpRetryEvents
         *        Specify a valid value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tcpRetryEvents(TcpRetryPolicyEvent... tcpRetryEvents);
    }

    static final class BuilderImpl implements Builder {
        private List<String> httpRetryEvents = DefaultSdkAutoConstructList.getInstance();

        private Long maxRetries;

        private Duration perRetryTimeout;

        private List<String> tcpRetryEvents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HttpRetryPolicy model) {
            httpRetryEvents(model.httpRetryEvents);
            maxRetries(model.maxRetries);
            perRetryTimeout(model.perRetryTimeout);
            tcpRetryEventsWithStrings(model.tcpRetryEvents);
        }

        public final Collection<String> getHttpRetryEvents() {
            return httpRetryEvents;
        }

        @Override
        public final Builder httpRetryEvents(Collection<String> httpRetryEvents) {
            this.httpRetryEvents = HttpRetryPolicyEventsCopier.copy(httpRetryEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder httpRetryEvents(String... httpRetryEvents) {
            httpRetryEvents(Arrays.asList(httpRetryEvents));
            return this;
        }

        public final void setHttpRetryEvents(Collection<String> httpRetryEvents) {
            this.httpRetryEvents = HttpRetryPolicyEventsCopier.copy(httpRetryEvents);
        }

        public final Long getMaxRetries() {
            return maxRetries;
        }

        @Override
        public final Builder maxRetries(Long maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public final void setMaxRetries(Long maxRetries) {
            this.maxRetries = maxRetries;
        }

        public final Duration.Builder getPerRetryTimeout() {
            return perRetryTimeout != null ? perRetryTimeout.toBuilder() : null;
        }

        @Override
        public final Builder perRetryTimeout(Duration perRetryTimeout) {
            this.perRetryTimeout = perRetryTimeout;
            return this;
        }

        public final void setPerRetryTimeout(Duration.BuilderImpl perRetryTimeout) {
            this.perRetryTimeout = perRetryTimeout != null ? perRetryTimeout.build() : null;
        }

        public final Collection<String> getTcpRetryEventsAsStrings() {
            return tcpRetryEvents;
        }

        @Override
        public final Builder tcpRetryEventsWithStrings(Collection<String> tcpRetryEvents) {
            this.tcpRetryEvents = TcpRetryPolicyEventsCopier.copy(tcpRetryEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tcpRetryEventsWithStrings(String... tcpRetryEvents) {
            tcpRetryEventsWithStrings(Arrays.asList(tcpRetryEvents));
            return this;
        }

        @Override
        public final Builder tcpRetryEvents(Collection<TcpRetryPolicyEvent> tcpRetryEvents) {
            this.tcpRetryEvents = TcpRetryPolicyEventsCopier.copyEnumToString(tcpRetryEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tcpRetryEvents(TcpRetryPolicyEvent... tcpRetryEvents) {
            tcpRetryEvents(Arrays.asList(tcpRetryEvents));
            return this;
        }

        public final void setTcpRetryEventsWithStrings(Collection<String> tcpRetryEvents) {
            this.tcpRetryEvents = TcpRetryPolicyEventsCopier.copy(tcpRetryEvents);
        }

        @Override
        public HttpRetryPolicy build() {
            return new HttpRetryPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
