/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a route returned by a describe operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteData implements SdkPojo, Serializable, ToCopyableBuilder<RouteData.Builder, RouteData> {
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RouteData::meshName)).setter(setter(Builder::meshName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meshName").build()).build();

    private static final SdkField<ResourceMetadata> METADATA_FIELD = SdkField
            .<ResourceMetadata> builder(MarshallingType.SDK_POJO).getter(getter(RouteData::metadata))
            .setter(setter(Builder::metadata)).constructor(ResourceMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<String> ROUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RouteData::routeName)).setter(setter(Builder::routeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeName").build()).build();

    private static final SdkField<RouteSpec> SPEC_FIELD = SdkField.<RouteSpec> builder(MarshallingType.SDK_POJO)
            .getter(getter(RouteData::spec)).setter(setter(Builder::spec)).constructor(RouteSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()).build();

    private static final SdkField<RouteStatus> STATUS_FIELD = SdkField.<RouteStatus> builder(MarshallingType.SDK_POJO)
            .getter(getter(RouteData::status)).setter(setter(Builder::status)).constructor(RouteStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> VIRTUAL_ROUTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RouteData::virtualRouterName)).setter(setter(Builder::virtualRouterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualRouterName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESH_NAME_FIELD,
            METADATA_FIELD, ROUTE_NAME_FIELD, SPEC_FIELD, STATUS_FIELD, VIRTUAL_ROUTER_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String meshName;

    private final ResourceMetadata metadata;

    private final String routeName;

    private final RouteSpec spec;

    private final RouteStatus status;

    private final String virtualRouterName;

    private RouteData(BuilderImpl builder) {
        this.meshName = builder.meshName;
        this.metadata = builder.metadata;
        this.routeName = builder.routeName;
        this.spec = builder.spec;
        this.status = builder.status;
        this.virtualRouterName = builder.virtualRouterName;
    }

    /**
     * <p>
     * The name of the service mesh that the route resides in.
     * </p>
     * 
     * @return The name of the service mesh that the route resides in.
     */
    public String meshName() {
        return meshName;
    }

    /**
     * <p>
     * The associated metadata for the route.
     * </p>
     * 
     * @return The associated metadata for the route.
     */
    public ResourceMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * The name of the route.
     * </p>
     * 
     * @return The name of the route.
     */
    public String routeName() {
        return routeName;
    }

    /**
     * <p>
     * The specifications of the route.
     * </p>
     * 
     * @return The specifications of the route.
     */
    public RouteSpec spec() {
        return spec;
    }

    /**
     * <p>
     * The status of the route.
     * </p>
     * 
     * @return The status of the route.
     */
    public RouteStatus status() {
        return status;
    }

    /**
     * <p>
     * The virtual router that the route is associated with.
     * </p>
     * 
     * @return The virtual router that the route is associated with.
     */
    public String virtualRouterName() {
        return virtualRouterName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(meshName());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(routeName());
        hashCode = 31 * hashCode + Objects.hashCode(spec());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(virtualRouterName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteData)) {
            return false;
        }
        RouteData other = (RouteData) obj;
        return Objects.equals(meshName(), other.meshName()) && Objects.equals(metadata(), other.metadata())
                && Objects.equals(routeName(), other.routeName()) && Objects.equals(spec(), other.spec())
                && Objects.equals(status(), other.status()) && Objects.equals(virtualRouterName(), other.virtualRouterName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RouteData").add("MeshName", meshName()).add("Metadata", metadata())
                .add("RouteName", routeName()).add("Spec", spec()).add("Status", status())
                .add("VirtualRouterName", virtualRouterName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "meshName":
            return Optional.ofNullable(clazz.cast(meshName()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "routeName":
            return Optional.ofNullable(clazz.cast(routeName()));
        case "spec":
            return Optional.ofNullable(clazz.cast(spec()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "virtualRouterName":
            return Optional.ofNullable(clazz.cast(virtualRouterName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RouteData, T> g) {
        return obj -> g.apply((RouteData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteData> {
        /**
         * <p>
         * The name of the service mesh that the route resides in.
         * </p>
         * 
         * @param meshName
         *        The name of the service mesh that the route resides in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshName(String meshName);

        /**
         * <p>
         * The associated metadata for the route.
         * </p>
         * 
         * @param metadata
         *        The associated metadata for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(ResourceMetadata metadata);

        /**
         * <p>
         * The associated metadata for the route.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceMetadata.Builder} avoiding the need to
         * create one manually via {@link ResourceMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #metadata(ResourceMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link ResourceMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(ResourceMetadata)
         */
        default Builder metadata(Consumer<ResourceMetadata.Builder> metadata) {
            return metadata(ResourceMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * The name of the route.
         * </p>
         * 
         * @param routeName
         *        The name of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeName(String routeName);

        /**
         * <p>
         * The specifications of the route.
         * </p>
         * 
         * @param spec
         *        The specifications of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spec(RouteSpec spec);

        /**
         * <p>
         * The specifications of the route.
         * </p>
         * This is a convenience that creates an instance of the {@link RouteSpec.Builder} avoiding the need to create
         * one manually via {@link RouteSpec#builder()}.
         *
         * When the {@link Consumer} completes, {@link RouteSpec.Builder#build()} is called immediately and its result
         * is passed to {@link #spec(RouteSpec)}.
         * 
         * @param spec
         *        a consumer that will call methods on {@link RouteSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spec(RouteSpec)
         */
        default Builder spec(Consumer<RouteSpec.Builder> spec) {
            return spec(RouteSpec.builder().applyMutation(spec).build());
        }

        /**
         * <p>
         * The status of the route.
         * </p>
         * 
         * @param status
         *        The status of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(RouteStatus status);

        /**
         * <p>
         * The status of the route.
         * </p>
         * This is a convenience that creates an instance of the {@link RouteStatus.Builder} avoiding the need to create
         * one manually via {@link RouteStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link RouteStatus.Builder#build()} is called immediately and its result
         * is passed to {@link #status(RouteStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link RouteStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(RouteStatus)
         */
        default Builder status(Consumer<RouteStatus.Builder> status) {
            return status(RouteStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The virtual router that the route is associated with.
         * </p>
         * 
         * @param virtualRouterName
         *        The virtual router that the route is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualRouterName(String virtualRouterName);
    }

    static final class BuilderImpl implements Builder {
        private String meshName;

        private ResourceMetadata metadata;

        private String routeName;

        private RouteSpec spec;

        private RouteStatus status;

        private String virtualRouterName;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteData model) {
            meshName(model.meshName);
            metadata(model.metadata);
            routeName(model.routeName);
            spec(model.spec);
            status(model.status);
            virtualRouterName(model.virtualRouterName);
        }

        public final String getMeshName() {
            return meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final ResourceMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        @Override
        public final Builder metadata(ResourceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(ResourceMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        public final String getRouteName() {
            return routeName;
        }

        @Override
        public final Builder routeName(String routeName) {
            this.routeName = routeName;
            return this;
        }

        public final void setRouteName(String routeName) {
            this.routeName = routeName;
        }

        public final RouteSpec.Builder getSpec() {
            return spec != null ? spec.toBuilder() : null;
        }

        @Override
        public final Builder spec(RouteSpec spec) {
            this.spec = spec;
            return this;
        }

        public final void setSpec(RouteSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        public final RouteStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        @Override
        public final Builder status(RouteStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(RouteStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final String getVirtualRouterName() {
            return virtualRouterName;
        }

        @Override
        public final Builder virtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
            return this;
        }

        public final void setVirtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
        }

        @Override
        public RouteData build() {
            return new RouteData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
