/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a virtual node returned by a describe operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualNodeData implements SdkPojo, Serializable, ToCopyableBuilder<VirtualNodeData.Builder, VirtualNodeData> {
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VirtualNodeData::meshName)).setter(setter(Builder::meshName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meshName").build()).build();

    private static final SdkField<ResourceMetadata> METADATA_FIELD = SdkField
            .<ResourceMetadata> builder(MarshallingType.SDK_POJO).getter(getter(VirtualNodeData::metadata))
            .setter(setter(Builder::metadata)).constructor(ResourceMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<VirtualNodeSpec> SPEC_FIELD = SdkField.<VirtualNodeSpec> builder(MarshallingType.SDK_POJO)
            .getter(getter(VirtualNodeData::spec)).setter(setter(Builder::spec)).constructor(VirtualNodeSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()).build();

    private static final SdkField<VirtualNodeStatus> STATUS_FIELD = SdkField
            .<VirtualNodeStatus> builder(MarshallingType.SDK_POJO).getter(getter(VirtualNodeData::status))
            .setter(setter(Builder::status)).constructor(VirtualNodeStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> VIRTUAL_NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VirtualNodeData::virtualNodeName)).setter(setter(Builder::virtualNodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualNodeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESH_NAME_FIELD,
            METADATA_FIELD, SPEC_FIELD, STATUS_FIELD, VIRTUAL_NODE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String meshName;

    private final ResourceMetadata metadata;

    private final VirtualNodeSpec spec;

    private final VirtualNodeStatus status;

    private final String virtualNodeName;

    private VirtualNodeData(BuilderImpl builder) {
        this.meshName = builder.meshName;
        this.metadata = builder.metadata;
        this.spec = builder.spec;
        this.status = builder.status;
        this.virtualNodeName = builder.virtualNodeName;
    }

    /**
     * <p>
     * The name of the service mesh that the virtual node resides in.
     * </p>
     * 
     * @return The name of the service mesh that the virtual node resides in.
     */
    public String meshName() {
        return meshName;
    }

    /**
     * <p>
     * The associated metadata for the virtual node.
     * </p>
     * 
     * @return The associated metadata for the virtual node.
     */
    public ResourceMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * The specifications of the virtual node.
     * </p>
     * 
     * @return The specifications of the virtual node.
     */
    public VirtualNodeSpec spec() {
        return spec;
    }

    /**
     * <p>
     * The current status for the virtual node.
     * </p>
     * 
     * @return The current status for the virtual node.
     */
    public VirtualNodeStatus status() {
        return status;
    }

    /**
     * <p>
     * The name of the virtual node.
     * </p>
     * 
     * @return The name of the virtual node.
     */
    public String virtualNodeName() {
        return virtualNodeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(meshName());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(spec());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(virtualNodeName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualNodeData)) {
            return false;
        }
        VirtualNodeData other = (VirtualNodeData) obj;
        return Objects.equals(meshName(), other.meshName()) && Objects.equals(metadata(), other.metadata())
                && Objects.equals(spec(), other.spec()) && Objects.equals(status(), other.status())
                && Objects.equals(virtualNodeName(), other.virtualNodeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VirtualNodeData").add("MeshName", meshName()).add("Metadata", metadata()).add("Spec", spec())
                .add("Status", status()).add("VirtualNodeName", virtualNodeName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "meshName":
            return Optional.ofNullable(clazz.cast(meshName()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "spec":
            return Optional.ofNullable(clazz.cast(spec()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "virtualNodeName":
            return Optional.ofNullable(clazz.cast(virtualNodeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualNodeData, T> g) {
        return obj -> g.apply((VirtualNodeData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualNodeData> {
        /**
         * <p>
         * The name of the service mesh that the virtual node resides in.
         * </p>
         * 
         * @param meshName
         *        The name of the service mesh that the virtual node resides in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshName(String meshName);

        /**
         * <p>
         * The associated metadata for the virtual node.
         * </p>
         * 
         * @param metadata
         *        The associated metadata for the virtual node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(ResourceMetadata metadata);

        /**
         * <p>
         * The associated metadata for the virtual node.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceMetadata.Builder} avoiding the need to
         * create one manually via {@link ResourceMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #metadata(ResourceMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link ResourceMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(ResourceMetadata)
         */
        default Builder metadata(Consumer<ResourceMetadata.Builder> metadata) {
            return metadata(ResourceMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * The specifications of the virtual node.
         * </p>
         * 
         * @param spec
         *        The specifications of the virtual node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spec(VirtualNodeSpec spec);

        /**
         * <p>
         * The specifications of the virtual node.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualNodeSpec.Builder} avoiding the need to
         * create one manually via {@link VirtualNodeSpec#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualNodeSpec.Builder#build()} is called immediately and its
         * result is passed to {@link #spec(VirtualNodeSpec)}.
         * 
         * @param spec
         *        a consumer that will call methods on {@link VirtualNodeSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spec(VirtualNodeSpec)
         */
        default Builder spec(Consumer<VirtualNodeSpec.Builder> spec) {
            return spec(VirtualNodeSpec.builder().applyMutation(spec).build());
        }

        /**
         * <p>
         * The current status for the virtual node.
         * </p>
         * 
         * @param status
         *        The current status for the virtual node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(VirtualNodeStatus status);

        /**
         * <p>
         * The current status for the virtual node.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualNodeStatus.Builder} avoiding the need to
         * create one manually via {@link VirtualNodeStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualNodeStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(VirtualNodeStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link VirtualNodeStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(VirtualNodeStatus)
         */
        default Builder status(Consumer<VirtualNodeStatus.Builder> status) {
            return status(VirtualNodeStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The name of the virtual node.
         * </p>
         * 
         * @param virtualNodeName
         *        The name of the virtual node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualNodeName(String virtualNodeName);
    }

    static final class BuilderImpl implements Builder {
        private String meshName;

        private ResourceMetadata metadata;

        private VirtualNodeSpec spec;

        private VirtualNodeStatus status;

        private String virtualNodeName;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualNodeData model) {
            meshName(model.meshName);
            metadata(model.metadata);
            spec(model.spec);
            status(model.status);
            virtualNodeName(model.virtualNodeName);
        }

        public final String getMeshName() {
            return meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final ResourceMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        @Override
        public final Builder metadata(ResourceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(ResourceMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        public final VirtualNodeSpec.Builder getSpec() {
            return spec != null ? spec.toBuilder() : null;
        }

        @Override
        public final Builder spec(VirtualNodeSpec spec) {
            this.spec = spec;
            return this;
        }

        public final void setSpec(VirtualNodeSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        public final VirtualNodeStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        @Override
        public final Builder status(VirtualNodeStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(VirtualNodeStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final String getVirtualNodeName() {
            return virtualNodeName;
        }

        @Override
        public final Builder virtualNodeName(String virtualNodeName) {
            this.virtualNodeName = virtualNodeName;
            return this;
        }

        public final void setVirtualNodeName(String virtualNodeName) {
            this.virtualNodeName = virtualNodeName;
        }

        @Override
        public VirtualNodeData build() {
            return new VirtualNodeData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
