/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a virtual router returned by a describe operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualRouterData implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualRouterData.Builder, VirtualRouterData> {
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VirtualRouterData::meshName)).setter(setter(Builder::meshName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meshName").build()).build();

    private static final SdkField<ResourceMetadata> METADATA_FIELD = SdkField
            .<ResourceMetadata> builder(MarshallingType.SDK_POJO).getter(getter(VirtualRouterData::metadata))
            .setter(setter(Builder::metadata)).constructor(ResourceMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<VirtualRouterSpec> SPEC_FIELD = SdkField.<VirtualRouterSpec> builder(MarshallingType.SDK_POJO)
            .getter(getter(VirtualRouterData::spec)).setter(setter(Builder::spec)).constructor(VirtualRouterSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()).build();

    private static final SdkField<VirtualRouterStatus> STATUS_FIELD = SdkField
            .<VirtualRouterStatus> builder(MarshallingType.SDK_POJO).getter(getter(VirtualRouterData::status))
            .setter(setter(Builder::status)).constructor(VirtualRouterStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> VIRTUAL_ROUTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VirtualRouterData::virtualRouterName)).setter(setter(Builder::virtualRouterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualRouterName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESH_NAME_FIELD,
            METADATA_FIELD, SPEC_FIELD, STATUS_FIELD, VIRTUAL_ROUTER_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String meshName;

    private final ResourceMetadata metadata;

    private final VirtualRouterSpec spec;

    private final VirtualRouterStatus status;

    private final String virtualRouterName;

    private VirtualRouterData(BuilderImpl builder) {
        this.meshName = builder.meshName;
        this.metadata = builder.metadata;
        this.spec = builder.spec;
        this.status = builder.status;
        this.virtualRouterName = builder.virtualRouterName;
    }

    /**
     * <p>
     * The name of the service mesh that the virtual router resides in.
     * </p>
     * 
     * @return The name of the service mesh that the virtual router resides in.
     */
    public String meshName() {
        return meshName;
    }

    /**
     * <p>
     * The associated metadata for the virtual router.
     * </p>
     * 
     * @return The associated metadata for the virtual router.
     */
    public ResourceMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * The specifications of the virtual router.
     * </p>
     * 
     * @return The specifications of the virtual router.
     */
    public VirtualRouterSpec spec() {
        return spec;
    }

    /**
     * <p>
     * The current status of the virtual router.
     * </p>
     * 
     * @return The current status of the virtual router.
     */
    public VirtualRouterStatus status() {
        return status;
    }

    /**
     * <p>
     * The name of the virtual router.
     * </p>
     * 
     * @return The name of the virtual router.
     */
    public String virtualRouterName() {
        return virtualRouterName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(meshName());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(spec());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(virtualRouterName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualRouterData)) {
            return false;
        }
        VirtualRouterData other = (VirtualRouterData) obj;
        return Objects.equals(meshName(), other.meshName()) && Objects.equals(metadata(), other.metadata())
                && Objects.equals(spec(), other.spec()) && Objects.equals(status(), other.status())
                && Objects.equals(virtualRouterName(), other.virtualRouterName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VirtualRouterData").add("MeshName", meshName()).add("Metadata", metadata()).add("Spec", spec())
                .add("Status", status()).add("VirtualRouterName", virtualRouterName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "meshName":
            return Optional.ofNullable(clazz.cast(meshName()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "spec":
            return Optional.ofNullable(clazz.cast(spec()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "virtualRouterName":
            return Optional.ofNullable(clazz.cast(virtualRouterName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualRouterData, T> g) {
        return obj -> g.apply((VirtualRouterData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualRouterData> {
        /**
         * <p>
         * The name of the service mesh that the virtual router resides in.
         * </p>
         * 
         * @param meshName
         *        The name of the service mesh that the virtual router resides in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshName(String meshName);

        /**
         * <p>
         * The associated metadata for the virtual router.
         * </p>
         * 
         * @param metadata
         *        The associated metadata for the virtual router.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(ResourceMetadata metadata);

        /**
         * <p>
         * The associated metadata for the virtual router.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceMetadata.Builder} avoiding the need to
         * create one manually via {@link ResourceMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #metadata(ResourceMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link ResourceMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(ResourceMetadata)
         */
        default Builder metadata(Consumer<ResourceMetadata.Builder> metadata) {
            return metadata(ResourceMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * The specifications of the virtual router.
         * </p>
         * 
         * @param spec
         *        The specifications of the virtual router.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spec(VirtualRouterSpec spec);

        /**
         * <p>
         * The specifications of the virtual router.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualRouterSpec.Builder} avoiding the need to
         * create one manually via {@link VirtualRouterSpec#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualRouterSpec.Builder#build()} is called immediately and its
         * result is passed to {@link #spec(VirtualRouterSpec)}.
         * 
         * @param spec
         *        a consumer that will call methods on {@link VirtualRouterSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spec(VirtualRouterSpec)
         */
        default Builder spec(Consumer<VirtualRouterSpec.Builder> spec) {
            return spec(VirtualRouterSpec.builder().applyMutation(spec).build());
        }

        /**
         * <p>
         * The current status of the virtual router.
         * </p>
         * 
         * @param status
         *        The current status of the virtual router.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(VirtualRouterStatus status);

        /**
         * <p>
         * The current status of the virtual router.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualRouterStatus.Builder} avoiding the need
         * to create one manually via {@link VirtualRouterStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualRouterStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #status(VirtualRouterStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link VirtualRouterStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(VirtualRouterStatus)
         */
        default Builder status(Consumer<VirtualRouterStatus.Builder> status) {
            return status(VirtualRouterStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The name of the virtual router.
         * </p>
         * 
         * @param virtualRouterName
         *        The name of the virtual router.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualRouterName(String virtualRouterName);
    }

    static final class BuilderImpl implements Builder {
        private String meshName;

        private ResourceMetadata metadata;

        private VirtualRouterSpec spec;

        private VirtualRouterStatus status;

        private String virtualRouterName;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualRouterData model) {
            meshName(model.meshName);
            metadata(model.metadata);
            spec(model.spec);
            status(model.status);
            virtualRouterName(model.virtualRouterName);
        }

        public final String getMeshName() {
            return meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final ResourceMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        @Override
        public final Builder metadata(ResourceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(ResourceMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        public final VirtualRouterSpec.Builder getSpec() {
            return spec != null ? spec.toBuilder() : null;
        }

        @Override
        public final Builder spec(VirtualRouterSpec spec) {
            this.spec = spec;
            return this;
        }

        public final void setSpec(VirtualRouterSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        public final VirtualRouterStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        @Override
        public final Builder status(VirtualRouterStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(VirtualRouterStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final String getVirtualRouterName() {
            return virtualRouterName;
        }

        @Override
        public final Builder virtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
            return this;
        }

        public final void setVirtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
        }

        @Override
        public VirtualRouterData build() {
            return new VirtualRouterData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
