/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRouteRequest extends AppMeshRequest implements
        ToCopyableBuilder<DeleteRouteRequest.Builder, DeleteRouteRequest> {
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteRouteRequest::meshName)).setter(setter(Builder::meshName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("meshName").build()).build();

    private static final SdkField<String> MESH_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteRouteRequest::meshOwner)).setter(setter(Builder::meshOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("meshOwner").build()).build();

    private static final SdkField<String> ROUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteRouteRequest::routeName)).setter(setter(Builder::routeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("routeName").build()).build();

    private static final SdkField<String> VIRTUAL_ROUTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteRouteRequest::virtualRouterName)).setter(setter(Builder::virtualRouterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualRouterName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESH_NAME_FIELD,
            MESH_OWNER_FIELD, ROUTE_NAME_FIELD, VIRTUAL_ROUTER_NAME_FIELD));

    private final String meshName;

    private final String meshOwner;

    private final String routeName;

    private final String virtualRouterName;

    private DeleteRouteRequest(BuilderImpl builder) {
        super(builder);
        this.meshName = builder.meshName;
        this.meshOwner = builder.meshOwner;
        this.routeName = builder.routeName;
        this.virtualRouterName = builder.virtualRouterName;
    }

    /**
     * <p>
     * The name of the service mesh to delete the route in.
     * </p>
     * 
     * @return The name of the service mesh to delete the route in.
     */
    public String meshName() {
        return meshName;
    }

    /**
     * <p>
     * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the
     * account that shared the mesh with your account. For more information about mesh sharing, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
     * </p>
     * 
     * @return The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of
     *         the account that shared the mesh with your account. For more information about mesh sharing, see <a
     *         href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
     */
    public String meshOwner() {
        return meshOwner;
    }

    /**
     * <p>
     * The name of the route to delete.
     * </p>
     * 
     * @return The name of the route to delete.
     */
    public String routeName() {
        return routeName;
    }

    /**
     * <p>
     * The name of the virtual router to delete the route in.
     * </p>
     * 
     * @return The name of the virtual router to delete the route in.
     */
    public String virtualRouterName() {
        return virtualRouterName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(meshName());
        hashCode = 31 * hashCode + Objects.hashCode(meshOwner());
        hashCode = 31 * hashCode + Objects.hashCode(routeName());
        hashCode = 31 * hashCode + Objects.hashCode(virtualRouterName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRouteRequest)) {
            return false;
        }
        DeleteRouteRequest other = (DeleteRouteRequest) obj;
        return Objects.equals(meshName(), other.meshName()) && Objects.equals(meshOwner(), other.meshOwner())
                && Objects.equals(routeName(), other.routeName())
                && Objects.equals(virtualRouterName(), other.virtualRouterName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteRouteRequest").add("MeshName", meshName()).add("MeshOwner", meshOwner())
                .add("RouteName", routeName()).add("VirtualRouterName", virtualRouterName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "meshName":
            return Optional.ofNullable(clazz.cast(meshName()));
        case "meshOwner":
            return Optional.ofNullable(clazz.cast(meshOwner()));
        case "routeName":
            return Optional.ofNullable(clazz.cast(routeName()));
        case "virtualRouterName":
            return Optional.ofNullable(clazz.cast(virtualRouterName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRouteRequest, T> g) {
        return obj -> g.apply((DeleteRouteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteRouteRequest> {
        /**
         * <p>
         * The name of the service mesh to delete the route in.
         * </p>
         * 
         * @param meshName
         *        The name of the service mesh to delete the route in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshName(String meshName);

        /**
         * <p>
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the
         * account that shared the mesh with your account. For more information about mesh sharing, see <a
         * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
         * </p>
         * 
         * @param meshOwner
         *        The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID
         *        of the account that shared the mesh with your account. For more information about mesh sharing, see <a
         *        href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared
         *        meshes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshOwner(String meshOwner);

        /**
         * <p>
         * The name of the route to delete.
         * </p>
         * 
         * @param routeName
         *        The name of the route to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeName(String routeName);

        /**
         * <p>
         * The name of the virtual router to delete the route in.
         * </p>
         * 
         * @param virtualRouterName
         *        The name of the virtual router to delete the route in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualRouterName(String virtualRouterName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppMeshRequest.BuilderImpl implements Builder {
        private String meshName;

        private String meshOwner;

        private String routeName;

        private String virtualRouterName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRouteRequest model) {
            super(model);
            meshName(model.meshName);
            meshOwner(model.meshOwner);
            routeName(model.routeName);
            virtualRouterName(model.virtualRouterName);
        }

        public final String getMeshName() {
            return meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final String getMeshOwner() {
            return meshOwner;
        }

        @Override
        public final Builder meshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
            return this;
        }

        public final void setMeshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
        }

        public final String getRouteName() {
            return routeName;
        }

        @Override
        public final Builder routeName(String routeName) {
            this.routeName = routeName;
            return this;
        }

        public final void setRouteName(String routeName) {
            this.routeName = routeName;
        }

        public final String getVirtualRouterName() {
            return virtualRouterName;
        }

        @Override
        public final Builder virtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
            return this;
        }

        public final void setVirtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRouteRequest build() {
            return new DeleteRouteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
