/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.TcpRouteAction;
import software.amazon.awssdk.services.appmesh.model.TcpTimeout;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TcpRoute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TcpRoute> {
    private static final SdkField<TcpRouteAction> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TcpRoute.getter(TcpRoute::action)).setter(TcpRoute.setter(Builder::action)).constructor(TcpRouteAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<TcpTimeout> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TcpRoute.getter(TcpRoute::timeout)).setter(TcpRoute.setter(Builder::timeout)).constructor(TcpTimeout::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, TIMEOUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final TcpRouteAction action;
    private final TcpTimeout timeout;

    private TcpRoute(BuilderImpl builder) {
        this.action = builder.action;
        this.timeout = builder.timeout;
    }

    public TcpRouteAction action() {
        return this.action;
    }

    public TcpTimeout timeout() {
        return this.timeout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TcpRoute)) {
            return false;
        }
        TcpRoute other = (TcpRoute)obj;
        return Objects.equals(this.action(), other.action()) && Objects.equals(this.timeout(), other.timeout());
    }

    public String toString() {
        return ToString.builder((String)"TcpRoute").add("Action", (Object)this.action()).add("Timeout", (Object)this.timeout()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TcpRoute, T> g) {
        return obj -> g.apply((TcpRoute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TcpRouteAction action;
        private TcpTimeout timeout;

        private BuilderImpl() {
        }

        private BuilderImpl(TcpRoute model) {
            this.action(model.action);
            this.timeout(model.timeout);
        }

        public final TcpRouteAction.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        @Override
        public final Builder action(TcpRouteAction action) {
            this.action = action;
            return this;
        }

        public final void setAction(TcpRouteAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        public final TcpTimeout.Builder getTimeout() {
            return this.timeout != null ? this.timeout.toBuilder() : null;
        }

        @Override
        public final Builder timeout(TcpTimeout timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(TcpTimeout.BuilderImpl timeout) {
            this.timeout = timeout != null ? timeout.build() : null;
        }

        public TcpRoute build() {
            return new TcpRoute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TcpRoute> {
        public Builder action(TcpRouteAction var1);

        default public Builder action(Consumer<TcpRouteAction.Builder> action) {
            return this.action((TcpRouteAction)((TcpRouteAction.Builder)TcpRouteAction.builder().applyMutation(action)).build());
        }

        public Builder timeout(TcpTimeout var1);

        default public Builder timeout(Consumer<TcpTimeout.Builder> timeout) {
            return this.timeout((TcpTimeout)((TcpTimeout.Builder)TcpTimeout.builder().applyMutation(timeout)).build());
        }
    }
}

