/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents logging information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualGatewayLogging implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualGatewayLogging.Builder, VirtualGatewayLogging> {
    private static final SdkField<VirtualGatewayAccessLog> ACCESS_LOG_FIELD = SdkField
            .<VirtualGatewayAccessLog> builder(MarshallingType.SDK_POJO).getter(getter(VirtualGatewayLogging::accessLog))
            .setter(setter(Builder::accessLog)).constructor(VirtualGatewayAccessLog::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessLog").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_LOG_FIELD));

    private static final long serialVersionUID = 1L;

    private final VirtualGatewayAccessLog accessLog;

    private VirtualGatewayLogging(BuilderImpl builder) {
        this.accessLog = builder.accessLog;
    }

    /**
     * <p>
     * The access log configuration.
     * </p>
     * 
     * @return The access log configuration.
     */
    public VirtualGatewayAccessLog accessLog() {
        return accessLog;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessLog());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayLogging)) {
            return false;
        }
        VirtualGatewayLogging other = (VirtualGatewayLogging) obj;
        return Objects.equals(accessLog(), other.accessLog());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VirtualGatewayLogging").add("AccessLog", accessLog()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessLog":
            return Optional.ofNullable(clazz.cast(accessLog()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayLogging, T> g) {
        return obj -> g.apply((VirtualGatewayLogging) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualGatewayLogging> {
        /**
         * <p>
         * The access log configuration.
         * </p>
         * 
         * @param accessLog
         *        The access log configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessLog(VirtualGatewayAccessLog accessLog);

        /**
         * <p>
         * The access log configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualGatewayAccessLog.Builder} avoiding the
         * need to create one manually via {@link VirtualGatewayAccessLog#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayAccessLog.Builder#build()} is called immediately
         * and its result is passed to {@link #accessLog(VirtualGatewayAccessLog)}.
         * 
         * @param accessLog
         *        a consumer that will call methods on {@link VirtualGatewayAccessLog.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessLog(VirtualGatewayAccessLog)
         */
        default Builder accessLog(Consumer<VirtualGatewayAccessLog.Builder> accessLog) {
            return accessLog(VirtualGatewayAccessLog.builder().applyMutation(accessLog).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VirtualGatewayAccessLog accessLog;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayLogging model) {
            accessLog(model.accessLog);
        }

        public final VirtualGatewayAccessLog.Builder getAccessLog() {
            return accessLog != null ? accessLog.toBuilder() : null;
        }

        @Override
        public final Builder accessLog(VirtualGatewayAccessLog accessLog) {
            this.accessLog = accessLog;
            return this;
        }

        public final void setAccessLog(VirtualGatewayAccessLog.BuilderImpl accessLog) {
            this.accessLog = accessLog != null ? accessLog.build() : null;
        }

        @Override
        public VirtualGatewayLogging build() {
            return new VirtualGatewayLogging(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
