/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.ListenerTlsCertificate;
import software.amazon.awssdk.services.appmesh.model.ListenerTlsMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListenerTls
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListenerTls> {
    private static final SdkField<ListenerTlsCertificate> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ListenerTls.getter(ListenerTls::certificate)).setter(ListenerTls.setter(Builder::certificate)).constructor(ListenerTlsCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificate").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListenerTls.getter(ListenerTls::modeAsString)).setter(ListenerTls.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD, MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final ListenerTlsCertificate certificate;
    private final String mode;

    private ListenerTls(BuilderImpl builder) {
        this.certificate = builder.certificate;
        this.mode = builder.mode;
    }

    public ListenerTlsCertificate certificate() {
        return this.certificate;
    }

    public ListenerTlsMode mode() {
        return ListenerTlsMode.fromValue(this.mode);
    }

    public String modeAsString() {
        return this.mode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListenerTls)) {
            return false;
        }
        ListenerTls other = (ListenerTls)obj;
        return Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.modeAsString(), other.modeAsString());
    }

    public String toString() {
        return ToString.builder((String)"ListenerTls").add("Certificate", (Object)this.certificate()).add("Mode", (Object)this.modeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListenerTls, T> g) {
        return obj -> g.apply((ListenerTls)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ListenerTlsCertificate certificate;
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(ListenerTls model) {
            this.certificate(model.certificate);
            this.mode(model.mode);
        }

        public final ListenerTlsCertificate.Builder getCertificate() {
            return this.certificate != null ? this.certificate.toBuilder() : null;
        }

        @Override
        public final Builder certificate(ListenerTlsCertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(ListenerTlsCertificate.BuilderImpl certificate) {
            this.certificate = certificate != null ? certificate.build() : null;
        }

        public final String getMode() {
            return this.mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ListenerTlsMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public ListenerTls build() {
            return new ListenerTls(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListenerTls> {
        public Builder certificate(ListenerTlsCertificate var1);

        default public Builder certificate(Consumer<ListenerTlsCertificate.Builder> certificate) {
            return this.certificate((ListenerTlsCertificate)((ListenerTlsCertificate.Builder)ListenerTlsCertificate.builder().applyMutation(certificate)).build());
        }

        public Builder mode(String var1);

        public Builder mode(ListenerTlsMode var1);
    }
}

