/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the default properties for a backend.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualGatewayBackendDefaults implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualGatewayBackendDefaults.Builder, VirtualGatewayBackendDefaults> {
    private static final SdkField<VirtualGatewayClientPolicy> CLIENT_POLICY_FIELD = SdkField
            .<VirtualGatewayClientPolicy> builder(MarshallingType.SDK_POJO)
            .getter(getter(VirtualGatewayBackendDefaults::clientPolicy)).setter(setter(Builder::clientPolicy))
            .constructor(VirtualGatewayClientPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final VirtualGatewayClientPolicy clientPolicy;

    private VirtualGatewayBackendDefaults(BuilderImpl builder) {
        this.clientPolicy = builder.clientPolicy;
    }

    /**
     * <p>
     * A reference to an object that represents a client policy.
     * </p>
     * 
     * @return A reference to an object that represents a client policy.
     */
    public VirtualGatewayClientPolicy clientPolicy() {
        return clientPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientPolicy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayBackendDefaults)) {
            return false;
        }
        VirtualGatewayBackendDefaults other = (VirtualGatewayBackendDefaults) obj;
        return Objects.equals(clientPolicy(), other.clientPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VirtualGatewayBackendDefaults").add("ClientPolicy", clientPolicy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientPolicy":
            return Optional.ofNullable(clazz.cast(clientPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayBackendDefaults, T> g) {
        return obj -> g.apply((VirtualGatewayBackendDefaults) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualGatewayBackendDefaults> {
        /**
         * <p>
         * A reference to an object that represents a client policy.
         * </p>
         * 
         * @param clientPolicy
         *        A reference to an object that represents a client policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientPolicy(VirtualGatewayClientPolicy clientPolicy);

        /**
         * <p>
         * A reference to an object that represents a client policy.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualGatewayClientPolicy.Builder} avoiding the
         * need to create one manually via {@link VirtualGatewayClientPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayClientPolicy.Builder#build()} is called immediately
         * and its result is passed to {@link #clientPolicy(VirtualGatewayClientPolicy)}.
         * 
         * @param clientPolicy
         *        a consumer that will call methods on {@link VirtualGatewayClientPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientPolicy(VirtualGatewayClientPolicy)
         */
        default Builder clientPolicy(Consumer<VirtualGatewayClientPolicy.Builder> clientPolicy) {
            return clientPolicy(VirtualGatewayClientPolicy.builder().applyMutation(clientPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VirtualGatewayClientPolicy clientPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayBackendDefaults model) {
            clientPolicy(model.clientPolicy);
        }

        public final VirtualGatewayClientPolicy.Builder getClientPolicy() {
            return clientPolicy != null ? clientPolicy.toBuilder() : null;
        }

        @Override
        public final Builder clientPolicy(VirtualGatewayClientPolicy clientPolicy) {
            this.clientPolicy = clientPolicy;
            return this;
        }

        public final void setClientPolicy(VirtualGatewayClientPolicy.BuilderImpl clientPolicy) {
            this.clientPolicy = clientPolicy != null ? clientPolicy.build() : null;
        }

        @Override
        public VirtualGatewayBackendDefaults build() {
            return new VirtualGatewayBackendDefaults(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
