/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The access log configuration for a virtual gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualGatewayAccessLog implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualGatewayAccessLog.Builder, VirtualGatewayAccessLog> {
    private static final SdkField<VirtualGatewayFileAccessLog> FILE_FIELD = SdkField
            .<VirtualGatewayFileAccessLog> builder(MarshallingType.SDK_POJO).getter(getter(VirtualGatewayAccessLog::file))
            .setter(setter(Builder::file)).constructor(VirtualGatewayFileAccessLog::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_FIELD));

    private static final long serialVersionUID = 1L;

    private final VirtualGatewayFileAccessLog file;

    private VirtualGatewayAccessLog(BuilderImpl builder) {
        this.file = builder.file;
    }

    /**
     * <p>
     * The file object to send virtual gateway access logs to.
     * </p>
     * 
     * @return The file object to send virtual gateway access logs to.
     */
    public VirtualGatewayFileAccessLog file() {
        return file;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(file());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayAccessLog)) {
            return false;
        }
        VirtualGatewayAccessLog other = (VirtualGatewayAccessLog) obj;
        return Objects.equals(file(), other.file());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VirtualGatewayAccessLog").add("File", file()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "file":
            return Optional.ofNullable(clazz.cast(file()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayAccessLog, T> g) {
        return obj -> g.apply((VirtualGatewayAccessLog) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualGatewayAccessLog> {
        /**
         * <p>
         * The file object to send virtual gateway access logs to.
         * </p>
         * 
         * @param file
         *        The file object to send virtual gateway access logs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder file(VirtualGatewayFileAccessLog file);

        /**
         * <p>
         * The file object to send virtual gateway access logs to.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualGatewayFileAccessLog.Builder} avoiding
         * the need to create one manually via {@link VirtualGatewayFileAccessLog#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayFileAccessLog.Builder#build()} is called
         * immediately and its result is passed to {@link #file(VirtualGatewayFileAccessLog)}.
         * 
         * @param file
         *        a consumer that will call methods on {@link VirtualGatewayFileAccessLog.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #file(VirtualGatewayFileAccessLog)
         */
        default Builder file(Consumer<VirtualGatewayFileAccessLog.Builder> file) {
            return file(VirtualGatewayFileAccessLog.builder().applyMutation(file).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VirtualGatewayFileAccessLog file;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayAccessLog model) {
            file(model.file);
        }

        public final VirtualGatewayFileAccessLog.Builder getFile() {
            return file != null ? file.toBuilder() : null;
        }

        @Override
        public final Builder file(VirtualGatewayFileAccessLog file) {
            this.file = file;
            return this;
        }

        public final void setFile(VirtualGatewayFileAccessLog.BuilderImpl file) {
            this.file = file != null ? file.build() : null;
        }

        @Override
        public VirtualGatewayAccessLog build() {
            return new VirtualGatewayAccessLog(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
