/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGatewayRouteRequest extends AppMeshRequest implements
        ToCopyableBuilder<DescribeGatewayRouteRequest.Builder, DescribeGatewayRouteRequest> {
    private static final SdkField<String> GATEWAY_ROUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayRouteRequest::gatewayRouteName)).setter(setter(Builder::gatewayRouteName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayRouteName").build()).build();

    private static final SdkField<String> MESH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayRouteRequest::meshName)).setter(setter(Builder::meshName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("meshName").build()).build();

    private static final SdkField<String> MESH_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayRouteRequest::meshOwner)).setter(setter(Builder::meshOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("meshOwner").build()).build();

    private static final SdkField<String> VIRTUAL_GATEWAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeGatewayRouteRequest::virtualGatewayName)).setter(setter(Builder::virtualGatewayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualGatewayName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ROUTE_NAME_FIELD,
            MESH_NAME_FIELD, MESH_OWNER_FIELD, VIRTUAL_GATEWAY_NAME_FIELD));

    private final String gatewayRouteName;

    private final String meshName;

    private final String meshOwner;

    private final String virtualGatewayName;

    private DescribeGatewayRouteRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayRouteName = builder.gatewayRouteName;
        this.meshName = builder.meshName;
        this.meshOwner = builder.meshOwner;
        this.virtualGatewayName = builder.virtualGatewayName;
    }

    /**
     * <p>
     * The name of the gateway route to describe.
     * </p>
     * 
     * @return The name of the gateway route to describe.
     */
    public String gatewayRouteName() {
        return gatewayRouteName;
    }

    /**
     * <p>
     * The name of the service mesh that the gateway route resides in.
     * </p>
     * 
     * @return The name of the service mesh that the gateway route resides in.
     */
    public String meshName() {
        return meshName;
    }

    /**
     * <p>
     * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the
     * account that shared the mesh with your account. For more information about mesh sharing, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
     * </p>
     * 
     * @return The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of
     *         the account that shared the mesh with your account. For more information about mesh sharing, see <a
     *         href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
     */
    public String meshOwner() {
        return meshOwner;
    }

    /**
     * <p>
     * The name of the virtual gateway that the gateway route is associated with.
     * </p>
     * 
     * @return The name of the virtual gateway that the gateway route is associated with.
     */
    public String virtualGatewayName() {
        return virtualGatewayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayRouteName());
        hashCode = 31 * hashCode + Objects.hashCode(meshName());
        hashCode = 31 * hashCode + Objects.hashCode(meshOwner());
        hashCode = 31 * hashCode + Objects.hashCode(virtualGatewayName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGatewayRouteRequest)) {
            return false;
        }
        DescribeGatewayRouteRequest other = (DescribeGatewayRouteRequest) obj;
        return Objects.equals(gatewayRouteName(), other.gatewayRouteName()) && Objects.equals(meshName(), other.meshName())
                && Objects.equals(meshOwner(), other.meshOwner())
                && Objects.equals(virtualGatewayName(), other.virtualGatewayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeGatewayRouteRequest").add("GatewayRouteName", gatewayRouteName())
                .add("MeshName", meshName()).add("MeshOwner", meshOwner()).add("VirtualGatewayName", virtualGatewayName())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gatewayRouteName":
            return Optional.ofNullable(clazz.cast(gatewayRouteName()));
        case "meshName":
            return Optional.ofNullable(clazz.cast(meshName()));
        case "meshOwner":
            return Optional.ofNullable(clazz.cast(meshOwner()));
        case "virtualGatewayName":
            return Optional.ofNullable(clazz.cast(virtualGatewayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGatewayRouteRequest, T> g) {
        return obj -> g.apply((DescribeGatewayRouteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeGatewayRouteRequest> {
        /**
         * <p>
         * The name of the gateway route to describe.
         * </p>
         * 
         * @param gatewayRouteName
         *        The name of the gateway route to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayRouteName(String gatewayRouteName);

        /**
         * <p>
         * The name of the service mesh that the gateway route resides in.
         * </p>
         * 
         * @param meshName
         *        The name of the service mesh that the gateway route resides in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshName(String meshName);

        /**
         * <p>
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the
         * account that shared the mesh with your account. For more information about mesh sharing, see <a
         * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
         * </p>
         * 
         * @param meshOwner
         *        The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID
         *        of the account that shared the mesh with your account. For more information about mesh sharing, see <a
         *        href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared
         *        meshes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshOwner(String meshOwner);

        /**
         * <p>
         * The name of the virtual gateway that the gateway route is associated with.
         * </p>
         * 
         * @param virtualGatewayName
         *        The name of the virtual gateway that the gateway route is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualGatewayName(String virtualGatewayName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppMeshRequest.BuilderImpl implements Builder {
        private String gatewayRouteName;

        private String meshName;

        private String meshOwner;

        private String virtualGatewayName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGatewayRouteRequest model) {
            super(model);
            gatewayRouteName(model.gatewayRouteName);
            meshName(model.meshName);
            meshOwner(model.meshOwner);
            virtualGatewayName(model.virtualGatewayName);
        }

        public final String getGatewayRouteName() {
            return gatewayRouteName;
        }

        @Override
        public final Builder gatewayRouteName(String gatewayRouteName) {
            this.gatewayRouteName = gatewayRouteName;
            return this;
        }

        public final void setGatewayRouteName(String gatewayRouteName) {
            this.gatewayRouteName = gatewayRouteName;
        }

        public final String getMeshName() {
            return meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final String getMeshOwner() {
            return meshOwner;
        }

        @Override
        public final Builder meshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
            return this;
        }

        public final void setMeshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
        }

        public final String getVirtualGatewayName() {
            return virtualGatewayName;
        }

        @Override
        public final Builder virtualGatewayName(String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
            return this;
        }

        public final void setVirtualGatewayName(String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeGatewayRouteRequest build() {
            return new DescribeGatewayRouteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
