/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a virtual node service provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualRouterServiceProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualRouterServiceProvider.Builder, VirtualRouterServiceProvider> {
    private static final SdkField<String> VIRTUAL_ROUTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VirtualRouterServiceProvider::virtualRouterName)).setter(setter(Builder::virtualRouterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualRouterName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_ROUTER_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String virtualRouterName;

    private VirtualRouterServiceProvider(BuilderImpl builder) {
        this.virtualRouterName = builder.virtualRouterName;
    }

    /**
     * <p>
     * The name of the virtual router that is acting as a service provider.
     * </p>
     * 
     * @return The name of the virtual router that is acting as a service provider.
     */
    public String virtualRouterName() {
        return virtualRouterName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(virtualRouterName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualRouterServiceProvider)) {
            return false;
        }
        VirtualRouterServiceProvider other = (VirtualRouterServiceProvider) obj;
        return Objects.equals(virtualRouterName(), other.virtualRouterName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VirtualRouterServiceProvider").add("VirtualRouterName", virtualRouterName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualRouterName":
            return Optional.ofNullable(clazz.cast(virtualRouterName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualRouterServiceProvider, T> g) {
        return obj -> g.apply((VirtualRouterServiceProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualRouterServiceProvider> {
        /**
         * <p>
         * The name of the virtual router that is acting as a service provider.
         * </p>
         * 
         * @param virtualRouterName
         *        The name of the virtual router that is acting as a service provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualRouterName(String virtualRouterName);
    }

    static final class BuilderImpl implements Builder {
        private String virtualRouterName;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualRouterServiceProvider model) {
            virtualRouterName(model.virtualRouterName);
        }

        public final String getVirtualRouterName() {
            return virtualRouterName;
        }

        @Override
        public final Builder virtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
            return this;
        }

        public final void setVirtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
        }

        @Override
        public VirtualRouterServiceProvider build() {
            return new VirtualRouterServiceProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
