/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a listener for a virtual gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualGatewayListener implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualGatewayListener.Builder, VirtualGatewayListener> {
    private static final SdkField<VirtualGatewayHealthCheckPolicy> HEALTH_CHECK_FIELD = SdkField
            .<VirtualGatewayHealthCheckPolicy> builder(MarshallingType.SDK_POJO)
            .getter(getter(VirtualGatewayListener::healthCheck)).setter(setter(Builder::healthCheck))
            .constructor(VirtualGatewayHealthCheckPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheck").build()).build();

    private static final SdkField<VirtualGatewayPortMapping> PORT_MAPPING_FIELD = SdkField
            .<VirtualGatewayPortMapping> builder(MarshallingType.SDK_POJO).getter(getter(VirtualGatewayListener::portMapping))
            .setter(setter(Builder::portMapping)).constructor(VirtualGatewayPortMapping::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portMapping").build()).build();

    private static final SdkField<VirtualGatewayListenerTls> TLS_FIELD = SdkField
            .<VirtualGatewayListenerTls> builder(MarshallingType.SDK_POJO).getter(getter(VirtualGatewayListener::tls))
            .setter(setter(Builder::tls)).constructor(VirtualGatewayListenerTls::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tls").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_CHECK_FIELD,
            PORT_MAPPING_FIELD, TLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final VirtualGatewayHealthCheckPolicy healthCheck;

    private final VirtualGatewayPortMapping portMapping;

    private final VirtualGatewayListenerTls tls;

    private VirtualGatewayListener(BuilderImpl builder) {
        this.healthCheck = builder.healthCheck;
        this.portMapping = builder.portMapping;
        this.tls = builder.tls;
    }

    /**
     * <p>
     * The health check information for the listener.
     * </p>
     * 
     * @return The health check information for the listener.
     */
    public VirtualGatewayHealthCheckPolicy healthCheck() {
        return healthCheck;
    }

    /**
     * <p>
     * The port mapping information for the listener.
     * </p>
     * 
     * @return The port mapping information for the listener.
     */
    public VirtualGatewayPortMapping portMapping() {
        return portMapping;
    }

    /**
     * <p>
     * A reference to an object that represents the Transport Layer Security (TLS) properties for the listener.
     * </p>
     * 
     * @return A reference to an object that represents the Transport Layer Security (TLS) properties for the listener.
     */
    public VirtualGatewayListenerTls tls() {
        return tls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(healthCheck());
        hashCode = 31 * hashCode + Objects.hashCode(portMapping());
        hashCode = 31 * hashCode + Objects.hashCode(tls());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayListener)) {
            return false;
        }
        VirtualGatewayListener other = (VirtualGatewayListener) obj;
        return Objects.equals(healthCheck(), other.healthCheck()) && Objects.equals(portMapping(), other.portMapping())
                && Objects.equals(tls(), other.tls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VirtualGatewayListener").add("HealthCheck", healthCheck()).add("PortMapping", portMapping())
                .add("Tls", tls()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "healthCheck":
            return Optional.ofNullable(clazz.cast(healthCheck()));
        case "portMapping":
            return Optional.ofNullable(clazz.cast(portMapping()));
        case "tls":
            return Optional.ofNullable(clazz.cast(tls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayListener, T> g) {
        return obj -> g.apply((VirtualGatewayListener) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualGatewayListener> {
        /**
         * <p>
         * The health check information for the listener.
         * </p>
         * 
         * @param healthCheck
         *        The health check information for the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheck(VirtualGatewayHealthCheckPolicy healthCheck);

        /**
         * <p>
         * The health check information for the listener.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualGatewayHealthCheckPolicy.Builder}
         * avoiding the need to create one manually via {@link VirtualGatewayHealthCheckPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayHealthCheckPolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #healthCheck(VirtualGatewayHealthCheckPolicy)}.
         * 
         * @param healthCheck
         *        a consumer that will call methods on {@link VirtualGatewayHealthCheckPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheck(VirtualGatewayHealthCheckPolicy)
         */
        default Builder healthCheck(Consumer<VirtualGatewayHealthCheckPolicy.Builder> healthCheck) {
            return healthCheck(VirtualGatewayHealthCheckPolicy.builder().applyMutation(healthCheck).build());
        }

        /**
         * <p>
         * The port mapping information for the listener.
         * </p>
         * 
         * @param portMapping
         *        The port mapping information for the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portMapping(VirtualGatewayPortMapping portMapping);

        /**
         * <p>
         * The port mapping information for the listener.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualGatewayPortMapping.Builder} avoiding the
         * need to create one manually via {@link VirtualGatewayPortMapping#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayPortMapping.Builder#build()} is called immediately
         * and its result is passed to {@link #portMapping(VirtualGatewayPortMapping)}.
         * 
         * @param portMapping
         *        a consumer that will call methods on {@link VirtualGatewayPortMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portMapping(VirtualGatewayPortMapping)
         */
        default Builder portMapping(Consumer<VirtualGatewayPortMapping.Builder> portMapping) {
            return portMapping(VirtualGatewayPortMapping.builder().applyMutation(portMapping).build());
        }

        /**
         * <p>
         * A reference to an object that represents the Transport Layer Security (TLS) properties for the listener.
         * </p>
         * 
         * @param tls
         *        A reference to an object that represents the Transport Layer Security (TLS) properties for the
         *        listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tls(VirtualGatewayListenerTls tls);

        /**
         * <p>
         * A reference to an object that represents the Transport Layer Security (TLS) properties for the listener.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualGatewayListenerTls.Builder} avoiding the
         * need to create one manually via {@link VirtualGatewayListenerTls#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayListenerTls.Builder#build()} is called immediately
         * and its result is passed to {@link #tls(VirtualGatewayListenerTls)}.
         * 
         * @param tls
         *        a consumer that will call methods on {@link VirtualGatewayListenerTls.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tls(VirtualGatewayListenerTls)
         */
        default Builder tls(Consumer<VirtualGatewayListenerTls.Builder> tls) {
            return tls(VirtualGatewayListenerTls.builder().applyMutation(tls).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VirtualGatewayHealthCheckPolicy healthCheck;

        private VirtualGatewayPortMapping portMapping;

        private VirtualGatewayListenerTls tls;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayListener model) {
            healthCheck(model.healthCheck);
            portMapping(model.portMapping);
            tls(model.tls);
        }

        public final VirtualGatewayHealthCheckPolicy.Builder getHealthCheck() {
            return healthCheck != null ? healthCheck.toBuilder() : null;
        }

        @Override
        public final Builder healthCheck(VirtualGatewayHealthCheckPolicy healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final void setHealthCheck(VirtualGatewayHealthCheckPolicy.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        public final VirtualGatewayPortMapping.Builder getPortMapping() {
            return portMapping != null ? portMapping.toBuilder() : null;
        }

        @Override
        public final Builder portMapping(VirtualGatewayPortMapping portMapping) {
            this.portMapping = portMapping;
            return this;
        }

        public final void setPortMapping(VirtualGatewayPortMapping.BuilderImpl portMapping) {
            this.portMapping = portMapping != null ? portMapping.build() : null;
        }

        public final VirtualGatewayListenerTls.Builder getTls() {
            return tls != null ? tls.toBuilder() : null;
        }

        @Override
        public final Builder tls(VirtualGatewayListenerTls tls) {
            this.tls = tls;
            return this;
        }

        public final void setTls(VirtualGatewayListenerTls.BuilderImpl tls) {
            this.tls = tls != null ? tls.build() : null;
        }

        @Override
        public VirtualGatewayListener build() {
            return new VirtualGatewayListener(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
