/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMeshRequest extends AppMeshRequest implements
        ToCopyableBuilder<CreateMeshRequest.Builder, CreateMeshRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateMeshRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> MESH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateMeshRequest::meshName)).setter(setter(Builder::meshName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meshName").build()).build();

    private static final SdkField<MeshSpec> SPEC_FIELD = SdkField.<MeshSpec> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateMeshRequest::spec)).setter(setter(Builder::spec)).constructor(MeshSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()).build();

    private static final SdkField<List<TagRef>> TAGS_FIELD = SdkField
            .<List<TagRef>> builder(MarshallingType.LIST)
            .getter(getter(CreateMeshRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagRef> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagRef::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            MESH_NAME_FIELD, SPEC_FIELD, TAGS_FIELD));

    private final String clientToken;

    private final String meshName;

    private final MeshSpec spec;

    private final List<TagRef> tags;

    private CreateMeshRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.meshName = builder.meshName;
        this.spec = builder.spec;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters,
     * numbers, hyphens, and underscores are allowed.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36
     *         letters, numbers, hyphens, and underscores are allowed.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The name to use for the service mesh.
     * </p>
     * 
     * @return The name to use for the service mesh.
     */
    public String meshName() {
        return meshName;
    }

    /**
     * <p>
     * The service mesh specification to apply.
     * </p>
     * 
     * @return The service mesh specification to apply.
     */
    public MeshSpec spec() {
        return spec;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional metadata that you can apply to the service mesh to assist with categorization and organization. Each tag
     * consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length
     * of 128 characters, and tag values can have a maximum length of 256 characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Optional metadata that you can apply to the service mesh to assist with categorization and organization.
     *         Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum
     *         character length of 128 characters, and tag values can have a maximum length of 256 characters.
     */
    public List<TagRef> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(meshName());
        hashCode = 31 * hashCode + Objects.hashCode(spec());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMeshRequest)) {
            return false;
        }
        CreateMeshRequest other = (CreateMeshRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(meshName(), other.meshName())
                && Objects.equals(spec(), other.spec()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateMeshRequest").add("ClientToken", clientToken()).add("MeshName", meshName())
                .add("Spec", spec()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "meshName":
            return Optional.ofNullable(clazz.cast(meshName()));
        case "spec":
            return Optional.ofNullable(clazz.cast(spec()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMeshRequest, T> g) {
        return obj -> g.apply((CreateMeshRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMeshRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36
         * letters, numbers, hyphens, and underscores are allowed.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36
         *        letters, numbers, hyphens, and underscores are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The name to use for the service mesh.
         * </p>
         * 
         * @param meshName
         *        The name to use for the service mesh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshName(String meshName);

        /**
         * <p>
         * The service mesh specification to apply.
         * </p>
         * 
         * @param spec
         *        The service mesh specification to apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spec(MeshSpec spec);

        /**
         * <p>
         * The service mesh specification to apply.
         * </p>
         * This is a convenience that creates an instance of the {@link MeshSpec.Builder} avoiding the need to create
         * one manually via {@link MeshSpec#builder()}.
         *
         * When the {@link Consumer} completes, {@link MeshSpec.Builder#build()} is called immediately and its result is
         * passed to {@link #spec(MeshSpec)}.
         * 
         * @param spec
         *        a consumer that will call methods on {@link MeshSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spec(MeshSpec)
         */
        default Builder spec(Consumer<MeshSpec.Builder> spec) {
            return spec(MeshSpec.builder().applyMutation(spec).build());
        }

        /**
         * <p>
         * Optional metadata that you can apply to the service mesh to assist with categorization and organization. Each
         * tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character
         * length of 128 characters, and tag values can have a maximum length of 256 characters.
         * </p>
         * 
         * @param tags
         *        Optional metadata that you can apply to the service mesh to assist with categorization and
         *        organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can
         *        have a maximum character length of 128 characters, and tag values can have a maximum length of 256
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagRef> tags);

        /**
         * <p>
         * Optional metadata that you can apply to the service mesh to assist with categorization and organization. Each
         * tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character
         * length of 128 characters, and tag values can have a maximum length of 256 characters.
         * </p>
         * 
         * @param tags
         *        Optional metadata that you can apply to the service mesh to assist with categorization and
         *        organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can
         *        have a maximum character length of 128 characters, and tag values can have a maximum length of 256
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagRef... tags);

        /**
         * <p>
         * Optional metadata that you can apply to the service mesh to assist with categorization and organization. Each
         * tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character
         * length of 128 characters, and tag values can have a maximum length of 256 characters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagRef>.Builder} avoiding the need to
         * create one manually via {@link List<TagRef>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagRef>.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<TagRef>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<TagRef>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<TagRef>)
         */
        Builder tags(Consumer<TagRef.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppMeshRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String meshName;

        private MeshSpec spec;

        private List<TagRef> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMeshRequest model) {
            super(model);
            clientToken(model.clientToken);
            meshName(model.meshName);
            spec(model.spec);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getMeshName() {
            return meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final MeshSpec.Builder getSpec() {
            return spec != null ? spec.toBuilder() : null;
        }

        @Override
        public final Builder spec(MeshSpec spec) {
            this.spec = spec;
            return this;
        }

        public final void setSpec(MeshSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        public final Collection<TagRef.Builder> getTags() {
            return tags != null ? tags.stream().map(TagRef::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<TagRef> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagRef... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagRef.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagRef.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<TagRef.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMeshRequest build() {
            return new CreateMeshRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
