/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a gateway route returned by a describe operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GatewayRouteData implements SdkPojo, Serializable,
        ToCopyableBuilder<GatewayRouteData.Builder, GatewayRouteData> {
    private static final SdkField<String> GATEWAY_ROUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GatewayRouteData::gatewayRouteName)).setter(setter(Builder::gatewayRouteName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayRouteName").build()).build();

    private static final SdkField<String> MESH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GatewayRouteData::meshName)).setter(setter(Builder::meshName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meshName").build()).build();

    private static final SdkField<ResourceMetadata> METADATA_FIELD = SdkField
            .<ResourceMetadata> builder(MarshallingType.SDK_POJO).getter(getter(GatewayRouteData::metadata))
            .setter(setter(Builder::metadata)).constructor(ResourceMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<GatewayRouteSpec> SPEC_FIELD = SdkField.<GatewayRouteSpec> builder(MarshallingType.SDK_POJO)
            .getter(getter(GatewayRouteData::spec)).setter(setter(Builder::spec)).constructor(GatewayRouteSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()).build();

    private static final SdkField<GatewayRouteStatus> STATUS_FIELD = SdkField
            .<GatewayRouteStatus> builder(MarshallingType.SDK_POJO).getter(getter(GatewayRouteData::status))
            .setter(setter(Builder::status)).constructor(GatewayRouteStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> VIRTUAL_GATEWAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GatewayRouteData::virtualGatewayName)).setter(setter(Builder::virtualGatewayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGatewayName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ROUTE_NAME_FIELD,
            MESH_NAME_FIELD, METADATA_FIELD, SPEC_FIELD, STATUS_FIELD, VIRTUAL_GATEWAY_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String gatewayRouteName;

    private final String meshName;

    private final ResourceMetadata metadata;

    private final GatewayRouteSpec spec;

    private final GatewayRouteStatus status;

    private final String virtualGatewayName;

    private GatewayRouteData(BuilderImpl builder) {
        this.gatewayRouteName = builder.gatewayRouteName;
        this.meshName = builder.meshName;
        this.metadata = builder.metadata;
        this.spec = builder.spec;
        this.status = builder.status;
        this.virtualGatewayName = builder.virtualGatewayName;
    }

    /**
     * <p>
     * The name of the gateway route.
     * </p>
     * 
     * @return The name of the gateway route.
     */
    public String gatewayRouteName() {
        return gatewayRouteName;
    }

    /**
     * <p>
     * The name of the service mesh that the resource resides in.
     * </p>
     * 
     * @return The name of the service mesh that the resource resides in.
     */
    public String meshName() {
        return meshName;
    }

    /**
     * Returns the value of the Metadata property for this object.
     * 
     * @return The value of the Metadata property for this object.
     */
    public ResourceMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * The specifications of the gateway route.
     * </p>
     * 
     * @return The specifications of the gateway route.
     */
    public GatewayRouteSpec spec() {
        return spec;
    }

    /**
     * <p>
     * The status of the gateway route.
     * </p>
     * 
     * @return The status of the gateway route.
     */
    public GatewayRouteStatus status() {
        return status;
    }

    /**
     * <p>
     * The virtual gateway that the gateway route is associated with.
     * </p>
     * 
     * @return The virtual gateway that the gateway route is associated with.
     */
    public String virtualGatewayName() {
        return virtualGatewayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gatewayRouteName());
        hashCode = 31 * hashCode + Objects.hashCode(meshName());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(spec());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(virtualGatewayName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewayRouteData)) {
            return false;
        }
        GatewayRouteData other = (GatewayRouteData) obj;
        return Objects.equals(gatewayRouteName(), other.gatewayRouteName()) && Objects.equals(meshName(), other.meshName())
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(spec(), other.spec())
                && Objects.equals(status(), other.status()) && Objects.equals(virtualGatewayName(), other.virtualGatewayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GatewayRouteData").add("GatewayRouteName", gatewayRouteName()).add("MeshName", meshName())
                .add("Metadata", metadata()).add("Spec", spec()).add("Status", status())
                .add("VirtualGatewayName", virtualGatewayName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gatewayRouteName":
            return Optional.ofNullable(clazz.cast(gatewayRouteName()));
        case "meshName":
            return Optional.ofNullable(clazz.cast(meshName()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "spec":
            return Optional.ofNullable(clazz.cast(spec()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "virtualGatewayName":
            return Optional.ofNullable(clazz.cast(virtualGatewayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GatewayRouteData, T> g) {
        return obj -> g.apply((GatewayRouteData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GatewayRouteData> {
        /**
         * <p>
         * The name of the gateway route.
         * </p>
         * 
         * @param gatewayRouteName
         *        The name of the gateway route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayRouteName(String gatewayRouteName);

        /**
         * <p>
         * The name of the service mesh that the resource resides in.
         * </p>
         * 
         * @param meshName
         *        The name of the service mesh that the resource resides in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshName(String meshName);

        /**
         * Sets the value of the Metadata property for this object.
         *
         * @param metadata
         *        The new value for the Metadata property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(ResourceMetadata metadata);

        /**
         * Sets the value of the Metadata property for this object.
         *
         * This is a convenience that creates an instance of the {@link ResourceMetadata.Builder} avoiding the need to
         * create one manually via {@link ResourceMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #metadata(ResourceMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link ResourceMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(ResourceMetadata)
         */
        default Builder metadata(Consumer<ResourceMetadata.Builder> metadata) {
            return metadata(ResourceMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * The specifications of the gateway route.
         * </p>
         * 
         * @param spec
         *        The specifications of the gateway route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spec(GatewayRouteSpec spec);

        /**
         * <p>
         * The specifications of the gateway route.
         * </p>
         * This is a convenience that creates an instance of the {@link GatewayRouteSpec.Builder} avoiding the need to
         * create one manually via {@link GatewayRouteSpec#builder()}.
         *
         * When the {@link Consumer} completes, {@link GatewayRouteSpec.Builder#build()} is called immediately and its
         * result is passed to {@link #spec(GatewayRouteSpec)}.
         * 
         * @param spec
         *        a consumer that will call methods on {@link GatewayRouteSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spec(GatewayRouteSpec)
         */
        default Builder spec(Consumer<GatewayRouteSpec.Builder> spec) {
            return spec(GatewayRouteSpec.builder().applyMutation(spec).build());
        }

        /**
         * <p>
         * The status of the gateway route.
         * </p>
         * 
         * @param status
         *        The status of the gateway route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(GatewayRouteStatus status);

        /**
         * <p>
         * The status of the gateway route.
         * </p>
         * This is a convenience that creates an instance of the {@link GatewayRouteStatus.Builder} avoiding the need to
         * create one manually via {@link GatewayRouteStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link GatewayRouteStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(GatewayRouteStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link GatewayRouteStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(GatewayRouteStatus)
         */
        default Builder status(Consumer<GatewayRouteStatus.Builder> status) {
            return status(GatewayRouteStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The virtual gateway that the gateway route is associated with.
         * </p>
         * 
         * @param virtualGatewayName
         *        The virtual gateway that the gateway route is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualGatewayName(String virtualGatewayName);
    }

    static final class BuilderImpl implements Builder {
        private String gatewayRouteName;

        private String meshName;

        private ResourceMetadata metadata;

        private GatewayRouteSpec spec;

        private GatewayRouteStatus status;

        private String virtualGatewayName;

        private BuilderImpl() {
        }

        private BuilderImpl(GatewayRouteData model) {
            gatewayRouteName(model.gatewayRouteName);
            meshName(model.meshName);
            metadata(model.metadata);
            spec(model.spec);
            status(model.status);
            virtualGatewayName(model.virtualGatewayName);
        }

        public final String getGatewayRouteName() {
            return gatewayRouteName;
        }

        @Override
        public final Builder gatewayRouteName(String gatewayRouteName) {
            this.gatewayRouteName = gatewayRouteName;
            return this;
        }

        public final void setGatewayRouteName(String gatewayRouteName) {
            this.gatewayRouteName = gatewayRouteName;
        }

        public final String getMeshName() {
            return meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final ResourceMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        @Override
        public final Builder metadata(ResourceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(ResourceMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        public final GatewayRouteSpec.Builder getSpec() {
            return spec != null ? spec.toBuilder() : null;
        }

        @Override
        public final Builder spec(GatewayRouteSpec spec) {
            this.spec = spec;
            return this;
        }

        public final void setSpec(GatewayRouteSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        public final GatewayRouteStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        @Override
        public final Builder status(GatewayRouteStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(GatewayRouteStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final String getVirtualGatewayName() {
            return virtualGatewayName;
        }

        @Override
        public final Builder virtualGatewayName(String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
            return this;
        }

        public final void setVirtualGatewayName(String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
        }

        @Override
        public GatewayRouteData build() {
            return new GatewayRouteData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
