/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVirtualRouterRequest extends AppMeshRequest implements
        ToCopyableBuilder<CreateVirtualRouterRequest.Builder, CreateVirtualRouterRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateVirtualRouterRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> MESH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("meshName").getter(getter(CreateVirtualRouterRequest::meshName)).setter(setter(Builder::meshName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("meshName").build()).build();

    private static final SdkField<String> MESH_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("meshOwner").getter(getter(CreateVirtualRouterRequest::meshOwner)).setter(setter(Builder::meshOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("meshOwner").build()).build();

    private static final SdkField<VirtualRouterSpec> SPEC_FIELD = SdkField.<VirtualRouterSpec> builder(MarshallingType.SDK_POJO)
            .memberName("spec").getter(getter(CreateVirtualRouterRequest::spec)).setter(setter(Builder::spec))
            .constructor(VirtualRouterSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()).build();

    private static final SdkField<List<TagRef>> TAGS_FIELD = SdkField
            .<List<TagRef>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateVirtualRouterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagRef> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagRef::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VIRTUAL_ROUTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualRouterName").getter(getter(CreateVirtualRouterRequest::virtualRouterName))
            .setter(setter(Builder::virtualRouterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualRouterName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            MESH_NAME_FIELD, MESH_OWNER_FIELD, SPEC_FIELD, TAGS_FIELD, VIRTUAL_ROUTER_NAME_FIELD));

    private final String clientToken;

    private final String meshName;

    private final String meshOwner;

    private final VirtualRouterSpec spec;

    private final List<TagRef> tags;

    private final String virtualRouterName;

    private CreateVirtualRouterRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.meshName = builder.meshName;
        this.meshOwner = builder.meshOwner;
        this.spec = builder.spec;
        this.tags = builder.tags;
        this.virtualRouterName = builder.virtualRouterName;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters,
     * numbers, hyphens, and underscores are allowed.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36
     *         letters, numbers, hyphens, and underscores are allowed.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The name of the service mesh to create the virtual router in.
     * </p>
     * 
     * @return The name of the service mesh to create the virtual router in.
     */
    public String meshName() {
        return meshName;
    }

    /**
     * <p>
     * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you
     * specify must share the mesh with your account before you can create the resource in the service mesh. For more
     * information about mesh sharing, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
     * </p>
     * 
     * @return The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account
     *         that you specify must share the mesh with your account before you can create the resource in the service
     *         mesh. For more information about mesh sharing, see <a
     *         href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
     */
    public String meshOwner() {
        return meshOwner;
    }

    /**
     * <p>
     * The virtual router specification to apply.
     * </p>
     * 
     * @return The virtual router specification to apply.
     */
    public VirtualRouterSpec spec() {
        return spec;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional metadata that you can apply to the virtual router to assist with categorization and organization. Each
     * tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character
     * length of 128 characters, and tag values can have a maximum length of 256 characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Optional metadata that you can apply to the virtual router to assist with categorization and
     *         organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can
     *         have a maximum character length of 128 characters, and tag values can have a maximum length of 256
     *         characters.
     */
    public List<TagRef> tags() {
        return tags;
    }

    /**
     * <p>
     * The name to use for the virtual router.
     * </p>
     * 
     * @return The name to use for the virtual router.
     */
    public String virtualRouterName() {
        return virtualRouterName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(meshName());
        hashCode = 31 * hashCode + Objects.hashCode(meshOwner());
        hashCode = 31 * hashCode + Objects.hashCode(spec());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(virtualRouterName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVirtualRouterRequest)) {
            return false;
        }
        CreateVirtualRouterRequest other = (CreateVirtualRouterRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(meshName(), other.meshName())
                && Objects.equals(meshOwner(), other.meshOwner()) && Objects.equals(spec(), other.spec())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(virtualRouterName(), other.virtualRouterName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateVirtualRouterRequest").add("ClientToken", clientToken()).add("MeshName", meshName())
                .add("MeshOwner", meshOwner()).add("Spec", spec()).add("Tags", hasTags() ? tags() : null)
                .add("VirtualRouterName", virtualRouterName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "meshName":
            return Optional.ofNullable(clazz.cast(meshName()));
        case "meshOwner":
            return Optional.ofNullable(clazz.cast(meshOwner()));
        case "spec":
            return Optional.ofNullable(clazz.cast(spec()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "virtualRouterName":
            return Optional.ofNullable(clazz.cast(virtualRouterName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVirtualRouterRequest, T> g) {
        return obj -> g.apply((CreateVirtualRouterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateVirtualRouterRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36
         * letters, numbers, hyphens, and underscores are allowed.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36
         *        letters, numbers, hyphens, and underscores are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The name of the service mesh to create the virtual router in.
         * </p>
         * 
         * @param meshName
         *        The name of the service mesh to create the virtual router in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshName(String meshName);

        /**
         * <p>
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that
         * you specify must share the mesh with your account before you can create the resource in the service mesh. For
         * more information about mesh sharing, see <a
         * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
         * </p>
         * 
         * @param meshOwner
         *        The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account
         *        that you specify must share the mesh with your account before you can create the resource in the
         *        service mesh. For more information about mesh sharing, see <a
         *        href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared
         *        meshes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshOwner(String meshOwner);

        /**
         * <p>
         * The virtual router specification to apply.
         * </p>
         * 
         * @param spec
         *        The virtual router specification to apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spec(VirtualRouterSpec spec);

        /**
         * <p>
         * The virtual router specification to apply.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualRouterSpec.Builder} avoiding the need to
         * create one manually via {@link VirtualRouterSpec#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualRouterSpec.Builder#build()} is called immediately and its
         * result is passed to {@link #spec(VirtualRouterSpec)}.
         * 
         * @param spec
         *        a consumer that will call methods on {@link VirtualRouterSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spec(VirtualRouterSpec)
         */
        default Builder spec(Consumer<VirtualRouterSpec.Builder> spec) {
            return spec(VirtualRouterSpec.builder().applyMutation(spec).build());
        }

        /**
         * <p>
         * Optional metadata that you can apply to the virtual router to assist with categorization and organization.
         * Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum
         * character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * </p>
         * 
         * @param tags
         *        Optional metadata that you can apply to the virtual router to assist with categorization and
         *        organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can
         *        have a maximum character length of 128 characters, and tag values can have a maximum length of 256
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagRef> tags);

        /**
         * <p>
         * Optional metadata that you can apply to the virtual router to assist with categorization and organization.
         * Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum
         * character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * </p>
         * 
         * @param tags
         *        Optional metadata that you can apply to the virtual router to assist with categorization and
         *        organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can
         *        have a maximum character length of 128 characters, and tag values can have a maximum length of 256
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagRef... tags);

        /**
         * <p>
         * Optional metadata that you can apply to the virtual router to assist with categorization and organization.
         * Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum
         * character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagRef>.Builder} avoiding the need to
         * create one manually via {@link List<TagRef>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagRef>.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<TagRef>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<TagRef>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<TagRef>)
         */
        Builder tags(Consumer<TagRef.Builder>... tags);

        /**
         * <p>
         * The name to use for the virtual router.
         * </p>
         * 
         * @param virtualRouterName
         *        The name to use for the virtual router.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualRouterName(String virtualRouterName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppMeshRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String meshName;

        private String meshOwner;

        private VirtualRouterSpec spec;

        private List<TagRef> tags = DefaultSdkAutoConstructList.getInstance();

        private String virtualRouterName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVirtualRouterRequest model) {
            super(model);
            clientToken(model.clientToken);
            meshName(model.meshName);
            meshOwner(model.meshOwner);
            spec(model.spec);
            tags(model.tags);
            virtualRouterName(model.virtualRouterName);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getMeshName() {
            return meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final String getMeshOwner() {
            return meshOwner;
        }

        @Override
        public final Builder meshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
            return this;
        }

        public final void setMeshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
        }

        public final VirtualRouterSpec.Builder getSpec() {
            return spec != null ? spec.toBuilder() : null;
        }

        @Override
        public final Builder spec(VirtualRouterSpec spec) {
            this.spec = spec;
            return this;
        }

        public final void setSpec(VirtualRouterSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        public final Collection<TagRef.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(TagRef::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<TagRef> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagRef... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagRef.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagRef.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<TagRef.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVirtualRouterName() {
            return virtualRouterName;
        }

        @Override
        public final Builder virtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
            return this;
        }

        public final void setVirtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVirtualRouterRequest build() {
            return new CreateVirtualRouterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
