/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents types of timeouts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpTimeout implements SdkPojo, Serializable, ToCopyableBuilder<HttpTimeout.Builder, HttpTimeout> {
    private static final SdkField<Duration> IDLE_FIELD = SdkField.<Duration> builder(MarshallingType.SDK_POJO).memberName("idle")
            .getter(getter(HttpTimeout::idle)).setter(setter(Builder::idle)).constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idle").build()).build();

    private static final SdkField<Duration> PER_REQUEST_FIELD = SdkField.<Duration> builder(MarshallingType.SDK_POJO)
            .memberName("perRequest").getter(getter(HttpTimeout::perRequest)).setter(setter(Builder::perRequest))
            .constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("perRequest").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(IDLE_FIELD, PER_REQUEST_FIELD));

    private static final long serialVersionUID = 1L;

    private final Duration idle;

    private final Duration perRequest;

    private HttpTimeout(BuilderImpl builder) {
        this.idle = builder.idle;
        this.perRequest = builder.perRequest;
    }

    /**
     * Returns the value of the Idle property for this object.
     * 
     * @return The value of the Idle property for this object.
     */
    public Duration idle() {
        return idle;
    }

    /**
     * Returns the value of the PerRequest property for this object.
     * 
     * @return The value of the PerRequest property for this object.
     */
    public Duration perRequest() {
        return perRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(idle());
        hashCode = 31 * hashCode + Objects.hashCode(perRequest());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpTimeout)) {
            return false;
        }
        HttpTimeout other = (HttpTimeout) obj;
        return Objects.equals(idle(), other.idle()) && Objects.equals(perRequest(), other.perRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HttpTimeout").add("Idle", idle()).add("PerRequest", perRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "idle":
            return Optional.ofNullable(clazz.cast(idle()));
        case "perRequest":
            return Optional.ofNullable(clazz.cast(perRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpTimeout, T> g) {
        return obj -> g.apply((HttpTimeout) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpTimeout> {
        /**
         * Sets the value of the Idle property for this object.
         *
         * @param idle
         *        The new value for the Idle property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idle(Duration idle);

        /**
         * Sets the value of the Idle property for this object.
         *
         * This is a convenience that creates an instance of the {@link Duration.Builder} avoiding the need to create
         * one manually via {@link Duration#builder()}.
         *
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #idle(Duration)}.
         * 
         * @param idle
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #idle(Duration)
         */
        default Builder idle(Consumer<Duration.Builder> idle) {
            return idle(Duration.builder().applyMutation(idle).build());
        }

        /**
         * Sets the value of the PerRequest property for this object.
         *
         * @param perRequest
         *        The new value for the PerRequest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder perRequest(Duration perRequest);

        /**
         * Sets the value of the PerRequest property for this object.
         *
         * This is a convenience that creates an instance of the {@link Duration.Builder} avoiding the need to create
         * one manually via {@link Duration#builder()}.
         *
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #perRequest(Duration)}.
         * 
         * @param perRequest
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #perRequest(Duration)
         */
        default Builder perRequest(Consumer<Duration.Builder> perRequest) {
            return perRequest(Duration.builder().applyMutation(perRequest).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Duration idle;

        private Duration perRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpTimeout model) {
            idle(model.idle);
            perRequest(model.perRequest);
        }

        public final Duration.Builder getIdle() {
            return idle != null ? idle.toBuilder() : null;
        }

        @Override
        public final Builder idle(Duration idle) {
            this.idle = idle;
            return this;
        }

        public final void setIdle(Duration.BuilderImpl idle) {
            this.idle = idle != null ? idle.build() : null;
        }

        public final Duration.Builder getPerRequest() {
            return perRequest != null ? perRequest.toBuilder() : null;
        }

        @Override
        public final Builder perRequest(Duration perRequest) {
            this.perRequest = perRequest;
            return this;
        }

        public final void setPerRequest(Duration.BuilderImpl perRequest) {
            this.perRequest = perRequest != null ? perRequest.build() : null;
        }

        @Override
        public HttpTimeout build() {
            return new HttpTimeout(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
