/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a local file certificate. The certificate must meet specific requirements and you must have
 * proxy authorization enabled. For more information, see <a
 * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites">Transport Layer
 * Security (TLS)</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualGatewayListenerTlsFileCertificate implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualGatewayListenerTlsFileCertificate.Builder, VirtualGatewayListenerTlsFileCertificate> {
    private static final SdkField<String> CERTIFICATE_CHAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateChain").getter(getter(VirtualGatewayListenerTlsFileCertificate::certificateChain))
            .setter(setter(Builder::certificateChain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateChain").build()).build();

    private static final SdkField<String> PRIVATE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("privateKey").getter(getter(VirtualGatewayListenerTlsFileCertificate::privateKey))
            .setter(setter(Builder::privateKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_CHAIN_FIELD,
            PRIVATE_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String certificateChain;

    private final String privateKey;

    private VirtualGatewayListenerTlsFileCertificate(BuilderImpl builder) {
        this.certificateChain = builder.certificateChain;
        this.privateKey = builder.privateKey;
    }

    /**
     * <p>
     * The certificate chain for the certificate.
     * </p>
     * 
     * @return The certificate chain for the certificate.
     */
    public String certificateChain() {
        return certificateChain;
    }

    /**
     * <p>
     * The private key for a certificate stored on the file system of the mesh endpoint that the proxy is running on.
     * </p>
     * 
     * @return The private key for a certificate stored on the file system of the mesh endpoint that the proxy is
     *         running on.
     */
    public String privateKey() {
        return privateKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateChain());
        hashCode = 31 * hashCode + Objects.hashCode(privateKey());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayListenerTlsFileCertificate)) {
            return false;
        }
        VirtualGatewayListenerTlsFileCertificate other = (VirtualGatewayListenerTlsFileCertificate) obj;
        return Objects.equals(certificateChain(), other.certificateChain()) && Objects.equals(privateKey(), other.privateKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VirtualGatewayListenerTlsFileCertificate").add("CertificateChain", certificateChain())
                .add("PrivateKey", privateKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateChain":
            return Optional.ofNullable(clazz.cast(certificateChain()));
        case "privateKey":
            return Optional.ofNullable(clazz.cast(privateKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayListenerTlsFileCertificate, T> g) {
        return obj -> g.apply((VirtualGatewayListenerTlsFileCertificate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualGatewayListenerTlsFileCertificate> {
        /**
         * <p>
         * The certificate chain for the certificate.
         * </p>
         * 
         * @param certificateChain
         *        The certificate chain for the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateChain(String certificateChain);

        /**
         * <p>
         * The private key for a certificate stored on the file system of the mesh endpoint that the proxy is running
         * on.
         * </p>
         * 
         * @param privateKey
         *        The private key for a certificate stored on the file system of the mesh endpoint that the proxy is
         *        running on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKey(String privateKey);
    }

    static final class BuilderImpl implements Builder {
        private String certificateChain;

        private String privateKey;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayListenerTlsFileCertificate model) {
            certificateChain(model.certificateChain);
            privateKey(model.privateKey);
        }

        public final String getCertificateChain() {
            return certificateChain;
        }

        @Override
        public final Builder certificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
            return this;
        }

        public final void setCertificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
        }

        public final String getPrivateKey() {
            return privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        @Override
        public VirtualGatewayListenerTlsFileCertificate build() {
            return new VirtualGatewayListenerTlsFileCertificate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
