/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a Transport Layer Security (TLS) validation context.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualGatewayTlsValidationContext implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualGatewayTlsValidationContext.Builder, VirtualGatewayTlsValidationContext> {
    private static final SdkField<VirtualGatewayTlsValidationContextTrust> TRUST_FIELD = SdkField
            .<VirtualGatewayTlsValidationContextTrust> builder(MarshallingType.SDK_POJO).memberName("trust")
            .getter(getter(VirtualGatewayTlsValidationContext::trust)).setter(setter(Builder::trust))
            .constructor(VirtualGatewayTlsValidationContextTrust::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trust").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_FIELD));

    private static final long serialVersionUID = 1L;

    private final VirtualGatewayTlsValidationContextTrust trust;

    private VirtualGatewayTlsValidationContext(BuilderImpl builder) {
        this.trust = builder.trust;
    }

    /**
     * <p>
     * A reference to an object that represents a TLS validation context trust.
     * </p>
     * 
     * @return A reference to an object that represents a TLS validation context trust.
     */
    public VirtualGatewayTlsValidationContextTrust trust() {
        return trust;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trust());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayTlsValidationContext)) {
            return false;
        }
        VirtualGatewayTlsValidationContext other = (VirtualGatewayTlsValidationContext) obj;
        return Objects.equals(trust(), other.trust());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VirtualGatewayTlsValidationContext").add("Trust", trust()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trust":
            return Optional.ofNullable(clazz.cast(trust()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayTlsValidationContext, T> g) {
        return obj -> g.apply((VirtualGatewayTlsValidationContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualGatewayTlsValidationContext> {
        /**
         * <p>
         * A reference to an object that represents a TLS validation context trust.
         * </p>
         * 
         * @param trust
         *        A reference to an object that represents a TLS validation context trust.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trust(VirtualGatewayTlsValidationContextTrust trust);

        /**
         * <p>
         * A reference to an object that represents a TLS validation context trust.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualGatewayTlsValidationContextTrust.Builder}
         * avoiding the need to create one manually via {@link VirtualGatewayTlsValidationContextTrust#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayTlsValidationContextTrust.Builder#build()} is
         * called immediately and its result is passed to {@link #trust(VirtualGatewayTlsValidationContextTrust)}.
         * 
         * @param trust
         *        a consumer that will call methods on {@link VirtualGatewayTlsValidationContextTrust.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trust(VirtualGatewayTlsValidationContextTrust)
         */
        default Builder trust(Consumer<VirtualGatewayTlsValidationContextTrust.Builder> trust) {
            return trust(VirtualGatewayTlsValidationContextTrust.builder().applyMutation(trust).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VirtualGatewayTlsValidationContextTrust trust;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayTlsValidationContext model) {
            trust(model.trust);
        }

        public final VirtualGatewayTlsValidationContextTrust.Builder getTrust() {
            return trust != null ? trust.toBuilder() : null;
        }

        @Override
        public final Builder trust(VirtualGatewayTlsValidationContextTrust trust) {
            this.trust = trust;
            return this;
        }

        public final void setTrust(VirtualGatewayTlsValidationContextTrust.BuilderImpl trust) {
            this.trust = trust != null ? trust.build() : null;
        }

        @Override
        public VirtualGatewayTlsValidationContext build() {
            return new VirtualGatewayTlsValidationContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
